/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util.linkeddata;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.util.linkeddata.CachingLinkedDataSource;

public class CachingAllButListsLinkedDataSource
extends CachingLinkedDataSource {
    private Pattern pattern_connections_list_uri = Pattern.compile("(.+)/connections(/)?");
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public Dataset getDataForResource(URI resource) {
        if (this.isCachingAllowed(resource)) {
            return super.getDataForResource(resource);
        }
        Dataset dataset = this.linkedDataRestClient.readResourceData(resource);
        logger.info("connections list uri request performed");
        return dataset;
    }

    @Override
    public Dataset getDataForResource(URI resource, URI requesterWebID) {
        if (this.isCachingAllowed(resource)) {
            return super.getDataForResource(resource, requesterWebID);
        }
        Dataset dataset = this.linkedDataRestClient.readResourceData(resource, requesterWebID);
        logger.info("connections list uri request performed");
        return dataset;
    }

    private boolean isCachingAllowed(Pattern noCachePattern, URI resource) {
        Matcher matcher = noCachePattern.matcher(resource.toString());
        return !matcher.matches();
    }

    private boolean isCachingAllowed(URI resource) {
        return this.isCachingAllowed(this.pattern_connections_list_uri, resource);
    }
}

