/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util;

import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathParser;
import org.apache.jena.tdb.TDB;
import org.apache.jena.vocabulary.RDF;
import org.hibernate.cfg.NotYetImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.exception.IncorrectPropertyCountException;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonSignatureData;
import won.protocol.model.AtomGraphType;
import won.protocol.model.ConnectionState;
import won.protocol.model.SocketDefinitionImpl;
import won.protocol.service.WonNodeInfo;
import won.protocol.service.WonNodeInfoBuilder;
import won.protocol.util.AtomModelWrapper;
import won.protocol.util.DefaultPrefixUtils;
import won.protocol.util.RdfUtils;
import won.protocol.vocabulary.SCHEMA;
import won.protocol.vocabulary.SFSIG;
import won.protocol.vocabulary.WON;
import won.protocol.vocabulary.WONAGR;
import won.protocol.vocabulary.WONCON;
import won.protocol.vocabulary.WONMOD;
import won.protocol.vocabulary.WONMSG;

public class WonRdfUtils {
    public static final String NAMED_GRAPH_SUFFIX = "#data";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private static Model createModelWithBaseResource() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("", "no:uri");
        model.createResource(model.getNsPrefixURI(""));
        return model;
    }

    public static class AtomUtils {
        public static URI getAtomURI(Dataset dataset) {
            return RdfUtils.findOne(dataset, new RdfUtils.ModelVisitor<URI>(){

                @Override
                public URI visit(Model model) {
                    return AtomUtils.getAtomURI(model);
                }
            }, true);
        }

        public static URI getAtomURI(Model model) {
            Resource res = AtomUtils.getAtomResource(model);
            return res == null ? null : URI.create(res.getURI());
        }

        public static Resource getAtomResource(Model model) {
            ArrayList<Object> atomURIs = new ArrayList<Object>();
            ResIterator iterator = model.listSubjectsWithProperty(RDF.type, (RDFNode)WON.Atom);
            while (iterator.hasNext()) {
                atomURIs.add(iterator.next());
            }
            if (atomURIs.size() == 0) {
                return null;
            }
            if (atomURIs.size() == 1) {
                return (Resource)atomURIs.get(0);
            }
            if (atomURIs.size() > 1) {
                Resource u = (Resource)atomURIs.get(0);
                for (Resource resource : atomURIs) {
                    if (resource.equals((Object)u)) continue;
                    throw new IncorrectPropertyCountException(1, 2);
                }
                return u;
            }
            return null;
        }

        public static Resource getAtomResource(Dataset dataset) {
            Model model = new AtomModelWrapper(dataset).copyAtomModel(AtomGraphType.ATOM);
            return AtomUtils.getAtomResource(model);
        }

        public static URI getWonNodeURIFromAtom(Dataset dataset, URI atomURI) {
            return URI.create(RdfUtils.findOnePropertyFromResource(dataset, atomURI, WON.wonNode).asResource().getURI());
        }

        public static Iterator<URI> getConnectedAtoms(Dataset dataset, URI atomURI) {
            PrefixMappingImpl pmap = new PrefixMappingImpl();
            pmap.withDefaultMappings(PrefixMapping.Standard);
            pmap.setNsPrefix("won", WON.getURI());
            pmap.setNsPrefix("msg", WONMSG.getURI());
            Path path = PathParser.parse((String)"won:hasConnectionContainer/rdfs:member/won:targetAtom", (PrefixMapping)pmap);
            return RdfUtils.getURIsForPropertyPath(dataset, atomURI, path);
        }

        public static Set<URI> getTargetConnectionURIsForTargetAtoms(Dataset dataset, Collection<URI> targetAtoms, Optional<ConnectionState> state) {
            Optional unions = targetAtoms.stream().map(uri -> {
                BasicPattern pattern = new BasicPattern();
                pattern.add(Triple.create((Node)Var.alloc((String)"localCon"), (Node)NodeFactory.createURI((String)"https://w3id.org/won/core#targetAtom"), (Node)NodeFactory.createURI((String)uri.toString())));
                pattern.add(Triple.create((Node)Var.alloc((String)"localCon"), (Node)NodeFactory.createURI((String)"https://w3id.org/won/core#targetConnection"), (Node)Var.alloc((String)"remoteCon")));
                if (state.isPresent()) {
                    pattern.add(Triple.create((Node)Var.alloc((String)"localCon"), (Node)NodeFactory.createURI((String)"https://w3id.org/won/core#connectionState"), (Node)NodeFactory.createURI((String)((ConnectionState)((Object)((Object)state.get()))).getURI().toString())));
                }
                return pattern;
            }).map(pattern -> new OpBGP(pattern)).map(bgp -> new OpGraph((Node)Var.alloc((String)"g"), (Op)bgp)).reduce(Optional.empty(), (union, pattern) -> {
                if (!union.isPresent()) {
                    return Optional.of(pattern);
                }
                return Optional.of(new OpUnion((Op)union.get(), (Op)pattern));
            }, (union1, union2) -> {
                if (!union1.isPresent()) {
                    return union2;
                }
                if (!union2.isPresent()) {
                    return union1;
                }
                return Optional.of(new OpUnion((Op)union1.get(), (Op)union2.get()));
            });
            if (!unions.isPresent()) {
                return Collections.EMPTY_SET;
            }
            OpProject op = new OpProject((Op)unions.get(), Collections.singletonList(Var.alloc((String)"remoteCon")));
            Query q = OpAsQuery.asQuery((Op)op);
            q.setQuerySelectType();
            HashSet<URI> result = new HashSet<URI>();
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)q, (Dataset)dataset);){
                ResultSet resultSet = qexec.execSelect();
                while (resultSet.hasNext()) {
                    QuerySolution solution = resultSet.next();
                    result.add(URI.create(solution.get("remoteCon").asResource().getURI()));
                }
            }
            return result;
        }
    }

    public static class ConnectionUtils {
        public static boolean isConnected(Dataset connectionDataset, URI connectionUri) {
            URI connectionState = ConnectionUtils.getConnectionState(connectionDataset, connectionUri);
            return ConnectionState.CONNECTED.getURI().equals(connectionState);
        }

        public static URI getConnectionState(Dataset connectionDataset, URI connectionUri) {
            Path statePath = PathParser.parse((String)"won:connectionState", (PrefixMapping)DefaultPrefixUtils.getDefaultPrefixes());
            return RdfUtils.getURIPropertyForPropertyPath(connectionDataset, connectionUri, statePath);
        }

        public static URI getLocalAtomURIFromConnection(Dataset dataset, URI connectionURI) {
            return URI.create(RdfUtils.findOnePropertyFromResource(dataset, connectionURI, WON.sourceAtom).asResource().getURI());
        }

        public static URI getTargetAtomURIFromConnection(Dataset dataset, URI connectionURI) {
            return URI.create(RdfUtils.findOnePropertyFromResource(dataset, connectionURI, WON.targetAtom).asResource().getURI());
        }

        public static URI getWonNodeURIFromConnection(Dataset dataset, URI connectionURI) {
            return URI.create(RdfUtils.findOnePropertyFromResource(dataset, connectionURI, WON.wonNode).asResource().getURI());
        }

        public static URI getWonNodeURIFromAtom(Dataset dataset, URI atomURI) {
            return URI.create(RdfUtils.findOnePropertyFromResource(dataset, atomURI, WON.wonNode).asResource().getURI());
        }

        public static URI getTargetConnectionURIFromConnection(Dataset dataset, URI connectionURI) {
            return URI.create(RdfUtils.findOnePropertyFromResource(dataset, connectionURI, WON.targetConnection).asResource().getURI());
        }

        public static URI getLastMessageSentByLocalAtom(Dataset dataset, URI connectionURI) {
            throw new NotYetImplementedException();
        }

        public static URI getLastMessageSentByTargetAtom(Dataset dataset, URI connectionURI) {
            throw new NotYetImplementedException();
        }

        public static List<URI> getMessageURIs() {
            throw new NotYetImplementedException();
        }
    }

    public static class SocketUtils {
        public static URI getSocket(WonMessage message) {
            if (message.getEnvelopeType() == WonMessageDirection.FROM_EXTERNAL) {
                return message.getRecipientSocketURI();
            }
            return message.getSenderSocketURI();
        }

        public static URI getTargetSocket(WonMessage message) {
            if (message.getEnvelopeType() == WonMessageDirection.FROM_EXTERNAL) {
                return message.getSenderSocketURI();
            }
            return message.getRecipientSocketURI();
        }

        public static Set<RdfUtils.Pair<URI>> getCompatibleSocketsForAtoms(Dataset dataset, URI firstAtom, URI secondAtom) {
            Set<URI> firstAtomSockets = SocketUtils.getSocketsOfAtom(dataset, firstAtom);
            Set<URI> secondAtomSockets = SocketUtils.getSocketsOfAtom(dataset, secondAtom);
            HashSet<RdfUtils.Pair<URI>> ret = new HashSet<RdfUtils.Pair<URI>>();
            firstAtomSockets.forEach(firstAtomSocket -> secondAtomSockets.forEach(secondAtomSocket -> {
                if (SocketUtils.isSocketsCompatible(dataset, firstAtomSocket, secondAtomSocket)) {
                    ret.add(new RdfUtils.Pair<URI>((URI)firstAtomSocket, (URI)secondAtomSocket));
                }
            }));
            return ret;
        }

        public static Set<RdfUtils.Pair<URI>> getIncompatibleSocketsForAtoms(Dataset dataset, URI firstAtom, URI secondAtom) {
            Set<URI> firstAtomSockets = SocketUtils.getSocketsOfAtom(dataset, firstAtom);
            Set<URI> secondAtomSockets = SocketUtils.getSocketsOfAtom(dataset, secondAtom);
            HashSet<RdfUtils.Pair<URI>> ret = new HashSet<RdfUtils.Pair<URI>>();
            firstAtomSockets.forEach(firstAtomSocket -> secondAtomSockets.forEach(secondAtomSocket -> {
                if (!SocketUtils.isSocketsCompatible(dataset, firstAtomSocket, secondAtomSocket)) {
                    ret.add(new RdfUtils.Pair<URI>((URI)firstAtomSocket, (URI)secondAtomSocket));
                }
            }));
            return ret;
        }

        public static boolean isSocketsCompatible(Dataset dataset, URI firstAtomSocket, URI secondAtomSocket) {
            Set<URI> firstCompatibleDefs = SocketUtils.getCompatibleSocketDefinitions(dataset, firstAtomSocket);
            Optional<URI> secondDef = SocketUtils.getSocketDefinition(dataset, secondAtomSocket);
            if (!secondDef.isPresent()) {
                throw new IllegalArgumentException("No socket definition found for " + secondAtomSocket);
            }
            if (!firstCompatibleDefs.isEmpty() && !firstCompatibleDefs.contains(secondDef.get())) {
                return false;
            }
            Set<URI> secondCompatibleDefs = SocketUtils.getCompatibleSocketDefinitions(dataset, secondAtomSocket);
            Optional<URI> firstDef = SocketUtils.getSocketDefinition(dataset, firstAtomSocket);
            if (!firstDef.isPresent()) {
                throw new IllegalArgumentException("No socket definition found for " + firstAtomSocket);
            }
            return secondCompatibleDefs.isEmpty() || secondCompatibleDefs.contains(firstDef.get());
        }

        public static Optional<URI> getSocketDefinition(Dataset dataset, URI socket) {
            return RdfUtils.getObjectStreamOfProperty(dataset, socket, URI.create(WON.socketDefinition.getURI()), node -> node.isURIResource() ? URI.create(node.asResource().getURI()) : null).findFirst();
        }

        private static URI getObjectOfMessageProperty(WonMessage message, Property property) {
            List<String> contentGraphUris = message.getContentGraphURIs();
            Dataset contentGraphs = message.getMessageContent();
            URI messageURI = message.getMessageURI();
            for (String graphUri : contentGraphUris) {
                Model contentGraph = contentGraphs.getNamedModel(graphUri);
                StmtIterator smtIter = contentGraph.getResource(messageURI.toString()).listProperties(property);
                if (!smtIter.hasNext()) continue;
                return URI.create(smtIter.nextStatement().getObject().asResource().getURI());
            }
            return null;
        }

        private static URI getObjectOfRemoteMessageProperty(WonMessage message, Property property) {
            List<String> contentGraphUris = message.getContentGraphURIs();
            Dataset contentGraphs = message.getMessageContent();
            URI messageURI = message.getCorrespondingRemoteMessageURI();
            if (messageURI != null) {
                for (String graphUri : contentGraphUris) {
                    Model contentGraph = contentGraphs.getNamedModel(graphUri);
                    StmtIterator smtIter = contentGraph.getResource(messageURI.toString()).listProperties(property);
                    if (!smtIter.hasNext()) continue;
                    return URI.create(smtIter.nextStatement().getObject().asResource().getURI());
                }
            }
            return null;
        }

        public static Collection<URI> getSockets(Model content) {
            Resource baseRes = RdfUtils.getBaseResource(content);
            StmtIterator stmtIterator = baseRes.listProperties(WON.socket);
            LinkedList<URI> ret = new LinkedList<URI>();
            while (stmtIterator.hasNext()) {
                RDFNode object = stmtIterator.nextStatement().getObject();
                if (!object.isURIResource()) continue;
                ret.add(URI.create(object.asResource().getURI()));
            }
            return ret;
        }

        public static Optional<URI> getTypeOfSocket(Model content, URI socket) {
            Resource resource = content.getResource(socket.toString());
            Resource socketType = resource.getPropertyResourceValue(WON.socketDefinition);
            if (socketType != null && socketType.isURIResource()) {
                return Optional.of(URI.create(socketType.asResource().getURI()));
            }
            return Optional.empty();
        }

        public static Optional<URI> getTypeOfSocket(Dataset content, URI socket) {
            return Optional.ofNullable(RdfUtils.findFirst(content, m -> SocketUtils.getTypeOfSocket(m, socket).orElse(null)));
        }

        public static Collection<URI> getSocketsOfType(Model model, URI socketType) {
            return SocketUtils.getSocketsOfType(model, RdfUtils.getBaseResource(model), socketType);
        }

        public static Collection<URI> getSocketsOfType(Model model, URI subject, URI socketType) {
            return SocketUtils.getSocketsOfType(model, model.getResource(subject.toString()), socketType);
        }

        public static Collection<URI> getSocketsOfType(Model model, Resource subject, URI socketType) {
            StmtIterator stmtIterator = subject.listProperties(WON.socket);
            Resource socketTypeResource = model.getResource(socketType.toString());
            LinkedList<URI> ret = new LinkedList<URI>();
            while (stmtIterator.hasNext()) {
                RDFNode socket = stmtIterator.nextStatement().getObject();
                if (!socket.isResource() || !socket.isURIResource() || !socket.asResource().hasProperty(WON.socketDefinition, (RDFNode)socketTypeResource)) continue;
                ret.add(URI.create(socket.toString()));
            }
            return ret;
        }

        public static Collection<URI> getSocketsOfType(Dataset atomDataset, URI atomURI, URI socketType) {
            return RdfUtils.visitFlattenedToList(atomDataset, m -> SocketUtils.getSocketsOfType(m, atomURI, socketType));
        }

        public static Optional<URI> getDefaultSocket(Model model, boolean returnAnyIfNoDefaultFound) {
            return SocketUtils.getDefaultSocket(model, RdfUtils.getBaseResource(model), returnAnyIfNoDefaultFound);
        }

        public static Optional<URI> getDefaultSocket(Model model, URI subject, boolean returnAnyIfNoDefaultFound) {
            return SocketUtils.getDefaultSocket(model, model.getResource(subject.toString()), returnAnyIfNoDefaultFound);
        }

        public static Set<URI> getSocketsOfAtom(Dataset atomDataset, URI atomURI) {
            return SocketUtils.getSocketsOfAtomAsStream(atomDataset, atomURI).collect(Collectors.toSet());
        }

        public static Stream<URI> getSocketsOfAtomAsStream(Dataset atomDataset, URI atomURI) {
            return RdfUtils.getObjectStreamOfProperty(atomDataset, atomURI, URI.create(WON.socket.getURI()), node -> node.isURIResource() ? URI.create(node.asResource().getURI()) : null);
        }

        public static Optional<URI> getDefaultSocket(Model model, Resource subject, boolean returnAnyIfNoDefaultFound) {
            Resource socket = subject.getPropertyResourceValue(WON.defaultSocket);
            if (socket != null && socket.isURIResource()) {
                return Optional.of(URI.create(socket.toString()));
            }
            if (returnAnyIfNoDefaultFound) {
                StmtIterator stmtIterator = subject.listProperties(WON.socket);
                while (stmtIterator.hasNext()) {
                    socket = ((Statement)stmtIterator.next()).getObject();
                    if (!socket.isResource() || !socket.isURIResource()) continue;
                    return Optional.of(URI.create(socket.toString()));
                }
            }
            return Optional.empty();
        }

        public static Optional<URI> getDefaultSocket(Dataset atomDataset, URI atomURI, boolean returnAnyIfNoDefaultFound) {
            return Optional.ofNullable(RdfUtils.findFirst(atomDataset, m -> SocketUtils.getDefaultSocket(m, atomURI, returnAnyIfNoDefaultFound).orElse(null)));
        }

        public static void addSocket(Model model, URI socketURI, URI socketTypeURI, boolean isDefaultSocket) {
            Resource baseRes = RdfUtils.getBaseResource(model);
            Resource socket = model.createResource(socketURI.toString());
            baseRes.addProperty(WON.socket, (RDFNode)socket);
            socket.addProperty(WON.socketDefinition, (RDFNode)model.createResource(socketTypeURI.toString()));
            if (isDefaultSocket) {
                if (baseRes.hasProperty(WON.defaultSocket)) {
                    baseRes.removeAll(WON.defaultSocket);
                }
                baseRes.addProperty(WON.defaultSocket, (RDFNode)socket);
            }
        }

        public static void addSocket(Dataset dataset, URI socketURI, URI socketTypeURI, boolean isDefaultSocket) {
            RdfUtils.visit(dataset, model -> {
                SocketUtils.addSocket(model, socketURI, socketTypeURI, isDefaultSocket);
                return null;
            });
        }

        public static void addTargetSocket(Model content, URI socketURI) {
            Resource baseRes = RdfUtils.getBaseResource(content);
            baseRes.addProperty(WON.targetSocket, (RDFNode)content.createResource(socketURI.toString()));
        }

        public static Optional<Model> createSocketModelForHintOrConnect(Optional<URI> socket, Optional<URI> targetSocket) {
            if (!socket.isPresent() && !targetSocket.isPresent()) {
                return Optional.empty();
            }
            Model model = ModelFactory.createDefaultModel();
            Resource baseResource = RdfUtils.findOrCreateBaseResource(model);
            if (socket.isPresent()) {
                baseResource.addProperty(WON.socket, (RDFNode)model.getResource(socket.toString()));
            }
            if (targetSocket.isPresent()) {
                baseResource.addProperty(WON.targetSocket, (RDFNode)model.getResource(targetSocket.toString()));
            }
            return Optional.of(model);
        }

        public static void setCompatibleSocketDefinitions(SocketDefinitionImpl socketConfiguration, Dataset dataset, URI socketURI) {
            socketConfiguration.setCompatibleSocketTypes(SocketUtils.getCompatibleSocketDefinitions(dataset, socketURI));
        }

        public static Set<URI> getCompatibleSocketDefinitions(Dataset dataset, URI socketURI) {
            return RdfUtils.getObjectStreamOfProperty(dataset, socketURI, URI.create(WON.socketDefinition.getURI()), node -> node.isURIResource() ? URI.create(node.asResource().getURI()) : null).flatMap(def -> RdfUtils.getObjectStreamOfProperty(dataset, def, URI.create(WON.compatibleSocketDefinition.getURI()), node -> node.isURIResource() ? URI.create(node.asResource().getURI()) : null)).collect(Collectors.toSet());
        }

        public static void setDerivationProperties(SocketDefinitionImpl socketConfiguration, Dataset dataset, URI socketURI) {
            socketConfiguration.setDerivationProperties(RdfUtils.getObjectStreamOfProperty(dataset, socketURI, URI.create(WON.socketDefinition.getURI()), node -> node.isURIResource() ? URI.create(node.asResource().getURI()) : null).flatMap(def -> RdfUtils.getObjectStreamOfProperty(dataset, def, URI.create(WON.derivesAtomProperty.getURI()), node -> node.isURIResource() ? URI.create(node.asResource().getURI()) : null)).collect(Collectors.toSet()));
        }

        public static void setInverseDerivationProperties(SocketDefinitionImpl socketConfiguration, Dataset dataset, URI socketURI) {
            socketConfiguration.setInverseDerivationProperties(RdfUtils.getObjectStreamOfProperty(dataset, socketURI, URI.create(WON.socketDefinition.getURI()), node -> node.isURIResource() ? URI.create(node.asResource().getURI()) : null).flatMap(def -> RdfUtils.getObjectStreamOfProperty(dataset, def, URI.create(WON.derivesInverseAtomProperty.getURI()), node -> node.isURIResource() ? URI.create(node.asResource().getURI()) : null)).collect(Collectors.toSet()));
        }

        public static void setAutoOpen(SocketDefinitionImpl socketConfiguration, Dataset dataset, URI socketURI) {
            Set autoOpens = RdfUtils.getObjectStreamOfProperty(dataset, socketURI, URI.create(WON.socketDefinition.getURI()), node -> node.isURIResource() ? URI.create(node.asResource().getURI()) : null).flatMap(def -> RdfUtils.getObjectStreamOfProperty(dataset, def, URI.create(WON.autoOpen.getURI()), node -> node.isLiteral() ? Boolean.valueOf(node.asLiteral().getBoolean()) : null)).collect(Collectors.toSet());
            if (autoOpens.size() > 1) {
                socketConfiguration.addInconsistentProperty(URI.create(WON.autoOpen.getURI()));
            } else if (autoOpens.size() == 1) {
                socketConfiguration.setAutoOpen((Boolean)autoOpens.iterator().next());
            }
        }

        public static void setSocketCapacity(SocketDefinitionImpl socketConfiguration, Dataset dataset, URI socketURI) {
            Set socketCapacities = RdfUtils.getObjectStreamOfProperty(dataset, socketURI, URI.create(WON.socketDefinition.getURI()), node -> node.isURIResource() ? URI.create(node.asResource().getURI()) : null).flatMap(def -> RdfUtils.getObjectStreamOfProperty(dataset, def, URI.create(WON.socketCapacity.getURI()), node -> node.isLiteral() ? Integer.valueOf(node.asLiteral().getInt()) : null)).collect(Collectors.toSet());
            if (socketCapacities.size() > 1) {
                socketConfiguration.addInconsistentProperty(URI.create(WON.socketCapacity.getURI()));
            } else if (socketCapacities.size() == 1) {
                socketConfiguration.setCapacity((Integer)socketCapacities.iterator().next());
            }
        }

        public static Optional<URI> getAtomOfSocket(Dataset dataset, URI socketURI) {
            return RdfUtils.getFirstStatementMapped(dataset, null, URI.create(WON.socket.getURI()), socketURI, s -> s.getSubject().isURIResource() ? URI.create(s.getSubject().getURI()) : null);
        }
    }

    public static class MessageUtils {
        public static Model addMessage(Model model, String message) {
            Resource baseRes = RdfUtils.findOrCreateBaseResource(model);
            baseRes.addProperty(WONCON.text, message, (RDFDatatype)XSDDatatype.XSDstring);
            return model;
        }

        public static Model textMessage(String message) {
            Model messageModel = WonRdfUtils.createModelWithBaseResource();
            Resource baseRes = messageModel.createResource(messageModel.getNsPrefixURI(""));
            baseRes.addProperty(WONCON.text, message, (RDFDatatype)XSDDatatype.XSDstring);
            return messageModel;
        }

        public static Model processingMessage(String message) {
            Model messageModel = MessageUtils.textMessage(message);
            return MessageUtils.addProcessing(messageModel, message);
        }

        public static Model genericMessage(URI predicate, URI object) {
            return MessageUtils.genericMessage((Property)new PropertyImpl(predicate.toString()), (Resource)new ResourceImpl(object.toString()));
        }

        public static Model genericMessage(Property predicate, Resource object) {
            Model messageModel = WonRdfUtils.createModelWithBaseResource();
            Resource baseRes = RdfUtils.getBaseResource(messageModel);
            baseRes.addProperty(RDF.type, (RDFNode)WONMSG.ConnectionMessage);
            baseRes.addProperty(predicate, (RDFNode)object);
            return messageModel;
        }

        public static Model addToMessage(Model messageModel, Property predicate, Resource object) {
            Resource baseRes = RdfUtils.findOrCreateBaseResource(messageModel);
            baseRes.addProperty(predicate, (RDFNode)object);
            return messageModel;
        }

        public static Model retractsMessage(URI ... toRetract) {
            return MessageUtils.addRetracts(WonRdfUtils.createModelWithBaseResource(), toRetract);
        }

        public static Model proposesMessage(URI ... toPropose) {
            return MessageUtils.addProposes(WonRdfUtils.createModelWithBaseResource(), toPropose);
        }

        public static Model rejectMessage(URI ... toReject) {
            return MessageUtils.addRejects(WonRdfUtils.createModelWithBaseResource(), toReject);
        }

        public static Model acceptsMessage(URI ... toAccept) {
            return MessageUtils.addAccepts(WonRdfUtils.createModelWithBaseResource(), toAccept);
        }

        public static Model proposesToCancelMessage(URI ... toProposesToCancel) {
            return MessageUtils.addProposesToCancel(WonRdfUtils.createModelWithBaseResource(), toProposesToCancel);
        }

        public static Model addRetracts(Model messageModel, URI ... toRetract) {
            Resource baseRes = RdfUtils.findOrCreateBaseResource(messageModel);
            if (toRetract == null) {
                return messageModel;
            }
            for (URI uri : toRetract) {
                if (uri == null) continue;
                baseRes.addProperty(WONMOD.retracts, (RDFNode)baseRes.getModel().getResource(uri.toString()));
            }
            return messageModel;
        }

        public static Model addProposes(Model messageModel, URI ... toPropose) {
            Resource baseRes = RdfUtils.findOrCreateBaseResource(messageModel);
            if (toPropose == null) {
                return messageModel;
            }
            for (URI uri : toPropose) {
                if (uri == null) continue;
                baseRes.addProperty(WONAGR.proposes, (RDFNode)baseRes.getModel().getResource(uri.toString()));
            }
            return messageModel;
        }

        public static Model addRejects(Model messageModel, URI ... toReject) {
            Resource baseRes = RdfUtils.findOrCreateBaseResource(messageModel);
            if (toReject == null) {
                return messageModel;
            }
            for (URI uri : toReject) {
                if (uri == null) continue;
                baseRes.addProperty(WONAGR.rejects, (RDFNode)baseRes.getModel().getResource(uri.toString()));
            }
            return messageModel;
        }

        public static Model addAccepts(Model messageModel, URI ... toAccept) {
            Resource baseRes = RdfUtils.findOrCreateBaseResource(messageModel);
            if (toAccept == null) {
                return messageModel;
            }
            for (URI uri : toAccept) {
                if (uri == null) continue;
                logger.debug("checking uri for addProposesToCancel with uri {}", (Object)uri);
                baseRes.addProperty(WONAGR.accepts, (RDFNode)baseRes.getModel().getResource(uri.toString()));
            }
            return messageModel;
        }

        public static Model addProposesToCancel(Model messageModel, URI ... toProposesToCancel) {
            Resource baseRes = RdfUtils.findOrCreateBaseResource(messageModel);
            if (toProposesToCancel == null) {
                return messageModel;
            }
            for (URI uri : toProposesToCancel) {
                if (uri == null) continue;
                logger.debug("checking uri for addProposesToCancel with uri {}", (Object)uri);
                baseRes.addProperty(WONAGR.proposesToCancel, (RDFNode)baseRes.getModel().getResource(uri.toString()));
            }
            return messageModel;
        }

        public static Model binaryFeedbackMessage(URI forResource, boolean isFeedbackPositive) {
            Model messageModel = WonRdfUtils.createModelWithBaseResource();
            Resource baseRes = RdfUtils.getBaseResource(messageModel);
            Resource feedbackNode = messageModel.createResource();
            baseRes.addProperty(WONCON.feedback, (RDFNode)feedbackNode);
            feedbackNode.addProperty(WONCON.binaryRating, (RDFNode)(isFeedbackPositive ? WONCON.Good : WONCON.Bad));
            feedbackNode.addProperty(WONCON.feedbackTarget, (RDFNode)messageModel.createResource(forResource.toString()));
            return messageModel;
        }

        @Deprecated
        public static String getTextMessage(Model model) {
            Statement stmt = model.getProperty(RdfUtils.getBaseResource(model), WONCON.text);
            if (stmt != null) {
                return stmt.getObject().asLiteral().getLexicalForm();
            }
            return null;
        }

        public static Set<String> getTextMessages(Model model, URI messageUri) {
            HashSet<String> ret = new HashSet<String>();
            StmtIterator stmtIt = model.listStatements(model.getResource(messageUri.toString()), WONCON.text, (RDFNode)null);
            while (stmtIt.hasNext()) {
                RDFNode node = ((Statement)stmtIt.next()).getObject();
                if (!node.isLiteral()) continue;
                ret.add(node.asLiteral().getLexicalForm());
            }
            return ret;
        }

        public static String getTextMessage(WonMessage wonMessage) {
            URI messageURI = wonMessage.getMessageURI();
            String queryString = "prefix msg: <https://w3id.org/won/message#>\nprefix won: <https://w3id.org/won/core#>\nprefix con: <https://w3id.org/won/content#>\nprefix match: <https://w3id.org/won/matching#>\n\nSELECT distinct ?txt WHERE {\n  {\n    graph ?gA { ?msg con:text ?txt }\n  } union {\n    graph ?gB { ?msg msg:correspondingRemoteMessage ?msg2 }\n    graph ?gA { ?msg2 con:text ?txt }\n  } union {\n    graph ?gC { ?msg msg:forwardedMessage ?msg2 }\n    graph ?gB { ?msg2 msg:correspondingRemoteMessage ?msg3 }\n    graph ?gA { ?msg3 con:text ?txt }\n  } union {\n    graph ?gD { ?msg msg:correspondingRemoteMessage ?msg2 }\n    graph ?gC { ?msg2 msg:forwardedMessage ?msg3 }\n    graph ?gB { ?msg3 msg:correspondingRemoteMessage ?msg4 }\n    graph ?gA { ?msg4 con:text ?txt }\n  } union {\n    graph ?gE { ?msg msg:forwardedMessage ?msg2 }\n    graph ?gD { ?msg2 msg:correspondingRemoteMessage ?msg3 }\n    graph ?gC { ?msg3 msg:forwardedMessage ?msg4 }\n    graph ?gB { ?msg4 msg:correspondingRemoteMessage ?msg5 }\n    graph ?gA { ?msg5 con:text ?txt }\n  } union {\n    graph ?gF { ?msg msg:correspondingRemoteMessage ?msg2 }\n    graph ?gE { ?msg2 msg:forwardedMessage ?msg3 }\n    graph ?gD { ?msg3 msg:correspondingRemoteMessage ?msg4 }\n    graph ?gC { ?msg4 msg:forwardedMessage ?msg5 }\n    graph ?gB { ?msg5 msg:correspondingRemoteMessage ?msg6 }\n    graph ?gA { ?msg6 con:text ?txt }\n  } union {\n    graph ?gG { ?msg msg:forwardedMessage ?msg2 }\n    graph ?gF { ?msg2 msg:correspondingRemoteMessage ?msg3 }\n    graph ?gE { ?msg3 msg:forwardedMessage ?msg4 }\n    graph ?gD { ?msg4 msg:correspondingRemoteMessage ?msg5 }\n    graph ?gC { ?msg5 msg:forwardedMessage ?msg6 }\n    graph ?gB { ?msg6 msg:correspondingRemoteMessage ?msg7 }\n    graph ?gA { ?msg7 con:text ?txt }\n  }\n\n}";
            Query query = QueryFactory.create((String)queryString);
            QuerySolutionMap initialBinding = new QuerySolutionMap();
            Model tmpModel = ModelFactory.createDefaultModel();
            initialBinding.add("msg", (RDFNode)tmpModel.getResource(messageURI.toString()));
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)wonMessage.getCompleteDataset());){
                qexec.getContext().set(TDB.symUnionDefaultGraph, true);
                ResultSet rs = qexec.execSelect();
                if (rs.hasNext()) {
                    QuerySolution qs = rs.nextSolution();
                    String textMessage = MessageUtils.rdfNodeToString(qs.get("txt"));
                    if (rs.hasNext()) {
                        throw new IllegalArgumentException("wonMessage has more than one text messages");
                    }
                    String string = textMessage;
                    return string;
                }
            }
            return null;
        }

        public static List<URI> getAcceptedEvents(WonMessage wonMessage) {
            return MessageUtils.getAcceptedEvents(wonMessage.getCompleteDataset());
        }

        public static List<URI> getAcceptedEvents(Dataset messageDataset) {
            ArrayList<URI> acceptedEvents = new ArrayList<URI>();
            String queryString = "prefix msg:   <https://w3id.org/won/message#>\nprefix agr:   <https://w3id.org/won/agreement#>\nSELECT ?eventUri where {\n graph ?g {  ?s agr:accepts ?eventUri .\n}}";
            Query query = QueryFactory.create((String)queryString);
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)messageDataset);){
                QuerySolution qs;
                String eventUri;
                qexec.getContext().set(TDB.symUnionDefaultGraph, true);
                ResultSet rs = qexec.execSelect();
                if (rs.hasNext() && (eventUri = MessageUtils.rdfNodeToString((qs = rs.nextSolution()).get("eventUri"))) != null) {
                    acceptedEvents.add(URI.create(eventUri));
                }
            }
            return acceptedEvents;
        }

        public static boolean isProcessingMessage(WonMessage wonMessage) {
            String queryString = "prefix msg:   <https://w3id.org/won/message#>\nprefix won:   <https://w3id.org/won/core#>\nSELECT ?text where {\n graph ?g {  ?s won:isProcessing ?text .\n}}";
            Query query = QueryFactory.create((String)queryString);
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)wonMessage.getCompleteDataset());){
                QuerySolution qs;
                String text;
                qexec.getContext().set(TDB.symUnionDefaultGraph, true);
                ResultSet rs = qexec.execSelect();
                if (rs.hasNext() && (text = MessageUtils.rdfNodeToString((qs = rs.nextSolution()).get("text"))) != null) {
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }

        public static Model addProcessing(Model model, String message) {
            Resource baseRes = RdfUtils.findOrCreateBaseResource(model);
            baseRes.addProperty(WONCON.isProcessing, message, (RDFDatatype)XSDDatatype.XSDstring);
            return model;
        }

        public static List<URI> getProposesEvents(WonMessage wonMessage) {
            return MessageUtils.getProposesEvents(wonMessage.getCompleteDataset());
        }

        public static List<URI> getProposesEvents(Dataset messageDataset) {
            ArrayList<URI> proposesToCancelEvents = new ArrayList<URI>();
            String queryString = "prefix msg:   <https://w3id.org/won/message#>\nprefix agr:   <https://w3id.org/won/agreement#>\nSELECT ?eventUri where {\n graph ?g {  ?s agr:proposes ?eventUri .\n}}";
            Query query = QueryFactory.create((String)queryString);
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)messageDataset);){
                QuerySolution qs;
                String eventUri;
                qexec.getContext().set(TDB.symUnionDefaultGraph, true);
                ResultSet rs = qexec.execSelect();
                if (rs.hasNext() && (eventUri = MessageUtils.rdfNodeToString((qs = rs.nextSolution()).get("eventUri"))) != null) {
                    proposesToCancelEvents.add(URI.create(eventUri));
                }
            }
            return proposesToCancelEvents;
        }

        public static List<URI> getProposesToCancelEvents(WonMessage wonMessage) {
            return MessageUtils.getProposesToCancelEvents(wonMessage.getCompleteDataset());
        }

        public static List<URI> getProposesToCancelEvents(Dataset messageDataset) {
            ArrayList<URI> proposesToCancelEvents = new ArrayList<URI>();
            String queryString = "prefix msg:   <https://w3id.org/won/message#>\nprefix agr:   <https://w3id.org/won/agreement#>\nSELECT ?eventUri where {\n graph ?g {  ?s agr:proposesToCancel ?eventUri .\n}}";
            Query query = QueryFactory.create((String)queryString);
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)messageDataset);){
                QuerySolution qs;
                String eventUri;
                qexec.getContext().set(TDB.symUnionDefaultGraph, true);
                ResultSet rs = qexec.execSelect();
                if (rs.hasNext() && (eventUri = MessageUtils.rdfNodeToString((qs = rs.nextSolution()).get("eventUri"))) != null) {
                    proposesToCancelEvents.add(URI.create(eventUri));
                }
            }
            return proposesToCancelEvents;
        }

        public static List<URI> getPreviousMessageUrisIncludingRemote(WonMessage wonMessage) {
            ArrayList<URI> uris = new ArrayList<URI>();
            String queryString = "prefix msg:   <https://w3id.org/won/message#>\nprefix agr:   <https://w3id.org/won/agreement#>\nSELECT distinct ?prev where {\n   {    ?msg msg:previousMessage ?prev .\n   } union {    ?msg msg:correspondingRemoteMessage/msg:previousMessage ?prev   }}";
            Query query = QueryFactory.create((String)queryString);
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)wonMessage.getCompleteDataset());){
                QuerySolution qs;
                String eventUri;
                qexec.getContext().set(TDB.symUnionDefaultGraph, true);
                QuerySolutionMap binding = new QuerySolutionMap();
                binding.add("msg", (RDFNode)new ResourceImpl(wonMessage.getMessageURI().toString()));
                qexec.setInitialBinding((QuerySolution)binding);
                ResultSet rs = qexec.execSelect();
                if (rs.hasNext() && (eventUri = MessageUtils.rdfNodeToString((qs = rs.nextSolution()).get("prev"))) != null) {
                    uris.add(URI.create(eventUri));
                }
            }
            return uris;
        }

        public static Map<Property, String> getReviewContent(WonMessage wonMessage) throws IllegalArgumentException {
            System.out.println("message content: ");
            RDFDataMgr.write((OutputStream)System.out, (Dataset)wonMessage.getMessageContent(), (Lang)Lang.TRIG);
            System.out.println("whole message: ");
            RDFDataMgr.write((OutputStream)System.out, (Dataset)wonMessage.getCompleteDataset(), (Lang)Lang.TRIG);
            String queryString = "prefix s: <http://schema.org/>\nselect * where \n  {graph ?g {\n    ?event s:review ?review .\n    ?review s:reviewRating ?rating;\n        s:about ?about;\n        s:author ?author .\n    ?rating a s:Rating;\n        s:ratingValue ?ratingValue .\n\n}}";
            Query query = QueryFactory.create((String)queryString);
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)wonMessage.getCompleteDataset());){
                qexec.getContext().set(TDB.symUnionDefaultGraph, true);
                ResultSet rs = qexec.execSelect();
                if (rs.hasNext()) {
                    QuerySolution qs = rs.nextSolution();
                    HashMap<Property, String> reviewData = new HashMap<Property, String>();
                    reviewData.put(SCHEMA.REVIEW, MessageUtils.rdfNodeToString(qs.get("review")));
                    reviewData.put(SCHEMA.RATING, MessageUtils.rdfNodeToString(qs.get("rating")));
                    reviewData.put(SCHEMA.ABOUT, MessageUtils.rdfNodeToString(qs.get("about")));
                    reviewData.put(SCHEMA.AUTHOR, MessageUtils.rdfNodeToString(qs.get("author")));
                    reviewData.put(SCHEMA.RATING_VALUE, MessageUtils.rdfNodeToString(qs.get("ratingValue")));
                    if (rs.hasNext()) {
                        throw new IllegalArgumentException("wonMessage has more than one review");
                    }
                    HashMap<Property, String> hashMap = reviewData;
                    return hashMap;
                }
            }
            return null;
        }

        private static String rdfNodeToString(RDFNode node) {
            if (node.isLiteral()) {
                return node.asLiteral().getString();
            }
            if (node.isResource()) {
                return node.asResource().getURI();
            }
            return null;
        }

        private static RDFNode getTextMessageForResource(Dataset dataset, URI uri) {
            if (uri == null) {
                return null;
            }
            return RdfUtils.findFirstPropertyFromResource(dataset, uri, WONCON.text);
        }

        private static RDFNode getTextMessageForResource(Dataset dataset, Resource resource) {
            if (resource == null) {
                return null;
            }
            return RdfUtils.findFirstPropertyFromResource(dataset, resource, WONCON.text);
        }

        public static WonMessage copyByDatasetSerialization(WonMessage toWrap) {
            return new WonMessage(RdfUtils.readDatasetFromString(RdfUtils.writeDatasetToString(toWrap.getCompleteDataset(), Lang.TRIG), Lang.TRIG));
        }
    }

    public static class WonNodeUtils {
        public static WonNodeInfo getWonNodeInfo(final URI wonNodeUri, Dataset dataset) {
            assert (wonNodeUri != null) : "wonNodeUri must not be null";
            assert (dataset != null) : "dataset must not be null";
            return RdfUtils.findFirst(dataset, new RdfUtils.ModelVisitor<WonNodeInfo>(){

                @Override
                public WonNodeInfo visit(Model model) {
                    NodeIterator it = model.listObjectsOfProperty(model.getResource(wonNodeUri.toString()), WON.uriPrefixSpecification);
                    if (!it.hasNext()) {
                        return null;
                    }
                    WonNodeInfoBuilder wonNodeInfoBuilder = new WonNodeInfoBuilder();
                    wonNodeInfoBuilder.setWonNodeURI(wonNodeUri.toString());
                    RDFNode node = it.next();
                    it = model.listObjectsOfProperty(node.asResource(), WON.atomUriPrefix);
                    if (!it.hasNext()) {
                        return null;
                    }
                    String atomUriPrefix = it.next().asLiteral().getString();
                    wonNodeInfoBuilder.setAtomURIPrefix(atomUriPrefix);
                    it = model.listObjectsOfProperty(node.asResource(), WON.connectionUriPrefix);
                    if (!it.hasNext()) {
                        return null;
                    }
                    wonNodeInfoBuilder.setConnectionURIPrefix(it.next().asLiteral().getString());
                    it = model.listObjectsOfProperty(node.asResource(), WON.eventUriPrefix);
                    if (!it.hasNext()) {
                        return null;
                    }
                    wonNodeInfoBuilder.setEventURIPrefix(it.next().asLiteral().getString());
                    it = model.listObjectsOfProperty(model.getResource(wonNodeUri.toString()), WON.atomList);
                    if (it.hasNext()) {
                        wonNodeInfoBuilder.setAtomListURI(it.next().asNode().getURI());
                    } else {
                        wonNodeInfoBuilder.setAtomListURI(atomUriPrefix);
                    }
                    String queryString = "SELECT ?protocol ?param ?value WHERE { ?a <%s> ?c. ?c <%s> ?protocol. ?c ?param ?value. FILTER ( ?value != ?protocol ) }";
                    queryString = String.format(queryString, WON.supportsWonProtocolImpl.toString(), RDF.getURI() + "type");
                    Query protocolQuery = QueryFactory.create((String)queryString);
                    try (QueryExecution qexec = QueryExecutionFactory.create((Query)protocolQuery, (Model)model);){
                        ResultSet rs = qexec.execSelect();
                        while (rs.hasNext()) {
                            QuerySolution qs = rs.nextSolution();
                            String protocol = WonNodeUtils.rdfNodeToString(qs.get("protocol"));
                            String param = WonNodeUtils.rdfNodeToString(qs.get("param"));
                            String value = WonNodeUtils.rdfNodeToString(qs.get("value"));
                            wonNodeInfoBuilder.addSupportedProtocolImplParamValue(protocol, param, value);
                        }
                        WonNodeInfo wonNodeInfo = wonNodeInfoBuilder.build();
                        return wonNodeInfo;
                    }
                }
            });
        }

        private static String rdfNodeToString(RDFNode node) {
            if (node.isLiteral()) {
                return node.asLiteral().getString();
            }
            if (node.isResource()) {
                return node.asResource().getURI();
            }
            return null;
        }
    }

    public static class SignatureUtils {
        public static boolean isSignatureGraph(String graphUri, Model model) {
            Resource resource = model.getResource(graphUri);
            StmtIterator si = model.listStatements(resource, RDF.type, (RDFNode)SFSIG.SIGNATURE);
            return si.hasNext();
        }

        public static boolean isSignature(Model model, String modelName) {
            return model.contains(model.getResource(modelName), RDF.type, (RDFNode)SFSIG.SIGNATURE);
        }

        public static String getSignedGraphUri(String signatureGraphUri, Model signatureGraph) {
            String signedGraphUri = null;
            Resource resource = signatureGraph.getResource(signatureGraphUri);
            NodeIterator ni = signatureGraph.listObjectsOfProperty(resource, WONMSG.signedGraph);
            if (ni.hasNext()) {
                signedGraphUri = ni.next().asResource().getURI();
            }
            return signedGraphUri;
        }

        public static String getSignatureValue(String signatureGraphUri, Model signatureGraph) {
            String signatureValue = null;
            Resource resource = signatureGraph.getResource(signatureGraphUri);
            NodeIterator ni2 = signatureGraph.listObjectsOfProperty(resource, SFSIG.HAS_SIGNATURE_VALUE);
            if (ni2.hasNext()) {
                signatureValue = ni2.next().asLiteral().toString();
            }
            return signatureValue;
        }

        public static WonSignatureData extractWonSignatureData(String uri, Model model) {
            return SignatureUtils.extractWonSignatureData(model.getResource(uri));
        }

        public static WonSignatureData extractWonSignatureData(Resource resource) {
            Statement stmt = resource.getRequiredProperty(WONMSG.signedGraph);
            String signedGraphUri = stmt.getObject().asResource().getURI();
            stmt = resource.getRequiredProperty(SFSIG.HAS_SIGNATURE_VALUE);
            String signatureValue = stmt.getObject().asLiteral().getString();
            stmt = resource.getRequiredProperty(WONMSG.hash);
            String hash = stmt.getObject().asLiteral().getString();
            stmt = resource.getRequiredProperty(WONMSG.publicKeyFingerprint);
            String fingerprint = stmt.getObject().asLiteral().getString();
            stmt = resource.getRequiredProperty(SFSIG.HAS_VERIFICATION_CERT);
            String cert = stmt.getObject().asResource().getURI();
            return new WonSignatureData(signedGraphUri, resource.getURI(), signatureValue, hash, fingerprint, cert);
        }

        public static void addSignature(Resource subject, WonSignatureData wonSignatureData) {
            assert (wonSignatureData.getHash() != null);
            assert (wonSignatureData.getSignatureValue() != null);
            assert (wonSignatureData.getPublicKeyFingerprint() != null);
            assert (wonSignatureData.getSignedGraphUri() != null);
            assert (wonSignatureData.getVerificationCertificateUri() != null);
            Model containingGraph = subject.getModel();
            subject.addProperty(RDF.type, (RDFNode)SFSIG.SIGNATURE);
            subject.addProperty(WONMSG.hash, wonSignatureData.getHash());
            subject.addProperty(SFSIG.HAS_SIGNATURE_VALUE, wonSignatureData.getSignatureValue());
            subject.addProperty(WONMSG.signedGraph, (RDFNode)containingGraph.createResource(wonSignatureData.getSignedGraphUri()));
            subject.addProperty(WONMSG.publicKeyFingerprint, wonSignatureData.getPublicKeyFingerprint());
            subject.addProperty(SFSIG.HAS_VERIFICATION_CERT, (RDFNode)containingGraph.createResource(wonSignatureData.getVerificationCertificateUri()));
        }
    }
}

