/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util;

import com.google.common.collect.Iterators;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.eval.PathEval;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.tdb.TDB;
import org.apache.jena.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.exception.IncorrectPropertyCountException;
import won.protocol.util.CheapInsecureRandomString;
import won.protocol.util.ProjectingIterator;

public class RdfUtils {
    public static final RDFNode EMPTY_RDF_NODE = null;
    private static final CheapInsecureRandomString randomString = new CheapInsecureRandomString();
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static ModelSelector DEFAULT_MODEL_SELECTOR = new DefaultModelSelector();

    public static String toString(Model model) {
        String ret = "";
        if (model != null) {
            StringWriter sw = new StringWriter();
            model.write((Writer)sw, "TTL");
            ret = sw.toString();
        }
        return ret;
    }

    public static Model toModel(String content) {
        return RdfUtils.readRdfSnippet(content, "TURTLE");
    }

    public static String toString(Dataset dataset) {
        String result = "";
        if (dataset != null) {
            StringWriter sw = new StringWriter();
            RDFDataMgr.write((StringWriter)sw, (Dataset)dataset, (Lang)RDFFormat.TRIG.getLang());
            result = sw.toString();
        }
        return result;
    }

    public static Dataset toDataset(String content) {
        return RdfUtils.toDataset(content, RDFFormat.TRIG);
    }

    public static Dataset toDataset(String content, RDFFormat rdfFormat) {
        if (content != null) {
            return RdfUtils.toDataset(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), rdfFormat);
        }
        return DatasetFactory.createGeneral();
    }

    public static Dataset toDataset(InputStream stream, RDFFormat rdfFormat) {
        Dataset dataset = DatasetFactory.createGeneral();
        RDFDataMgr.read((Dataset)dataset, (InputStream)stream, (Lang)rdfFormat.getLang());
        try {
            stream.close();
        }
        catch (IOException ex) {
            logger.warn("An exception occurred.", (Throwable)ex);
        }
        return dataset;
    }

    public static Model cloneModel(Model original) {
        Model clonedModel = ModelFactory.createDefaultModel();
        original.enterCriticalSection(true);
        try {
            StmtIterator it = original.listStatements();
            while (it.hasNext()) {
                clonedModel.add(it.nextStatement());
            }
            clonedModel.setNsPrefixes(original.getNsPrefixMap());
        }
        finally {
            original.leaveCriticalSection();
        }
        return clonedModel;
    }

    public static Dataset cloneDataset(Dataset dataset) {
        if (dataset == null) {
            return null;
        }
        boolean existingTransaction = dataset.isInTransaction();
        if (!existingTransaction) {
            dataset.begin(ReadWrite.READ);
        }
        Dataset clonedDataset = DatasetFactory.createGeneral();
        clonedDataset.begin(ReadWrite.WRITE);
        Model model = dataset.getDefaultModel();
        if (model != null) {
            clonedDataset.setDefaultModel(RdfUtils.cloneModel(model));
        }
        Iterator modelNames = dataset.listNames();
        while (modelNames.hasNext()) {
            String modelName = (String)modelNames.next();
            clonedDataset.addNamedModel(modelName, RdfUtils.cloneModel(dataset.getNamedModel(modelName)));
        }
        clonedDataset.commit();
        if (!existingTransaction) {
            dataset.end();
        }
        return clonedDataset;
    }

    public static boolean isIsomorphicWith(Dataset dataset, Dataset otherDataset) {
        String name;
        Model otherDefaultModel;
        if (dataset == null) {
            throw new IllegalArgumentException("dataset must not be null");
        }
        if (otherDataset == null) {
            throw new IllegalArgumentException("otherDataset must not be null");
        }
        Model defaultModel = dataset.getDefaultModel();
        if (!RdfUtils.areModelsIsomorphic(defaultModel, otherDefaultModel = otherDataset.getDefaultModel())) {
            return false;
        }
        Iterator namesIt = dataset.listNames();
        while (namesIt.hasNext()) {
            name = (String)namesIt.next();
            Model model = dataset.getNamedModel(name);
            if (!otherDataset.containsNamedModel(name) && dataset.getNamedModel(name).isEmpty()) {
                return true;
            }
            Model otherModel = otherDataset.getNamedModel(name);
            if (RdfUtils.areModelsIsomorphic(model, otherModel)) continue;
            return false;
        }
        namesIt = otherDataset.listNames();
        while (namesIt.hasNext()) {
            name = (String)namesIt.next();
            if (dataset.containsNamedModel(name)) continue;
            return otherDataset.getNamedModel(name).isEmpty();
        }
        return true;
    }

    public static boolean areModelsIsomorphic(Model model, Model otherModel) {
        if (model != null) {
            if (otherModel == null) {
                return false;
            }
            return model.isIsomorphicWith(otherModel);
        }
        if (otherModel != null) {
            return false;
        }
        throw new IllegalArgumentException("both models are null");
    }

    public static Pair<Model> diff(Model firstModel, Model secondModel) {
        Statement toRemove;
        StmtIterator it2;
        RDFNode o;
        Property p;
        Resource s;
        Statement stmt;
        if (firstModel == null && secondModel == null) {
            return null;
        }
        Model cloneFirst = null;
        Model cloneSecond = null;
        if (firstModel != null) {
            cloneFirst = RdfUtils.cloneModel(firstModel);
        }
        if (secondModel != null) {
            cloneSecond = RdfUtils.cloneModel(secondModel);
        }
        if (firstModel == null || secondModel == null) {
            return new Pair<Model>(cloneFirst, cloneSecond);
        }
        StmtIterator it = firstModel.listStatements();
        while (it.hasNext()) {
            stmt = it.nextStatement();
            if (stmt.getSubject().isAnon() || stmt.getObject().isAnon()) {
                s = stmt.getSubject();
                p = stmt.getPredicate();
                o = stmt.getObject();
                if (s.isAnon()) {
                    s = null;
                }
                if (o.isAnon()) {
                    o = null;
                }
                it2 = cloneSecond.listStatements(s, p, o);
                while (it2.hasNext()) {
                    toRemove = it2.nextStatement();
                    if (stmt.getSubject().isAnon() && !toRemove.getSubject().isAnon() || stmt.getObject().isAnon() && !toRemove.getObject().isAnon()) continue;
                    it2.remove();
                }
                continue;
            }
            cloneSecond.remove(stmt);
        }
        it = secondModel.listStatements();
        while (it.hasNext()) {
            stmt = it.nextStatement();
            if (stmt.getSubject().isAnon() || stmt.getObject().isAnon()) {
                s = stmt.getSubject();
                p = stmt.getPredicate();
                o = stmt.getObject();
                if (s.isAnon()) {
                    s = null;
                }
                if (o.isAnon()) {
                    o = null;
                }
                it2 = cloneFirst.listStatements(s, p, o);
                while (it2.hasNext()) {
                    toRemove = it2.nextStatement();
                    if (stmt.getSubject().isAnon() && !toRemove.getSubject().isAnon() || stmt.getObject().isAnon() && !toRemove.getObject().isAnon()) continue;
                    it2.remove();
                }
                continue;
            }
            cloneFirst.remove(stmt);
        }
        return new Pair<Model>(cloneFirst, cloneSecond);
    }

    public static Pair<Dataset> diff(Dataset firstDataset, Dataset secondDataset) {
        String name;
        Dataset firstResultDataset = DatasetFactory.createGeneral();
        Dataset secondResultDataset = DatasetFactory.createGeneral();
        Pair<Model> modelDiff = RdfUtils.diff(firstDataset.getDefaultModel(), secondDataset.getDefaultModel());
        firstResultDataset.setDefaultModel(modelDiff.getFirst());
        secondResultDataset.setDefaultModel(modelDiff.getSecond());
        Iterator namesIt = firstDataset.listNames();
        while (namesIt.hasNext()) {
            name = (String)namesIt.next();
            if (secondDataset.containsNamedModel(name)) {
                modelDiff = RdfUtils.diff(firstDataset.getNamedModel(name), secondDataset.getNamedModel(name));
                if (modelDiff.getFirst() != null && !modelDiff.getFirst().isEmpty()) {
                    firstResultDataset.addNamedModel(name, modelDiff.getFirst());
                }
                if (modelDiff.getSecond() == null || modelDiff.getSecond().isEmpty()) continue;
                secondResultDataset.addNamedModel(name, modelDiff.getSecond());
                continue;
            }
            firstResultDataset.addNamedModel(name, RdfUtils.cloneModel(firstDataset.getNamedModel(name)));
        }
        namesIt = secondDataset.listNames();
        while (namesIt.hasNext()) {
            name = (String)namesIt.next();
            if (firstDataset.containsNamedModel(name)) continue;
            secondResultDataset.addNamedModel(name, RdfUtils.cloneModel(secondDataset.getNamedModel(name)));
        }
        return new Pair<Dataset>(firstResultDataset, secondResultDataset);
    }

    public static void setBaseURI(Model model, String baseURI) {
        model.getNsPrefixMap().put("", baseURI);
    }

    public static void replaceBaseURI(Model model, String baseURI) {
        RdfUtils.replaceBaseURI(model, baseURI, false);
    }

    public static void replaceBaseURI(Model model, String baseURI, boolean renamePrefixedURIs) {
        Resource oldBase = model.getResource(model.getNsPrefixURI(""));
        if (oldBase != null) {
            if (renamePrefixedURIs) {
                RdfUtils.renameResourceWithPrefix(model, oldBase.toString(), baseURI);
            }
            ResourceUtils.renameResource((Resource)oldBase, (String)baseURI);
        }
        model.setNsPrefix("", baseURI);
    }

    public static void renameResourceWithPrefix(Dataset dataset, final String prefix, final String replacement) {
        RdfUtils.visit(dataset, new ModelVisitor<Void>(){

            @Override
            public Void visit(Model model) {
                RdfUtils.renameResourceWithPrefix(model, prefix, replacement);
                return null;
            }
        });
        Iterator modelNames = dataset.listNames();
        HashMap<String, String> toReplace = new HashMap<String, String>();
        while (modelNames.hasNext()) {
            String modelName = (String)modelNames.next();
            if (!modelName.startsWith(prefix)) continue;
            String newModelName = replacement + modelName.substring(prefix.length());
            toReplace.put(modelName, newModelName);
        }
        toReplace.entrySet().stream().forEach(e -> {
            Model model = dataset.getNamedModel((String)e.getKey());
            dataset.removeNamedModel((String)e.getKey());
            dataset.addNamedModel((String)e.getValue(), model);
        });
    }

    public static void renameResourceWithPrefix(Model model, String prefix, String replacement) {
        Set<Resource> uriResources = RdfUtils.listUriResources(model);
        for (Resource r : uriResources) {
            if (!r.getURI().startsWith(prefix)) continue;
            ResourceUtils.renameResource((Resource)r, (String)(replacement + r.getURI().substring(prefix.length())));
        }
    }

    public static Set<Resource> listUriResources(Model model) {
        HashSet<Resource> uriResources = new HashSet<Resource>();
        StmtIterator it = model.listStatements();
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            Resource subject = s.getSubject();
            RDFNode object = s.getObject();
            if (subject.isURIResource()) {
                uriResources.add(subject);
            }
            if (!object.isURIResource()) continue;
            uriResources.add(object.asResource());
        }
        return uriResources;
    }

    public static void replaceBaseURI(Dataset dataset, String baseURI) {
        RdfUtils.replaceBaseURI(dataset, baseURI, false);
    }

    public static void replaceBaseURI(Dataset dataset, String baseURI, boolean renamePrefixedURIs) {
        RdfUtils.visit(dataset, model -> {
            RdfUtils.replaceBaseURI(model, baseURI, renamePrefixedURIs);
            return null;
        });
    }

    public static void replaceBaseResource(Model model, Resource replacement) {
        RdfUtils.replaceBaseResource(model, replacement, false);
    }

    public static void replaceBaseResource(Model model, Resource replacement, boolean renamePrefixedURIs) {
        String baseURI = model.getNsPrefixURI("");
        if (baseURI == null) {
            return;
        }
        Resource baseUriResource = model.getResource(baseURI);
        if (renamePrefixedURIs) {
            RdfUtils.renameResourceWithPrefix(model, baseUriResource.getURI(), replacement.getURI());
        } else {
            RdfUtils.replaceResourceInModel(baseUriResource, replacement);
        }
        model.setNsPrefix("", replacement.getURI());
    }

    public static void replaceBaseResource(Dataset dataset, Resource replacement) {
        RdfUtils.replaceBaseResource(dataset, replacement, false);
    }

    public static void replaceBaseResource(Dataset dataset, final Resource replacement, final boolean renamePrefixedURIs) {
        RdfUtils.visit(dataset, new ModelVisitor<Object>(){

            @Override
            public Object visit(Model model) {
                RdfUtils.replaceBaseResource(model, replacement, renamePrefixedURIs);
                return null;
            }
        });
    }

    public static void replaceResourceInModel(Resource resource, Resource replacement) {
        StatementImpl newStmt;
        Statement origStmt;
        logger.debug("replacing resource '{}' with resource '{}'", (Object)resource, (Object)replacement);
        if (!resource.getModel().equals((Object)replacement.getModel())) {
            throw new IllegalArgumentException("resource and replacement must be from the same model");
        }
        Model model = resource.getModel();
        Model modelForNewStatements = ModelFactory.createDefaultModel();
        StmtIterator iterator = model.listStatements(resource, (Property)null, (RDFNode)null);
        while (iterator.hasNext()) {
            origStmt = (Statement)iterator.next();
            newStmt = new StatementImpl(replacement, origStmt.getPredicate(), origStmt.getObject());
            iterator.remove();
            modelForNewStatements.add((Statement)newStmt);
        }
        iterator = model.listStatements(null, (Property)null, (RDFNode)resource);
        while (iterator.hasNext()) {
            origStmt = (Statement)iterator.next();
            newStmt = new StatementImpl(origStmt.getSubject(), origStmt.getPredicate(), (RDFNode)replacement);
            iterator.remove();
            modelForNewStatements.add((Statement)newStmt);
        }
        model.add(modelForNewStatements);
    }

    public static void removeResource(Model model, Resource resource) {
        model.removeAll(resource, null, (RDFNode)null);
        model.removeAll(null, null, (RDFNode)resource);
    }

    public static Model mergeModelsCombiningBaseResource(Model model1, Model model2) {
        if (logger.isDebugEnabled()) {
            logger.debug("model1:\n{}", (Object)RdfUtils.writeModelToString(model1, Lang.TTL));
            logger.debug("model2:\n{}", (Object)RdfUtils.writeModelToString(model2, Lang.TTL));
        }
        Model result = ModelFactory.createDefaultModel();
        result.setNsPrefixes(RdfUtils.mergeNsPrefixes(model1.getNsPrefixMap(), model2.getNsPrefixMap()));
        result.add(model1);
        result.add(model2);
        if (logger.isDebugEnabled()) {
            logger.debug("result (before merging base resources):\n{}", (Object)RdfUtils.writeModelToString(result, Lang.TTL));
        }
        Resource baseResource1 = RdfUtils.getBaseResource(model1);
        Resource baseResource2 = RdfUtils.getBaseResource(model2);
        RdfUtils.replaceResourceInModel(result.getResource(baseResource1.getURI()), result.getResource(baseResource2.getURI()));
        String prefix = model1.getNsPrefixURI("");
        if (prefix != null) {
            result.setNsPrefix("", prefix);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("result (after merging base resources):\n{}", (Object)RdfUtils.writeModelToString(result, Lang.TTL));
        }
        return result;
    }

    public static Resource findOrCreateBaseResource(Model model) {
        String baseURI = model.getNsPrefixURI("");
        if (baseURI == null) {
            model.setNsPrefix("", "no:uri");
            baseURI = model.getNsPrefixURI("");
        }
        return model.getResource(baseURI);
    }

    public static Resource getBaseResource(Model model) {
        String baseURI = model.getNsPrefixURI("");
        if (baseURI == null) {
            return model.getResource("");
        }
        return model.getResource(baseURI);
    }

    public static String writeModelToString(Model model, Lang lang) {
        StringWriter out = new StringWriter();
        RDFDataMgr.write((StringWriter)out, (Model)model, (Lang)lang);
        return out.toString();
    }

    public static Model replaceResource(Resource resource, Resource replacement) {
        if (!resource.getModel().equals((Object)replacement.getModel())) {
            throw new IllegalArgumentException("resource and replacement must be from the same model");
        }
        Model result = ModelFactory.createDefaultModel();
        result.setNsPrefixes(resource.getModel().getNsPrefixMap());
        StmtIterator it = resource.getModel().listStatements();
        while (it.hasNext()) {
            Statement stmt = it.nextStatement();
            Resource subject = stmt.getSubject();
            Property predicate = stmt.getPredicate();
            RDFNode object = stmt.getObject();
            if (subject.equals((Object)resource)) {
                subject = replacement;
            }
            if (predicate.equals((Object)resource)) {
                predicate = replacement;
            }
            if (object.equals(resource)) {
                object = replacement;
            }
            Triple triple = new Triple(subject.asNode(), predicate.asNode(), object.asNode());
            result.getGraph().add(triple);
        }
        return result;
    }

    public static Set<URI> getGraphUris(Dataset dataset) {
        Iterator urisIterator = dataset.listNames();
        HashSet<URI> uris = new HashSet<URI>();
        while (urisIterator.hasNext()) {
            uris.add(URI.create((String)urisIterator.next()));
        }
        return uris;
    }

    public static void attachModelByBaseResource(Resource subject, Property property, Model objectModel) {
        RdfUtils.attachModelByBaseResource(subject, property, objectModel, true);
    }

    public static void attachModelByBaseResource(Resource subject, Property property, Model objectModel, boolean replaceBaseResourceByBlankNode) {
        Model subjectModel = subject.getModel();
        if (replaceBaseResourceByBlankNode || objectModel.getNsPrefixURI("") == null) {
            String tempURI = "tmp:" + Integer.toHexString(objectModel.hashCode());
            RdfUtils.replaceBaseResource(objectModel, objectModel.createResource(tempURI));
            subjectModel.add(objectModel);
            Resource blankNode = subjectModel.createResource();
            subject.addProperty(property, (RDFNode)blankNode);
            RdfUtils.replaceResourceInModel(subjectModel.getResource(tempURI), blankNode);
            Map objectModelPrefixes = objectModel.getNsPrefixMap();
            objectModelPrefixes.remove("");
            subjectModel.setNsPrefixes(RdfUtils.mergeNsPrefixes(subjectModel.getNsPrefixMap(), objectModelPrefixes));
        } else {
            String baseURI = objectModel.getNsPrefixURI("");
            Resource baseResource = objectModel.getResource(baseURI);
            subjectModel.add(objectModel);
            baseResource = subjectModel.getResource(baseResource.getURI());
            subject.addProperty(property, (RDFNode)baseResource);
            RdfUtils.replaceBaseResource(subjectModel, baseResource);
        }
    }

    public static Map<String, String> mergeNsPrefixes(Map<String, String> prioritaryPrefixes, Map<String, String> additionalPrefixes) {
        HashMap<String, String> mergedPrefixes = new HashMap<String, String>();
        mergedPrefixes.putAll(additionalPrefixes);
        mergedPrefixes.putAll(prioritaryPrefixes);
        return mergedPrefixes;
    }

    public static Model readRdfSnippet(InputStream in, String rdfLanguage) {
        Model model = ModelFactory.createDefaultModel();
        if (in == null) {
            return model;
        }
        String baseURI = "no:uri";
        model.setNsPrefix("", baseURI);
        model.read(in, baseURI, rdfLanguage);
        String baseURIAfterReading = model.getNsPrefixURI("");
        if (baseURIAfterReading == null) {
            model.setNsPrefix("", baseURI);
        } else if (!baseURI.equals(baseURIAfterReading)) {
            ResourceUtils.renameResource((Resource)model.getResource(baseURI), (String)model.getNsPrefixURI(""));
        }
        return model;
    }

    public static Model readRdfSnippet(Reader in, String rdfLanguage) {
        Model model = ModelFactory.createDefaultModel();
        if (in == null) {
            return model;
        }
        String baseURI = "no:uri";
        model.setNsPrefix("", baseURI);
        model.read(in, baseURI, rdfLanguage);
        String baseURIAfterReading = model.getNsPrefixURI("");
        if (baseURIAfterReading == null) {
            model.setNsPrefix("", baseURI);
        } else if (!baseURI.equals(baseURIAfterReading)) {
            ResourceUtils.renameResource((Resource)model.getResource(baseURI), (String)model.getNsPrefixURI(""));
        }
        return model;
    }

    public static Model readRdfSnippet(String rdfAsString, String rdfLanguage) {
        return RdfUtils.readRdfSnippet(new StringReader(rdfAsString), rdfLanguage);
    }

    public static URI getURIPropertyForPropertyPath(Model model, URI resourceURI, Path propertyPath) {
        return RdfUtils.toURI(RdfUtils.getNodeForPropertyPath(model, resourceURI, propertyPath));
    }

    public static URI getURIPropertyForPropertyPath(Dataset dataset, URI resourceURI, Path propertyPath) {
        return RdfUtils.toURI(RdfUtils.getNodeForPropertyPath(dataset, resourceURI, propertyPath));
    }

    public static Iterator<URI> getURIsForPropertyPath(Model model, URI resourceURI, Path propertyPath) {
        Iterator<Node> nodeIterator = RdfUtils.getNodesForPropertyPath(model, resourceURI, propertyPath);
        return new ProjectingIterator<Node, URI>(nodeIterator){

            @Override
            public URI next() {
                return RdfUtils.toURI((Node)this.baseIterator.next());
            }
        };
    }

    public static Iterator<URI> getURIsForPropertyPath(Dataset dataset, URI resourceURI, Path propertyPath) {
        Iterator<Node> nodeIterator = RdfUtils.getNodesForPropertyPath(dataset, resourceURI, propertyPath);
        return new ProjectingIterator<Node, URI>(nodeIterator){

            @Override
            public URI next() {
                return RdfUtils.toURI((Node)this.baseIterator.next());
            }
        };
    }

    public static Iterator<RDFNode> getNodesForPropertyPathByQuery(Dataset dataset, URI resourceURI, Path propertyPath) {
        String queryString = "select ?obj where { GRAPH <urn:x-arq:UnionGraph> { ?resource " + propertyPath.toString() + " ?obj } }";
        Query query = QueryFactory.create((String)queryString);
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("?resource", (RDFNode)dataset.getDefaultModel().createResource(resourceURI.toString()));
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)dataset, (QuerySolution)initialBinding);){
            qExec.getContext().set(TDB.symUnionDefaultGraph, true);
            ResultSet results = qExec.execSelect();
            LinkedList<RDFNode> resultNodes = new LinkedList<RDFNode>();
            while (results.hasNext()) {
                QuerySolution soln = results.next();
                RDFNode result = soln.get("obj");
                resultNodes.add(result);
            }
            Iterator<RDFNode> iterator = resultNodes.iterator();
            return iterator;
        }
    }

    public static String setSparqlVars(String stmt, String var, Object obj) {
        StringBuilder replacement = new StringBuilder();
        if (obj instanceof URI) {
            replacement.append("<").append(obj.toString()).append(">");
        } else if (obj instanceof List) {
            for (Object itm : (List)obj) {
                if (!(itm instanceof URI)) continue;
                replacement.append("<").append(itm.toString()).append(">,");
            }
            replacement.deleteCharAt(replacement.length() - 1);
        }
        return stmt.replaceAll("::" + var + "::", replacement.toString());
    }

    public static String setSparqlVars(String stmt, Map<String, Object> varMap) {
        for (Map.Entry<String, Object> entry : varMap.entrySet()) {
            stmt = RdfUtils.setSparqlVars(stmt, entry.getKey(), entry.getValue());
        }
        return stmt;
    }

    public static Iterator<URI> getURIsForPropertyPathByQuery(Dataset dataset, URI resourceURI, Path propertyPath) {
        Iterator<RDFNode> nodeIterator = RdfUtils.getNodesForPropertyPathByQuery(dataset, resourceURI, propertyPath);
        return new ProjectingIterator<RDFNode, URI>(nodeIterator){

            @Override
            public URI next() {
                return RdfUtils.toURI((RDFNode)this.baseIterator.next());
            }
        };
    }

    public static String getStringPropertyForPropertyPath(Model model, URI resourceURI, Path propertyPath) {
        return RdfUtils.toString(RdfUtils.getNodeForPropertyPath(model, resourceURI, propertyPath));
    }

    public static String getStringPropertyForPropertyPath(Dataset dataset, URI resourceURI, Path propertyPath) {
        return RdfUtils.toString(RdfUtils.getNodeForPropertyPath(dataset, resourceURI, propertyPath));
    }

    public static String toString(Node node) {
        if (node == null) {
            return null;
        }
        return node.getLiteralLexicalForm();
    }

    public static URI toURI(Node node) {
        if (node == null) {
            return null;
        }
        return URI.create(node.getURI());
    }

    public static URI toURI(RDFNode node) {
        if (node == null) {
            return null;
        }
        return URI.create(node.asResource().getURI());
    }

    public static Node getNodeForPropertyPath(Model model, URI resourceURI, Path propertyPath) {
        Iterator result = PathEval.eval((Graph)model.getGraph(), (Node)model.getResource(resourceURI.toString()).asNode(), (Path)propertyPath, (Context)Context.emptyContext);
        if (!result.hasNext()) {
            return null;
        }
        return (Node)result.next();
    }

    public static Node getNodeForPropertyPath(Model model, Node node, Path propertyPath) {
        Iterator result = PathEval.eval((Graph)model.getGraph(), (Node)node, (Path)propertyPath, (Context)Context.emptyContext);
        if (!result.hasNext()) {
            return null;
        }
        return (Node)result.next();
    }

    public static Node getNodeForPropertyPath(Dataset dataset, final URI resourceURI, final Path propertyPath) {
        return RdfUtils.findFirst(dataset, new ModelVisitor<Node>(){

            @Override
            public Node visit(Model model) {
                return RdfUtils.getNodeForPropertyPath(model, resourceURI, propertyPath);
            }
        });
    }

    public static Iterator<Node> getNodesForPropertyPath(Model model, URI resourceURI, Path propertyPath) {
        return PathEval.eval((Graph)model.getGraph(), (Node)model.getResource(resourceURI.toString()).asNode(), (Path)propertyPath, (Context)Context.emptyContext);
    }

    public static <T> Iterator<T> getObjectsForPropertyPath(Model model, URI resourceURI, Path propertyPath, Function<Node, T> mapper) {
        return RdfUtils.getObjectStreamForPropertyPath(model, resourceURI, propertyPath, mapper).iterator();
    }

    public static <T> Stream<T> getObjectStreamForPropertyPath(Model model, URI resourceURI, Path propertyPath, Function<Node, T> mapper) {
        Iterator result = PathEval.eval((Graph)model.getGraph(), (Node)model.getResource(resourceURI.toString()).asNode(), (Path)propertyPath, (Context)Context.emptyContext);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(result, 16), false).map(mapper);
    }

    public static <T> Iterator<T> getObjectsForPropertyPath(Dataset dataset, URI resourceURI, Path propertyPath, Function<Node, T> mapper) {
        return RdfUtils.getObjectStreamForPropertyPath(dataset, resourceURI, propertyPath, mapper).iterator();
    }

    public static <T> Stream<T> getObjectStreamForPropertyPath(Dataset dataset, URI resourceURI, Path propertyPath, Function<Node, T> mapper) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new DefaultModelSelector().select(dataset), 16), false).flatMap(model -> RdfUtils.getObjectStreamForPropertyPath(model, resourceURI, propertyPath, mapper));
    }

    public static <T> Stream<T> getObjectStreamOfProperty(Dataset dataset, URI resourceURI, URI property, Function<RDFNode, T> mapper) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new DefaultModelSelector().select(dataset), 16), false).flatMap(model -> RdfUtils.getObjectStreamOfProperty(model, resourceURI, property, mapper));
    }

    public static <T> Stream<T> getObjectStreamOfProperty(Model model, URI resourceURI, URI property, Function<RDFNode, T> mapper) {
        NodeIterator it = model.listObjectsOfProperty(model.createResource(resourceURI.toString()), model.createProperty(property.toString()));
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false).map(mapper);
    }

    public static <T> List<T> getObjectsOfProperty(Dataset dataset, final URI resource, final URI property, final Function<RDFNode, T> resultMapper) {
        return RdfUtils.visitFlattenedToList(dataset, new ModelVisitor<Collection<T>>(){

            @Override
            public Collection<T> visit(Model model) {
                Resource res = model.getResource(resource.toString());
                if (res == null) {
                    return Collections.emptyList();
                }
                NodeIterator it = model.listObjectsOfProperty(res, model.createProperty(property.toString()));
                ArrayList ret = new ArrayList();
                while (it.hasNext()) {
                    RDFNode node = it.next();
                    ret.add(resultMapper.apply(node));
                }
                return ret;
            }
        });
    }

    public static <T> Optional<T> getFirstObjectOfProperty(Dataset dataset, final URI resource, final URI property, final Function<RDFNode, T> resultMapper) {
        T result = RdfUtils.findFirst(dataset, new ModelVisitor<T>(){

            @Override
            public T visit(Model model) {
                Resource subj = model.getResource(resource.toString());
                Property pred = model.getProperty(property.toString());
                if (pred == null) {
                    return null;
                }
                Statement stmt = model.getProperty(subj, pred);
                RDFNode obj = stmt.getObject();
                return resultMapper.apply(obj);
            }
        });
        return Optional.ofNullable(result);
    }

    public static <T> Optional<T> getFirstStatementMapped(Dataset dataset, final URI subject, final URI predicate, final URI object, final Function<Statement, T> resultMapper) {
        T result = RdfUtils.findFirst(dataset, new ModelVisitor<T>(){

            @Override
            public T visit(Model model) {
                Resource obj;
                Property pred;
                Resource subj = subject == null ? null : model.getResource(subject.toString());
                StmtIterator it = model.listStatements(subj, pred = predicate == null ? null : model.getProperty(predicate.toString()), (RDFNode)(obj = object == null ? null : model.getResource(object.toString())));
                if (it.hasNext()) {
                    return resultMapper.apply(it.next());
                }
                return null;
            }
        });
        return Optional.ofNullable(result);
    }

    public static Iterator<Node> getNodesForPropertyPath(Dataset dataset, final URI resourceURI, final Path propertyPath) {
        return Iterators.concat(RdfUtils.visit(dataset, new ModelVisitor<Iterator<Node>>(){

            @Override
            public Iterator<Node> visit(Model model) {
                return RdfUtils.getNodesForPropertyPath(model, resourceURI, propertyPath);
            }
        }));
    }

    public static URI toUriOrNull(Object uriStringOrNull) {
        if (uriStringOrNull == null) {
            return null;
        }
        return URI.create(uriStringOrNull.toString());
    }

    public static Stream<Statement> toStatementStream(Dataset dataset) {
        return RdfUtils.toStatementStream(dataset, new DefaultModelSelector());
    }

    public static Stream<Statement> toStatementStream(Dataset dataset, ModelSelector modelSelector) {
        LinkedList<Object> results = new LinkedList<Object>();
        Iterator<Model> modelIterator = modelSelector.select(dataset);
        while (modelIterator.hasNext()) {
            Model m = modelIterator.next();
            StmtIterator stmtIt = m.listStatements();
            while (stmtIt.hasNext()) {
                results.add(stmtIt.next());
            }
        }
        return results.stream();
    }

    public static Stream<Statement> toStatementStream(Model model) {
        LinkedList<Object> results = new LinkedList<Object>();
        StmtIterator stmtIt = model.listStatements();
        while (stmtIt.hasNext()) {
            results.add(stmtIt.next());
        }
        return results.stream();
    }

    public static Stream<Model> toModelStream(Dataset dataset) {
        LinkedList<Model> ret = new LinkedList<Model>();
        Model model = dataset.getDefaultModel();
        if (model != null) {
            ret.add(model);
        }
        Iterator modelNames = dataset.listNames();
        while (modelNames.hasNext()) {
            ret.add(dataset.getNamedModel((String)modelNames.next()));
        }
        return ret.stream();
    }

    public static Stream<NamedModel> toNamedModelStream(Dataset dataset, boolean includeDefaultModel) {
        Model model;
        LinkedList<NamedModel> ret = new LinkedList<NamedModel>();
        if (includeDefaultModel && (model = dataset.getDefaultModel()) != null) {
            ret.add(new NamedModel(null, model));
        }
        Iterator modelNames = dataset.listNames();
        while (modelNames.hasNext()) {
            String name = (String)modelNames.next();
            ret.add(new NamedModel(name, dataset.getNamedModel(name)));
        }
        return ret.stream();
    }

    public static ModelSelector getDefaultModelSelector() {
        return DEFAULT_MODEL_SELECTOR;
    }

    public static <T> Iterator<T> visit(Dataset dataset, ModelVisitor<T> visitor, ModelSelector modelSelector) {
        LinkedList<T> results = new LinkedList<T>();
        Iterator<Model> modelIterator = modelSelector.select(dataset);
        while (modelIterator.hasNext()) {
            results.add(visitor.visit(modelIterator.next()));
        }
        return results.iterator();
    }

    public static <T> Iterator<T> visit(Dataset dataset, ModelVisitor<T> visitor) {
        return RdfUtils.visit(dataset, visitor, RdfUtils.getDefaultModelSelector());
    }

    public static <E, T extends Collection<E>> List<E> visitFlattenedToList(Dataset dataset, ModelVisitor<T> visitor, ModelSelector modelSelector) {
        ArrayList results = new ArrayList();
        Iterator<Model> modelIterator = modelSelector.select(dataset);
        while (modelIterator.hasNext()) {
            results.addAll((Collection)visitor.visit(modelIterator.next()));
        }
        return results;
    }

    public static <E, T extends Collection<E>> List<E> visitFlattenedToList(Dataset dataset, ModelVisitor<T> visitor) {
        return RdfUtils.visitFlattenedToList(dataset, visitor, RdfUtils.getDefaultModelSelector());
    }

    public static NodeIterator visitFlattenedToNodeIterator(Dataset dataset, ModelVisitor<NodeIterator> visitor, ModelSelector modelSelector) {
        NodeIterator it = null;
        Iterator<Model> modelIterator = modelSelector.select(dataset);
        while (modelIterator.hasNext()) {
            NodeIterator currentIt = visitor.visit(modelIterator.next());
            if (it == null) {
                it = currentIt;
                continue;
            }
            it.andThen((Iterator)currentIt);
        }
        return it;
    }

    public static NodeIterator visitFlattenedToNodeIterator(Dataset dataset, ModelVisitor<NodeIterator> visitor) {
        return RdfUtils.visitFlattenedToNodeIterator(dataset, visitor, RdfUtils.getDefaultModelSelector());
    }

    public static <T> T findFirst(Dataset dataset, ModelVisitor<T> visitor, ModelSelector modelSelector) {
        LinkedList results = new LinkedList();
        Iterator<Model> modelIterator = modelSelector.select(dataset);
        while (modelIterator.hasNext()) {
            T result = visitor.visit(modelIterator.next());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static <T> T findFirst(Dataset dataset, ModelVisitor<T> visitor) {
        return RdfUtils.findFirst(dataset, visitor, RdfUtils.getDefaultModelSelector());
    }

    public static <T> T findOne(Dataset dataset, ModelVisitor<T> visitor, ModelSelector modelSelector, boolean allowSame) {
        Object result = null;
        Iterator<Model> modelIterator = modelSelector.select(dataset);
        while (modelIterator.hasNext()) {
            T newResult = visitor.visit(modelIterator.next());
            if (newResult == null) continue;
            if (!(result == null || allowSame && result.equals(newResult))) {
                throw new IncorrectPropertyCountException("Results were found in more than one model", 1, 2);
            }
            result = newResult;
        }
        if (result == null) {
            throw new IncorrectPropertyCountException("No result found", 1, 0);
        }
        return (T)result;
    }

    public static <T> T findOne(Dataset dataset, ModelVisitor<T> visitor, boolean allowSame) {
        return RdfUtils.findOne(dataset, visitor, RdfUtils.getDefaultModelSelector(), allowSame);
    }

    public static <T> T applyMethod(Dataset dataset, ModelVisitor<T> visitor, ModelSelector modelSelector, ResultCombiner<T> resultCombiner) {
        Object result = null;
        Iterator<Model> modelIterator = modelSelector.select(dataset);
        while (modelIterator.hasNext()) {
            T newResult = visitor.visit(modelIterator.next());
            if (result != null) {
                result = resultCombiner.combine(result, newResult);
                continue;
            }
            result = newResult;
        }
        return result;
    }

    public static <T> T applyMethod(Dataset dataset, ModelVisitor<T> visitor, ResultCombiner<T> resultCombiner) {
        return RdfUtils.applyMethod(dataset, visitor, RdfUtils.getDefaultModelSelector(), resultCombiner);
    }

    public static RDFNode findFirstPropertyFromResource(Dataset dataset, final URI resourceURI, final Property p) {
        return RdfUtils.findFirst(dataset, new ModelVisitor<RDFNode>(){

            @Override
            public RDFNode visit(Model model) {
                return RdfUtils.findFirstPropertyFromResource(model, resourceURI, p);
            }
        });
    }

    public static RDFNode findOnePropertyFromResource(Dataset dataset, final URI resourceURI, final Property p) {
        return RdfUtils.findOne(dataset, new ModelVisitor<RDFNode>(){

            @Override
            public RDFNode visit(Model model) {
                return RdfUtils.findOnePropertyFromResource(model, resourceURI, p);
            }
        }, true);
    }

    public static RDFNode findFirstPropertyFromResource(Dataset dataset, final Resource resource, final Property p) {
        return RdfUtils.findFirst(dataset, new ModelVisitor<RDFNode>(){

            @Override
            public RDFNode visit(Model model) {
                return RdfUtils.findFirstPropertyFromResource(model, resource, p);
            }
        });
    }

    public static RDFNode findOnePropertyFromResource(Dataset dataset, final Resource resource, final Property p) {
        return RdfUtils.findOne(dataset, new ModelVisitor<RDFNode>(){

            @Override
            public RDFNode visit(Model model) {
                return RdfUtils.findOnePropertyFromResource(model, resource, p);
            }
        }, true);
    }

    public static RDFNode findFirstPropertyFromResource(Model model, URI resourceURI, Property property) {
        Resource resource = null;
        if (resourceURI != null) {
            resource = model.getResource(resourceURI.toString());
        }
        return RdfUtils.findFirstPropertyFromResource(model, resource, property);
    }

    public static RDFNode findOnePropertyFromResource(Model model, URI resourceURI, Property property) {
        Resource resource = null;
        if (resourceURI != null) {
            resource = model.getResource(resourceURI.toString());
        }
        return RdfUtils.findOnePropertyFromResource(model, resource, property);
    }

    public static RDFNode findFirstPropertyOf(Resource resource, Property property) {
        return RdfUtils.findFirstPropertyFromResource(resource.getModel(), resource, property);
    }

    public static Optional<RDFNode> findFirstPropertyOfO(Resource resource, Property property) {
        return Optional.ofNullable(RdfUtils.findFirstPropertyOf(resource, property));
    }

    public static RDFNode findFirstPropertyFromResource(Model model, Resource resource, Property property) {
        Objects.nonNull(model);
        Objects.nonNull(resource);
        Objects.nonNull(property);
        NodeIterator iterator = model.listObjectsOfProperty(resource, property);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static RDFNode findOnePropertyFromResource(Model model, Resource resource, Property property) {
        ArrayList<RDFNode> foundNodes = new ArrayList<RDFNode>();
        NodeIterator iterator = model.listObjectsOfProperty(resource, property);
        while (iterator.hasNext()) {
            foundNodes.add(iterator.next());
        }
        if (foundNodes.size() == 0) {
            return null;
        }
        if (foundNodes.size() == 1) {
            return (RDFNode)foundNodes.get(0);
        }
        if (foundNodes.size() > 1) {
            RDFNode n = (RDFNode)foundNodes.get(0);
            for (RDFNode node : foundNodes) {
                if (node.equals(n)) continue;
                throw new IncorrectPropertyCountException(1, 2);
            }
            return n;
        }
        return null;
    }

    public static Resource findOneSubjectResource(Dataset dataset, final Property property, final RDFNode object) {
        return RdfUtils.findOne(dataset, new ModelVisitor<Resource>(){

            @Override
            public Resource visit(Model model) {
                return RdfUtils.findOneOrNoSubjectResource(model, property, object);
            }
        }, true);
    }

    public static List<Resource> findSubjectResources(Dataset dataset, final Property property, final RDFNode object) {
        return RdfUtils.visitFlattenedToList(dataset, new ModelVisitor<List<Resource>>(){

            @Override
            public List<Resource> visit(Model model) {
                ArrayList<Resource> ret = new ArrayList<Resource>();
                ResIterator it = model.listSubjectsWithProperty(property, object);
                while (it.hasNext()) {
                    ret.add((Resource)it.next());
                }
                return ret;
            }
        });
    }

    public static Resource findOneSubjectResource(Model model, Property property, RDFNode object) {
        Resource resource = null;
        ResIterator iter = model.listSubjectsWithProperty(property, object);
        while (iter.hasNext()) {
            resource = (Resource)iter.next();
            if (!iter.hasNext()) continue;
            throw new IncorrectPropertyCountException("expecting exactly one subject resource for property " + property.getURI() + " and object " + object.toString(), 1, 2);
        }
        if (resource == null) {
            throw new IncorrectPropertyCountException("expecting exactly one subject resource for property " + property.getURI() + " and object " + object.toString(), 1, 0);
        }
        return resource;
    }

    public static Resource findOneOrNoSubjectResource(Model model, Property property, RDFNode object) {
        Resource resource = null;
        ResIterator iter = model.listSubjectsWithProperty(property, object);
        while (iter.hasNext()) {
            resource = (Resource)iter.next();
            if (!iter.hasNext()) continue;
            throw new IncorrectPropertyCountException("expecting one or no subject resource for property " + property.getURI() + " and object " + object.toString(), 1, 2);
        }
        return resource;
    }

    public static URI findFirstSubjectUri(Model model, Property property, RDFNode object, boolean allowMultiple, boolean allowNone) {
        URI retVal = null;
        StmtIterator it = model.listStatements(null, property, object);
        if (!it.hasNext() && !allowNone) {
            throw new IllegalArgumentException("expecting at least one triple");
        }
        if (it.hasNext()) {
            retVal = URI.create(it.nextStatement().getSubject().asResource().toString());
        }
        if (!allowMultiple && it.hasNext()) {
            throw new IllegalArgumentException("not expecting more than one triple");
        }
        return retVal;
    }

    public static URI findFirstObjectUri(Model model, Property property, RDFNode object, boolean allowMultiple, boolean allowNone) {
        URI retVal = null;
        StmtIterator it = model.listStatements(null, property, object);
        if (!it.hasNext() && !allowNone) {
            throw new IllegalArgumentException("expecting at least one triple");
        }
        if (it.hasNext()) {
            retVal = URI.create(it.nextStatement().getObject().asResource().toString());
        }
        if (!allowMultiple && it.hasNext()) {
            throw new IllegalArgumentException("not expecting more than one triple");
        }
        return retVal;
    }

    public static URI createNewGraphURI(String baseURI, String toAppend, int length, final Dataset dataset) {
        return RdfUtils.createNewGraphURI(baseURI, toAppend, length, new GraphNameCheck(){

            @Override
            public boolean isGraphUriOk(String graphUri) {
                return !dataset.containsNamedModel(graphUri);
            }
        });
    }

    public static URI createNewGraphURI(String baseURI, String toAppend, int length, GraphNameCheck check) {
        int hashIndex;
        if (toAppend.contains("#") && (hashIndex = baseURI.indexOf(35)) > -1) {
            baseURI = baseURI.substring(0, hashIndex);
        }
        int maxTries = 5;
        for (int i = 0; i < maxTries; ++i) {
            String graphName = baseURI + toAppend + randomString.nextString(length);
            if (!check.isGraphUriOk(graphName)) continue;
            return URI.create(graphName);
        }
        throw new IllegalStateException("Tried " + maxTries + " times to generate a new graph URI (" + length + " random characters), but were unable to generate a previously unused one; giving up.");
    }

    public static void addAllStatements(Model toModel, Model fromModel) {
        StmtIterator stmtIterator = fromModel.listStatements();
        while (stmtIterator.hasNext()) {
            toModel.add(stmtIterator.nextStatement());
        }
    }

    public static void addPrefixMapping(Model toModel, Model fromModel) {
        for (String prefix : fromModel.getNsPrefixMap().keySet()) {
            String uri = toModel.getNsPrefixURI(prefix);
            if (uri == null) {
                toModel.setNsPrefix(prefix, fromModel.getNsPrefixURI(prefix));
                continue;
            }
            if (uri.equals(fromModel.getNsPrefixURI(prefix))) continue;
            int counter = 2;
            while (!toModel.getNsPrefixMap().containsKey(prefix + counter)) {
                ++counter;
            }
            toModel.setNsPrefix(prefix + counter, fromModel.getNsPrefixURI(prefix));
        }
    }

    public static List<String> getModelNames(Dataset dataset) {
        ArrayList<String> modelNames = new ArrayList<String>();
        Iterator names = dataset.listNames();
        while (names.hasNext()) {
            modelNames.add((String)names.next());
        }
        return modelNames;
    }

    public static String writeDatasetToString(Dataset dataset, Lang lang) {
        StringWriter sw = new StringWriter();
        RDFDataMgr.write((StringWriter)sw, (Dataset)dataset, (Lang)lang);
        return sw.toString();
    }

    public static Dataset readDatasetFromString(String data, Lang lang) {
        StringReader sr = new StringReader(data);
        Dataset dataset = DatasetFactory.createGeneral();
        RDFDataMgr.read((Dataset)dataset, (StringReader)sr, (String)"no:uri", (Lang)lang);
        return dataset;
    }

    public static Set<String> getModelsOfResource(Dataset dataset, RDFNode resource) {
        return RdfUtils.toNamedModelStream(dataset, false).map(nm -> ((NamedModel)nm).model.containsResource(resource) ? ((NamedModel)nm).name : null).filter(name -> name != null).collect(Collectors.toSet());
    }

    public static Set<String> getModelsOfSubjectResource(Dataset dataset, RDFNode resource) {
        return RdfUtils.toNamedModelStream(dataset, false).map(nm -> ((NamedModel)nm).model.contains(resource.asResource(), (Property)null, (RDFNode)null) ? ((NamedModel)nm).name : null).filter(name -> name != null).collect(Collectors.toSet());
    }

    public static Dataset addDatasetToDataset(Dataset baseDataset, Dataset toBeAddedtoBase, boolean replaceNamedModel) {
        if (baseDataset == null) {
            throw new IllegalArgumentException("baseDataset must not be null");
        }
        if (toBeAddedtoBase == null) {
            throw new IllegalArgumentException("toBeAddedToBase must not be null");
        }
        baseDataset.getDefaultModel().add(toBeAddedtoBase.getDefaultModel());
        Iterator nameIt = toBeAddedtoBase.listNames();
        while (nameIt.hasNext()) {
            String modelName = (String)nameIt.next();
            if (baseDataset.containsNamedModel(modelName)) {
                if (replaceNamedModel) {
                    baseDataset.removeNamedModel(modelName);
                    baseDataset.addNamedModel(modelName, toBeAddedtoBase.getNamedModel(modelName));
                    continue;
                }
                baseDataset.getNamedModel(modelName).add(toBeAddedtoBase.getNamedModel(modelName));
                continue;
            }
            baseDataset.addNamedModel(modelName, toBeAddedtoBase.getNamedModel(modelName));
        }
        return baseDataset;
    }

    public static Dataset addDatasetToDataset(Dataset baseDataset, Dataset toBeAddedtoBase) {
        return RdfUtils.addDatasetToDataset(baseDataset, toBeAddedtoBase, false);
    }

    public static Model mergeAllDataToSingleModel(Dataset ds) {
        Model mergedModel = ModelFactory.createDefaultModel();
        Iterator nameIter = ds.listNames();
        mergedModel.add(ds.getDefaultModel());
        while (nameIter.hasNext()) {
            mergedModel.add(ds.getNamedModel((String)nameIter.next()));
        }
        return mergedModel;
    }

    public static void copyDatasetTriplesToModel(Dataset dataset, final Model model) {
        assert (dataset != null) : "dataset must not be null";
        assert (model != null) : "model must not be null";
        RdfUtils.visit(dataset, new ModelVisitor<Object>(){

            @Override
            public Object visit(Model datasetModel) {
                model.add(datasetModel);
                return null;
            }
        });
    }

    public static Model condenseModelByIterativeTesting(Model model, Function<Model, Boolean> isModelValidTest) {
        Model condensedModel = RdfUtils.cloneModel(model);
        boolean done = false;
        while (!done) {
            done = true;
            for (Statement stmt : condensedModel.listStatements().toList()) {
                Model backupModel = RdfUtils.cloneModel(condensedModel);
                condensedModel.remove(stmt);
                if (isModelValidTest.apply(condensedModel).booleanValue()) {
                    done = false;
                    continue;
                }
                condensedModel = backupModel;
            }
        }
        return condensedModel;
    }

    public static interface GraphNameCheck {
        public boolean isGraphUriOk(String var1);
    }

    public static class NamedModel {
        private String name;
        private Model model;

        public NamedModel(String name, Model model) {
            this.name = name;
            this.model = model;
        }

        public String getName() {
            return this.name;
        }

        public Model getModel() {
            return this.model;
        }
    }

    public static class DefaultModelSelector
    implements ModelSelector {
        @Override
        public Iterator<Model> select(Dataset dataset) {
            LinkedList<Model> ret = new LinkedList<Model>();
            Model model = dataset.getDefaultModel();
            if (model != null) {
                ret.add(model);
            }
            Iterator modelNames = dataset.listNames();
            while (modelNames.hasNext()) {
                ret.add(dataset.getNamedModel((String)modelNames.next()));
            }
            return ret.iterator();
        }
    }

    public static interface ResultCombiner<T> {
        public T combine(T var1, T var2);
    }

    public static interface ModelSelector {
        public Iterator<Model> select(Dataset var1);
    }

    public static interface ModelVisitor<T> {
        public T visit(Model var1);
    }

    public static class Pair<E> {
        private E first;
        private E second;

        public Pair(E first, E second) {
            this.first = first;
            this.second = second;
        }

        public E getFirst() {
            return this.first;
        }

        public E getSecond() {
            return this.second;
        }
    }
}

