/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util;

import org.slf4j.Logger;

public class LoggingUtils {
    public static final void logMessageAsInfoAndStacktraceAsDebug(Logger logger, Exception e, String message, Object ... messageparams) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        String msg = message + " - exception: {}, message: {}";
        Object[] msgparams = new Object[messageparams.length + 2];
        System.arraycopy(messageparams, 0, msgparams, 0, messageparams.length);
        msgparams[msgparams.length - 2] = e.getClass();
        msgparams[msgparams.length - 1] = e.getMessage();
        logger.info(msg, msgparams);
        if (!logger.isDebugEnabled()) {
            logger.info("Stacktrace of cause is printed at loglevel 'debug'");
            return;
        }
        logger.debug("Stacktrace of cause: ", (Throwable)e);
    }
}

