/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.vocabulary.DC;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;
import won.protocol.vocabulary.CERT;
import won.protocol.vocabulary.SCHEMA;
import won.protocol.vocabulary.SFSIG;
import won.protocol.vocabulary.WON;
import won.protocol.vocabulary.WONCON;
import won.protocol.vocabulary.WONMATCH;
import won.protocol.vocabulary.WONMSG;

public class DefaultPrefixUtils {
    public static void setDefaultPrefixes(Model model) {
        DefaultPrefixUtils.setDefaultPrefixes(model.getGraph().getPrefixMapping());
    }

    public static void setDefaultPrefixes(PrefixMapping prefixMapping) {
        prefixMapping.setNsPrefix("won", WON.getURI());
        prefixMapping.setNsPrefix("msg", WONMSG.getURI());
        prefixMapping.setNsPrefix("con", WONCON.getURI());
        prefixMapping.setNsPrefix("match", WONMATCH.getURI());
        prefixMapping.setNsPrefix("sig", SFSIG.getURI());
        prefixMapping.setNsPrefix("cert", CERT.getURI());
        prefixMapping.setNsPrefix("rdf", RDF.getURI());
        prefixMapping.setNsPrefix("rdfs", RDFS.getURI());
        prefixMapping.setNsPrefix("xsd", XSD.getURI());
        prefixMapping.setNsPrefix("dc", DC.getURI());
        prefixMapping.setNsPrefix("dct", DCTerms.getURI());
        prefixMapping.setNsPrefix("s", SCHEMA.getURI());
        prefixMapping.setNsPrefix("sh", "http://www.w3.org/ns/shacl#");
        prefixMapping.setNsPrefix("rdfg", "http://www.w3.org/2004/03/trix/rdfg-1/");
    }

    public static PrefixMapping getDefaultPrefixes() {
        PrefixMapping ret = PrefixMapping.Factory.create();
        DefaultPrefixUtils.setDefaultPrefixes(ret);
        return ret;
    }
}

