/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util;

import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DC;
import org.apache.jena.vocabulary.RDF;
import won.protocol.model.AtomGraphType;
import won.protocol.model.Coordinate;
import won.protocol.util.AtomModelWrapper;
import won.protocol.util.RdfUtils;
import won.protocol.vocabulary.SCHEMA;
import won.protocol.vocabulary.WON;
import won.protocol.vocabulary.WONCON;
import won.protocol.vocabulary.WONMATCH;

public class DefaultAtomModelWrapper
extends AtomModelWrapper {
    public DefaultAtomModelWrapper(URI atomUri) {
        this(atomUri.toString());
    }

    public DefaultAtomModelWrapper(String atomUri) {
        super(atomUri);
    }

    public DefaultAtomModelWrapper(Dataset atomDataset) {
        super(atomDataset);
    }

    public DefaultAtomModelWrapper(Model atomModel, Model sysInfoModel) {
        super(atomModel, sysInfoModel);
    }

    private void createSeeksNodeIfNonExist() {
        if (this.getSeeksNodes().size() == 0) {
            this.createSeeksNode(null);
        }
    }

    public void setTitle(String title) {
        Resource atomNode = this.getAtomNode(AtomGraphType.ATOM);
        atomNode.removeAll(DC.title);
        atomNode.addLiteral(DC.title, (Object)title);
    }

    public void setSeeksTitle(String title) {
        this.createSeeksNodeIfNonExist();
        this.setSeeksPropertyStringValue(DC.title, title);
    }

    public void setShapesGraphReference(URI shapesGraphReference) {
        if (this.getGoalNodes().size() == 0) {
            this.createGoalNode(null);
        }
        Collection<Resource> nodes = this.getGoalNodes();
        for (Resource node : nodes) {
            node.removeAll(WON.shapesGraph);
            node.addProperty(WON.shapesGraph, (RDFNode)this.getAtomModel().getResource(shapesGraphReference.toString()));
        }
    }

    public String getSomeTitleFromIsOrAll(String ... preferredLanguages) {
        String title = this.getAtomContentPropertyStringValue(DC.title, preferredLanguages);
        if (title != null) {
            return title;
        }
        title = this.getSomeContentPropertyStringValue(DC.title, preferredLanguages);
        if (title != null) {
            return title;
        }
        return null;
    }

    public Collection<String> getTitles(Resource contentNode) {
        return this.getTitles(contentNode, null);
    }

    Collection<String> getTitles(Resource contentNode, String language) {
        return this.getContentPropertyStringValues(contentNode, DC.title, language);
    }

    public void setSeeksDescription(String description) {
        this.createSeeksNodeIfNonExist();
        this.setSeeksPropertyStringValue(DC.description, description);
    }

    public void setDescription(String description) {
        Resource atomNode = this.getAtomNode(AtomGraphType.ATOM);
        atomNode.removeAll(DC.description);
        atomNode.addLiteral(DC.description, (Object)description);
    }

    public String getSomeDescription(String ... preferredLanguages) {
        return this.getSomeContentPropertyStringValue(DC.description, preferredLanguages);
    }

    public Collection<String> getDescriptions(Resource contentNode) {
        return this.getDescriptions(contentNode, null);
    }

    Collection<String> getDescriptions(Resource contentNode, String language) {
        return this.getContentPropertyStringValues(contentNode, DC.description, language);
    }

    public void addTag(String tag) {
        Resource atomNode = this.getAtomNode(AtomGraphType.ATOM);
        atomNode.addLiteral(WONCON.tag, (Object)tag);
    }

    public void addSeeksTag(String tag) {
        this.createSeeksNodeIfNonExist();
        this.addSeeksPropertyStringValue(WONCON.tag, tag);
    }

    public Collection<String> getTags(Resource contentNode) {
        return this.getContentPropertyStringValues(contentNode, WONCON.tag, null);
    }

    public Collection<String> getAllTags() {
        return this.getAllContentPropertyStringValues(WONCON.tag, null);
    }

    public Collection<URI> getAllFlags() {
        Collection<RDFNode> rdfFlags = this.getContentPropertyObjects(WONMATCH.flag);
        LinkedList<URI> uriFlags = new LinkedList<URI>();
        for (RDFNode rdfFlag : rdfFlags) {
            if (!rdfFlag.isURIResource()) continue;
            uriFlags.add(URI.create(rdfFlag.asResource().getURI()));
        }
        return uriFlags;
    }

    public Collection<URI> getContentTypes() {
        Collection<RDFNode> rdfTypes = this.getContentPropertyObjects(RDF.type);
        LinkedList<URI> uriTypes = new LinkedList<URI>();
        for (RDFNode rdfType : rdfTypes) {
            if (!rdfType.isURIResource()) continue;
            uriTypes.add(URI.create(rdfType.asResource().getURI()));
        }
        return uriTypes;
    }

    public Collection<URI> getSeeksTypes() {
        Collection<RDFNode> rdfTypes = this.getSeeksPropertyObjects(RDF.type);
        LinkedList<URI> uriTypes = new LinkedList<URI>();
        for (RDFNode rdfType : rdfTypes) {
            if (!rdfType.isURIResource()) continue;
            uriTypes.add(URI.create(rdfType.asResource().getURI()));
        }
        return uriTypes;
    }

    public Collection<URI> getSeeksEventObjectAboutUris() {
        return this.getEventObjectAboutUris(this.getSeeksPropertyObjects(SCHEMA.OBJECT));
    }

    public Collection<URI> getContentEventObjectAboutUris() {
        return this.getEventObjectAboutUris(this.getContentPropertyObjects(SCHEMA.OBJECT));
    }

    private Collection<URI> getEventObjectAboutUris(Collection<RDFNode> rdfEventObjects) {
        LinkedList<URI> eventObjectAboutUris = new LinkedList<URI>();
        for (RDFNode rdfEventObject : rdfEventObjects) {
            Collection<RDFNode> rdfEventObjectTypes = this.getContentPropertyObjects(rdfEventObject.asResource(), RDF.type);
            boolean isEventType = false;
            for (RDFNode rdfEventObjectType : rdfEventObjectTypes) {
                if (!SCHEMA.EVENT.toString().equals(rdfEventObjectType.asResource().getURI())) continue;
                isEventType = true;
                break;
            }
            if (!isEventType) continue;
            Collection<RDFNode> rdfEventObjectAbouts = this.getContentPropertyObjects(rdfEventObject.asResource(), SCHEMA.ABOUT);
            for (RDFNode rdfEventObjectAbout : rdfEventObjectAbouts) {
                eventObjectAboutUris.add(URI.create(rdfEventObjectAbout.asResource().getURI()));
            }
        }
        return eventObjectAboutUris;
    }

    public URI getHeldBy() {
        return null;
    }

    public Collection<URI> getHolds() {
        LinkedList<URI> holds = new LinkedList<URI>();
        return holds;
    }

    public Collection<String> getAllTitles() {
        return this.getAllContentPropertyStringValues(DC.title, null);
    }

    public Coordinate getLocationCoordinate() {
        return this.getLocationCoordinate(this.getAtomContentNode());
    }

    public Coordinate getLocationCoordinate(Resource contentNode) {
        return this.getLocationCoordinate(contentNode, SCHEMA.LOCATION);
    }

    public Coordinate getJobLocationCoordinate() {
        return this.getJobLocationCoordinate(this.getAtomContentNode());
    }

    public Coordinate getJobLocationCoordinate(Resource contentNode) {
        return this.getLocationCoordinate(contentNode, SCHEMA.JOBLOCATION);
    }

    private Coordinate getLocationCoordinate(Resource contentNode, Property locationProperty) {
        RDFNode lon;
        Model atomModel = this.getAtomModel();
        Property geoProperty = atomModel.createProperty("http://schema.org/", "geo");
        Property longitudeProperty = atomModel.createProperty("http://schema.org/", "longitude");
        Property latitudeProperty = atomModel.createProperty("http://schema.org/", "latitude");
        RDFNode locationNode = RdfUtils.findOnePropertyFromResource(atomModel, contentNode, locationProperty);
        RDFNode geoNode = locationNode != null && locationNode.isResource() ? RdfUtils.findOnePropertyFromResource(atomModel, locationNode.asResource(), geoProperty) : null;
        RDFNode lat = geoNode != null && geoNode.isResource() ? RdfUtils.findOnePropertyFromResource(atomModel, geoNode.asResource(), latitudeProperty) : null;
        RDFNode rDFNode = lon = geoNode != null && geoNode.isResource() ? RdfUtils.findOnePropertyFromResource(atomModel, geoNode.asResource(), longitudeProperty) : null;
        if (lat == null || lon == null) {
            return null;
        }
        Float latitude = Float.valueOf(lat.asLiteral().getString());
        Float longitude = Float.valueOf(lon.asLiteral().getString());
        return new Coordinate(latitude.floatValue(), longitude.floatValue());
    }
}

