/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;

public class DateTimeUtils {
    private static SimpleDateFormat sdf;
    private static final String DATE_FORMAT_XSD_DATE_TIME_STAMP = "yyyy-MM-DD'T'hh:mm:ss.sssZ";

    public static Literal toLiteral(Date date, Model model) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        XSDDateTime dateTime = new XSDDateTime(cal);
        return model.createTypedLiteral((Object)dateTime, (RDFDatatype)XSDDatatype.XSDdateTime);
    }

    public static Literal getCurrentDateTimeStamp(Model model) {
        return DateTimeUtils.toLiteral(new Date(), model);
    }

    public static Date toDate(Literal literal, Model model) {
        if (XSDDatatype.XSDdateTime.equals(literal.getDatatype())) {
            XSDDateTime dateTime = (XSDDateTime)XSDDatatype.XSDdateTime.parse(literal.getLexicalForm());
            return dateTime.asCalendar().getTime();
        }
        if (literal.getDatatype() == null) {
            Literal asXsdDateTime = model.createTypedLiteral(literal.getLexicalForm(), (RDFDatatype)XSDDatatype.XSDdateTime);
            return DateTimeUtils.toDate(asXsdDateTime, model);
        }
        return null;
    }

    public static Date parse(String date, Model model) {
        return DateTimeUtils.toDate(model.createTypedLiteral(date, (RDFDatatype)XSDDatatype.XSDdateTime), model);
    }

    public static Date toDate(RDFNode node, Model model) {
        if (!node.isLiteral()) {
            return null;
        }
        Literal nodeAsLiteral = node.asLiteral();
        return DateTimeUtils.toDate(nodeAsLiteral, model);
    }
}

