/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util;

import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.rdf.model.impl.StatementImpl;
import won.protocol.util.SparqlFunction;

public class DatasetToDatasetBySparqlGSPOSelectFunction
extends SparqlFunction<Dataset, Dataset> {
    public DatasetToDatasetBySparqlGSPOSelectFunction(String sparqlFile) {
        super(sparqlFile);
    }

    /*
     * Loose catch block
     */
    @Override
    public Dataset apply(Dataset dataset) {
        dataset.begin(ReadWrite.READ);
        Dataset result = DatasetFactory.createGeneral();
        result.begin(ReadWrite.WRITE);
        Query query = QueryFactory.create((String)this.sparql);
        try {
            try (QueryExecution queryExecution = QueryExecutionFactory.create((Query)query, (Dataset)dataset);){
                ResultSet resultSet = queryExecution.execSelect();
                RDFNode currentProposal = null;
                Model currentProposalContent = ModelFactory.createDefaultModel();
                while (resultSet.hasNext()) {
                    QuerySolution solution = resultSet.next();
                    RDFNode proposalNode = solution.get("g");
                    if (currentProposal == null) {
                        currentProposal = proposalNode;
                    } else {
                        if (!currentProposal.equals(proposalNode)) {
                            result.addNamedModel(currentProposal.asResource().getURI(), currentProposalContent);
                            currentProposalContent = ModelFactory.createDefaultModel();
                        }
                        currentProposal = proposalNode;
                    }
                    RDFNode s = solution.get("s");
                    RDFNode p = solution.get("p");
                    RDFNode o = solution.get("o");
                    StatementImpl newStatement = new StatementImpl(s.asResource(), (Property)new PropertyImpl(p.asResource().getURI()), o);
                    currentProposalContent.add((Statement)newStatement);
                }
                if (currentProposal != null) {
                    result.addNamedModel(currentProposal.asResource().getURI(), currentProposalContent);
                }
                Dataset dataset2 = result;
                return dataset2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            dataset.commit();
            result.commit();
        }
    }
}

