/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util;

import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import won.protocol.exception.NoSuchAtomException;
import won.protocol.exception.NoSuchConnectionException;
import won.protocol.exception.NoSuchOwnerApplicationException;
import won.protocol.model.Atom;
import won.protocol.model.Connection;
import won.protocol.model.OwnerApplication;
import won.protocol.model.WonNode;
import won.protocol.repository.AtomRepository;
import won.protocol.repository.ConnectionRepository;
import won.protocol.repository.OwnerApplicationRepository;
import won.protocol.repository.WonNodeRepository;

public class DataAccessUtils {
    public static Atom loadAtom(AtomRepository atomRepository, URI atomURI) throws NoSuchAtomException {
        List<Atom> atoms = atomRepository.findByAtomURI(atomURI);
        if (atoms.size() == 0) {
            throw new NoSuchAtomException(atomURI);
        }
        if (atoms.size() > 1) {
            throw new IllegalStateException(MessageFormat.format("Inconsistent database state detected: multiple atoms found with URI {0}", atomURI));
        }
        return atoms.get(0);
    }

    public static WonNode loadWonNode(WonNodeRepository repository, URI wonNodeURI) {
        List<WonNode> nodes = repository.findByWonNodeURI(wonNodeURI);
        if (nodes.size() == 0) {
            return null;
        }
        if (nodes.size() > 1) {
            throw new IllegalStateException(MessageFormat.format("Inconsistent database state detected: multiple atoms found with URI {0}", wonNodeURI));
        }
        return nodes.get(0);
    }

    public static String loadOwnerApplication(OwnerApplicationRepository ownerApplicationRepository, String ownerApplicationId) throws NoSuchOwnerApplicationException {
        List<OwnerApplication> ownerApplications = ownerApplicationRepository.findByOwnerApplicationId(ownerApplicationId);
        if (ownerApplications.size() == 0) {
            throw new NoSuchOwnerApplicationException();
        }
        if (ownerApplications.size() > 1) {
            throw new IllegalStateException(MessageFormat.format("Inconsistent database state detected: multiple connections found with URI {0}", ownerApplicationId));
        }
        return ownerApplications.get(0).getOwnerApplicationId();
    }

    public static Connection loadConnection(ConnectionRepository connectionRepository, Long id) throws NoSuchConnectionException {
        List connections = connectionRepository.findById(id);
        if (connections.size() == 0) {
            throw new NoSuchConnectionException(id);
        }
        if (connections.size() > 1) {
            throw new IllegalStateException(MessageFormat.format("Inconsistent database state detected: multiple connections found with URI {0}", id));
        }
        return (Connection)connections.get(0);
    }

    public static Connection loadConnection(ConnectionRepository connectionRepository, URI connectionURI) throws NoSuchConnectionException {
        List<Connection> connections = connectionRepository.findByConnectionURI(connectionURI);
        if (connections.size() == 0) {
            throw new NoSuchConnectionException(connectionURI);
        }
        if (connections.size() > 1) {
            throw new IllegalStateException(MessageFormat.format("Inconsistent database state detected: multiple connections found with URI {0}", connectionURI));
        }
        return connections.get(0);
    }
}

