/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util;

import java.net.URI;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathParser;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import won.protocol.exception.IncorrectPropertyCountException;
import won.protocol.model.AtomGraphType;
import won.protocol.model.AtomState;
import won.protocol.util.DefaultPrefixUtils;
import won.protocol.util.RdfUtils;
import won.protocol.vocabulary.WON;
import won.protocol.vocabulary.WONMATCH;

public class AtomModelWrapper {
    protected Dataset atomDataset;
    private String sysInfoGraphName;
    private String atomModelGraphName;

    public AtomModelWrapper(URI atomUri) {
        this(atomUri.toString());
    }

    public AtomModelWrapper(String atomUri) {
        this.atomDataset = DatasetFactory.createGeneral();
        Model atomModel = ModelFactory.createDefaultModel();
        DefaultPrefixUtils.setDefaultPrefixes(atomModel);
        atomModel.createResource(atomUri, WON.Atom);
        Model sysInfoModel = ModelFactory.createDefaultModel();
        DefaultPrefixUtils.setDefaultPrefixes(sysInfoModel);
        sysInfoModel.createResource(atomUri, WON.Atom);
        this.atomModelGraphName = atomUri + "#atom";
        this.atomDataset.addNamedModel(this.atomModelGraphName, atomModel);
    }

    public AtomModelWrapper(Dataset ds) {
        this(ds, false);
    }

    public AtomModelWrapper(Dataset ds, boolean addDefaultGraphs) {
        String atomUri;
        this.atomDataset = ds;
        Resource atomNode = this.getAtomContentNode();
        atomNode = atomNode != null ? atomNode : this.getAtomNode(AtomGraphType.SYSINFO);
        String string = atomUri = atomNode != null ? atomNode.getURI() : null;
        if (addDefaultGraphs && atomUri != null) {
            if (this.getAtomModel() == null) {
                Model atomModel = ModelFactory.createDefaultModel();
                atomModel.createResource(atomUri, WON.Atom);
                DefaultPrefixUtils.setDefaultPrefixes(atomModel);
                this.atomModelGraphName = "dummy#atom";
                this.atomDataset.addNamedModel(this.atomModelGraphName, atomModel);
            }
            if (this.getSysInfoModel() == null) {
                Model sysInfoModel = ModelFactory.createDefaultModel();
                sysInfoModel.createResource(atomUri, WON.Atom);
                DefaultPrefixUtils.setDefaultPrefixes(sysInfoModel);
                this.sysInfoGraphName = "dummy#sysinfo";
                this.atomDataset.addNamedModel(this.sysInfoGraphName, sysInfoModel);
            }
        }
    }

    public AtomModelWrapper(Model atomModel, Model sysInfoModel) {
        this.atomDataset = DatasetFactory.createGeneral();
        String atomUri = null;
        if (sysInfoModel != null) {
            this.sysInfoGraphName = "dummy#sysinfo";
            this.atomDataset.addNamedModel(this.sysInfoGraphName, sysInfoModel);
            atomUri = this.getAtomNode(AtomGraphType.SYSINFO).getURI();
        }
        if (atomModel != null) {
            this.atomModelGraphName = "dummy#atom";
            this.atomDataset.addNamedModel(this.atomModelGraphName, atomModel);
            atomUri = this.getAtomContentNode().getURI();
        }
        if (atomUri != null) {
            if (sysInfoModel == null) {
                sysInfoModel = ModelFactory.createDefaultModel();
                DefaultPrefixUtils.setDefaultPrefixes(sysInfoModel);
                sysInfoModel.createResource(atomUri, WON.Atom);
                this.sysInfoGraphName = "dummy#sysinfo";
                this.atomDataset.addNamedModel(this.sysInfoGraphName, sysInfoModel);
            }
            if (atomModel == null) {
                atomModel = ModelFactory.createDefaultModel();
                DefaultPrefixUtils.setDefaultPrefixes(atomModel);
                atomModel.createResource(atomUri, WON.Atom);
                this.atomModelGraphName = "dummy#atom";
                this.atomDataset.addNamedModel(this.atomModelGraphName, atomModel);
            }
        }
    }

    public static boolean isAAtom(Dataset ds) {
        if (ds == null || ds.isEmpty()) {
            return false;
        }
        AtomModelWrapper wrapper = new AtomModelWrapper(ds, false);
        return wrapper.getAtomContentNode() != null && wrapper.getAtomNode(AtomGraphType.SYSINFO) != null;
    }

    public Model getAtomModel() {
        Iterator modelNameIter = this.atomDataset.listNames();
        if (this.atomModelGraphName != null && this.atomDataset.getNamedModel(this.atomModelGraphName) != null) {
            return this.atomDataset.getNamedModel(this.atomModelGraphName);
        }
        Model defaultModel = this.atomDataset.getDefaultModel();
        if (defaultModel.listSubjectsWithProperty(RDF.type, (RDFNode)WON.Atom).hasNext() && !defaultModel.listSubjectsWithProperty(WON.atomState).hasNext()) {
            return defaultModel;
        }
        while (modelNameIter.hasNext()) {
            String tempModelName = (String)modelNameIter.next();
            Model model = this.atomDataset.getNamedModel(tempModelName);
            if (tempModelName.equals("dummy#sysinfo") || !model.listSubjectsWithProperty(RDF.type, (RDFNode)WON.Atom).hasNext() || model.listSubjectsWithProperty(WON.atomState).hasNext()) continue;
            this.atomModelGraphName = tempModelName;
            return model;
        }
        return null;
    }

    public Model getSysInfoModel() {
        Iterator modelNameIter = this.atomDataset.listNames();
        if (this.sysInfoGraphName != null && this.atomDataset.getNamedModel(this.sysInfoGraphName) != null) {
            return this.atomDataset.getNamedModel(this.sysInfoGraphName);
        }
        Model defaultModel = this.atomDataset.getDefaultModel();
        if (defaultModel.listSubjectsWithProperty(RDF.type, (RDFNode)WON.Atom).hasNext() && defaultModel.listSubjectsWithProperty(WON.atomState).hasNext()) {
            return defaultModel;
        }
        while (modelNameIter.hasNext()) {
            Model model;
            String tempModelName = (String)modelNameIter.next();
            if (tempModelName.equals("dummy#atom") || !(model = this.atomDataset.getNamedModel(tempModelName)).listSubjectsWithProperty(RDF.type, (RDFNode)WON.Atom).hasNext() || !model.listSubjectsWithProperty(WON.atomState).hasNext()) continue;
            this.sysInfoGraphName = tempModelName;
            return model;
        }
        return null;
    }

    public boolean hasDerivedModel() {
        String name;
        Optional<RDFNode> derivedGraphName = RdfUtils.findFirstPropertyOfO(this.getAtomNode(AtomGraphType.SYSINFO), WON.derivedGraph);
        return derivedGraphName.isPresent() && derivedGraphName.get().isURIResource() && this.atomDataset.containsNamedModel(name = derivedGraphName.get().asResource().getURI());
    }

    public Optional<Model> getDerivedModel() {
        String name;
        Optional<RDFNode> derivedGraphName = RdfUtils.findFirstPropertyOfO(this.getAtomNode(AtomGraphType.SYSINFO), WON.derivedGraph);
        if (derivedGraphName.isPresent() && derivedGraphName.get().isURIResource() && this.atomDataset.containsNamedModel(name = derivedGraphName.get().asResource().getURI())) {
            return Optional.of(RdfUtils.cloneModel(this.atomDataset.getNamedModel(name)));
        }
        return Optional.empty();
    }

    public Model copyAtomModel(AtomGraphType graph) {
        if (graph.equals((Object)AtomGraphType.ATOM)) {
            return RdfUtils.cloneModel(this.getAtomModel());
        }
        return RdfUtils.cloneModel(this.getSysInfoModel());
    }

    public Dataset copyDataset() {
        return RdfUtils.cloneDataset(this.atomDataset);
    }

    protected Resource getAtomNode(AtomGraphType graph) {
        ResIterator iter;
        if (graph.equals((Object)AtomGraphType.ATOM) && this.getAtomModel() != null) {
            ResIterator iter2 = this.getAtomModel().listSubjectsWithProperty(RDF.type, (RDFNode)WON.Atom);
            if (iter2.hasNext()) {
                return (Resource)iter2.next();
            }
        } else if (graph.equals((Object)AtomGraphType.SYSINFO) && this.getSysInfoModel() != null && (iter = this.getSysInfoModel().listSubjectsWithProperty(RDF.type, (RDFNode)WON.Atom)).hasNext()) {
            return (Resource)iter.next();
        }
        return null;
    }

    public Resource getAtomContentNode() {
        return this.getAtomNode(AtomGraphType.ATOM);
    }

    public String getAtomUri() {
        return this.getAtomContentNode().getURI();
    }

    public void addFlag(Resource flag) {
        this.getAtomContentNode().addProperty(WONMATCH.flag, (RDFNode)flag);
    }

    public boolean flag(Resource flag) {
        Resource atomRes = this.getAtomContentNode();
        return atomRes != null && atomRes.hasProperty(WONMATCH.flag, (RDFNode)flag);
    }

    public Calendar getDoNotMatchBefore() {
        Statement prop = this.getAtomContentNode().getProperty(WONMATCH.doNotMatchBefore);
        if (prop == null) {
            return null;
        }
        RDFNode literal = prop.getObject();
        if (!literal.isLiteral()) {
            return null;
        }
        Object data = literal.asLiteral().getValue();
        if (data instanceof XSDDateTime) {
            return ((XSDDateTime)data).asCalendar();
        }
        return null;
    }

    public Calendar getDoNotMatchAfter() {
        Statement prop = this.getAtomContentNode().getProperty(WONMATCH.doNotMatchAfter);
        if (prop == null) {
            return null;
        }
        RDFNode literal = prop.getObject();
        if (!literal.isLiteral()) {
            return null;
        }
        Object data = literal.asLiteral().getValue();
        if (data instanceof XSDDateTime) {
            return ((XSDDateTime)data).asCalendar();
        }
        return null;
    }

    public void addMatchingContext(String context) {
        this.getAtomContentNode().addProperty(WONMATCH.matchingContext, context);
    }

    public boolean matchingContext(String context) {
        return this.getAtomContentNode().hasProperty(WONMATCH.matchingContext, context);
    }

    public void addQuery(String query) {
        this.getAtomContentNode().addProperty(WONMATCH.sparqlQuery, query);
    }

    public Optional<String> getQuery() {
        Statement stmt = this.getAtomContentNode().getProperty(WONMATCH.sparqlQuery);
        if (stmt == null) {
            return Optional.empty();
        }
        return Optional.of(stmt.getString());
    }

    public boolean sparqlQuery() {
        return this.getAtomContentNode().hasProperty(WONMATCH.sparqlQuery);
    }

    public Collection<String> getMatchingContexts() {
        LinkedList<String> matchingContexts = new LinkedList<String>();
        NodeIterator iter = this.getAtomModel().listObjectsOfProperty(this.getAtomContentNode(), WONMATCH.matchingContext);
        while (iter.hasNext()) {
            matchingContexts.add(iter.next().asLiteral().getString());
        }
        return matchingContexts;
    }

    public void addSocket(String socketUri, String socketTypeUri) {
        if (socketUri.startsWith("#")) {
            socketUri = this.getAtomUri() + socketUri;
        } else if (!socketUri.startsWith(this.getAtomUri())) {
            throw new IllegalArgumentException("The socketURI must start with '[atomURI]#' or '#' but was: " + socketUri);
        }
        Resource socket = this.getAtomModel().getResource(socketUri);
        Resource socketType = this.getAtomModel().createResource(socketTypeUri);
        this.getAtomContentNode().addProperty(WON.socket, (RDFNode)socket);
        socket.addProperty(WON.socketDefinition, (RDFNode)socketType);
    }

    public void setDefaultSocket(String socketUri) {
        if (socketUri.startsWith("#")) {
            socketUri = this.getAtomUri() + socketUri;
        } else if (!socketUri.startsWith(this.getAtomUri())) {
            throw new IllegalArgumentException("The socketURI must start with '[atomURI]#' or '#' but was: " + socketUri);
        }
        Resource socket = this.getAtomModel().getResource(socketUri);
        this.getAtomContentNode().addProperty(WON.defaultSocket, (RDFNode)socket);
    }

    public Optional<String> getDefaultSocket() {
        Statement stmt = this.getAtomContentNode().getProperty(WON.defaultSocket);
        if (stmt == null) {
            return Optional.empty();
        }
        return Optional.of(stmt.getObject().toString());
    }

    public Collection<String> getSocketUris() {
        LinkedList<String> socketUris = new LinkedList<String>();
        NodeIterator iter = this.getAtomModel().listObjectsOfProperty(this.getAtomContentNode(), WON.socket);
        while (iter.hasNext()) {
            socketUris.add(iter.next().asResource().getURI());
        }
        return socketUris;
    }

    public Optional<String> getSocketType(String socketUri) {
        Resource socket = this.getAtomModel().createResource(socketUri);
        if (!this.getAtomContentNode().hasProperty(WON.socket, (RDFNode)socket)) {
            return Optional.empty();
        }
        Statement stmt = socket.getProperty(WON.socketDefinition);
        if (stmt == null) {
            return Optional.empty();
        }
        return Optional.of(stmt.getObject().toString());
    }

    public Collection<Resource> getGoals() {
        LinkedList<Resource> goalUris = new LinkedList<Resource>();
        NodeIterator iter = this.getAtomModel().listObjectsOfProperty(this.getAtomContentNode(), WON.goal);
        while (iter.hasNext()) {
            goalUris.add(iter.next().asResource());
        }
        return goalUris;
    }

    public Resource getGoal(String uri) {
        return this.getAtomModel().getResource(uri);
    }

    public Model getShapesGraph(Resource goalNode) {
        NodeIterator nodeIter;
        if (goalNode != null && (nodeIter = this.getAtomModel().listObjectsOfProperty(goalNode, WON.shapesGraph)).hasNext()) {
            String shapesGraphUri = nodeIter.next().asResource().getURI();
            return this.atomDataset.getNamedModel(shapesGraphUri);
        }
        return null;
    }

    public String getShapesGraphName(Resource goalNode) {
        NodeIterator nodeIter;
        if (goalNode != null && (nodeIter = this.getAtomModel().listObjectsOfProperty(goalNode, WON.shapesGraph)).hasNext()) {
            return nodeIter.next().asResource().getURI();
        }
        return null;
    }

    public Model getDataGraph(Resource goalNode) {
        NodeIterator nodeIter;
        if (goalNode != null && (nodeIter = this.getAtomModel().listObjectsOfProperty(goalNode, WON.dataGraph)).hasNext()) {
            String dataGraphUri = nodeIter.next().asResource().getURI();
            return this.atomDataset.getNamedModel(dataGraphUri);
        }
        return null;
    }

    public String getDataGraphName(Resource goalNode) {
        NodeIterator nodeIter;
        if (goalNode != null && (nodeIter = this.getAtomModel().listObjectsOfProperty(goalNode, WON.dataGraph)).hasNext()) {
            return nodeIter.next().asResource().getURI();
        }
        return null;
    }

    public void setAtomState(AtomState state) {
        Resource stateRes = AtomState.ACTIVE.equals((Object)state) ? WON.ATOM_STATE_ACTIVE : WON.ATOM_STATE_INACTIVE;
        Resource atom = this.getAtomNode(AtomGraphType.SYSINFO);
        atom.removeAll(WON.atomState);
        atom.addProperty(WON.atomState, (RDFNode)stateRes);
    }

    public AtomState getAtomState() {
        Model sysInfoModel = this.getSysInfoModel();
        sysInfoModel.enterCriticalSection(true);
        RDFNode state = RdfUtils.findOnePropertyFromResource(sysInfoModel, this.getAtomNode(AtomGraphType.SYSINFO), WON.atomState);
        sysInfoModel.leaveCriticalSection();
        if (state.equals(WON.ATOM_STATE_ACTIVE)) {
            return AtomState.ACTIVE;
        }
        if (state.equals(WON.ATOM_STATE_INACTIVE)) {
            return AtomState.INACTIVE;
        }
        if (state.equals(WON.ATOM_STATE_DELETED)) {
            return AtomState.DELETED;
        }
        throw new IllegalStateException("Unrecognized atom state: " + state);
    }

    public ZonedDateTime getCreationDate() {
        String dateString = RdfUtils.findOnePropertyFromResource(this.getSysInfoModel(), this.getAtomNode(AtomGraphType.SYSINFO), DCTerms.created).asLiteral().getString();
        return ZonedDateTime.parse(dateString, DateTimeFormatter.ISO_DATE_TIME);
    }

    public ZonedDateTime getModifiedDate() {
        String dateString = RdfUtils.findOnePropertyFromResource(this.getSysInfoModel(), this.getAtomNode(AtomGraphType.SYSINFO), DCTerms.modified).asLiteral().getString();
        return ZonedDateTime.parse(dateString, DateTimeFormatter.ISO_DATE_TIME);
    }

    public void setConnectionContainerUri(String containerUri) {
        Resource container = this.getSysInfoModel().createResource(containerUri);
        Resource atom = this.getAtomNode(AtomGraphType.SYSINFO);
        atom.removeAll(WON.connections);
        atom.addProperty(WON.connections, (RDFNode)container);
    }

    public String getConnectionContainerUri() {
        return RdfUtils.findOnePropertyFromResource(this.getSysInfoModel(), this.getAtomNode(AtomGraphType.SYSINFO), WON.connections).asResource().getURI();
    }

    public void setWonNodeUri(String nodeUri) {
        Resource node = this.getSysInfoModel().createResource(nodeUri);
        Resource atom = this.getAtomNode(AtomGraphType.SYSINFO);
        atom.removeAll(WON.wonNode);
        atom.addProperty(WON.wonNode, (RDFNode)node);
    }

    public String getWonNodeUri() {
        return RdfUtils.findOnePropertyFromResource(this.getSysInfoModel(), this.getAtomNode(AtomGraphType.SYSINFO), WON.wonNode).asResource().getURI();
    }

    public Resource createGoalNode(String uri) {
        Resource contentNode = uri != null ? this.getAtomModel().createResource(uri) : this.getAtomModel().createResource();
        this.addGoalPropertyToAtomNode((RDFNode)contentNode);
        return contentNode;
    }

    public Resource createSeeksNode(String uri) {
        Resource contentNode = uri != null ? this.getAtomModel().createResource(uri) : this.getAtomModel().createResource();
        this.addSeeksPropertyToAtomNode((RDFNode)contentNode);
        return contentNode;
    }

    private void addGoalPropertyToAtomNode(RDFNode contentNode) {
        Resource atomNode = this.getAtomContentNode();
        atomNode.addProperty(WON.goal, contentNode);
    }

    private void addSeeksPropertyToAtomNode(RDFNode contentNode) {
        Resource atomNode = this.getAtomContentNode();
        atomNode.addProperty(WONMATCH.seeks, contentNode);
    }

    public Collection<Resource> getGoalNodes() {
        LinkedList<Resource> contentNodes = new LinkedList<Resource>();
        String queryClause = "{ ?atomNode a won:Atom. ?atomNode won:goal ?contentNode. }";
        String queryString = "prefix won: <https://w3id.org/won/core#> \nprefix match: <https://w3id.org/won/matching#> \nprefix con: <https://w3id.org/won/content#> \nSELECT DISTINCT ?contentNode WHERE { \n" + queryClause + "\n }";
        Query query = QueryFactory.create((String)queryString);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)this.getAtomModel());){
            ResultSet rs = qexec.execSelect();
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                if (!qs.contains("contentNode")) continue;
                contentNodes.add(qs.get("contentNode").asResource());
            }
            LinkedList<Resource> linkedList = contentNodes;
            return linkedList;
        }
    }

    public Collection<Resource> getSeeksNodes() {
        LinkedList<Resource> contentNodes = new LinkedList<Resource>();
        String queryClause = "{ ?atomNode a won:Atom. ?atomNode match:seeks ?contentNode. FILTER NOT EXISTS { ?atomNode match:seeks/match:seeks ?contentNode. } }";
        String queryString = "prefix won: <https://w3id.org/won/core#> \nprefix match: <https://w3id.org/won/matching#> \nprefix con: <https://w3id.org/won/content#> \nSELECT DISTINCT ?contentNode WHERE { \n" + queryClause + "\n }";
        Query query = QueryFactory.create((String)queryString);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)this.getAtomModel());){
            ResultSet rs = qexec.execSelect();
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                if (!qs.contains("contentNode")) continue;
                contentNodes.add(qs.get("contentNode").asResource());
            }
            LinkedList<Resource> linkedList = contentNodes;
            return linkedList;
        }
    }

    public Collection<Resource> getAllContentNodes() {
        LinkedList<Resource> contentNodes = new LinkedList<Resource>();
        String queryClause = null;
        String seeksClause = "{ ?atomNode a won:Atom. ?atomNode match:seeks ?contentNode. FILTER NOT EXISTS { ?atomNode match:seeks/match:seeks ?contentNode. } }";
        String seeksSeeksClause = "{ ?atomNode a won:Atom. ?atomNode match:seeks/match:seeks ?contentNode. }";
        queryClause = seeksClause + "UNION \n" + seeksSeeksClause;
        String queryString = "prefix won: <https://w3id.org/won/core#> \nprefix match: <https://w3id.org/won/matching#> \nprefix con: <https://w3id.org/won/content#> \nSELECT DISTINCT ?contentNode WHERE { \n" + queryClause + "\n }";
        Query query = QueryFactory.create((String)queryString);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)this.getAtomModel());){
            ResultSet rs = qexec.execSelect();
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                if (!qs.contains("contentNode")) continue;
                contentNodes.add(qs.get("contentNode").asResource());
            }
            contentNodes.add(this.getAtomContentNode());
            LinkedList<Resource> linkedList = contentNodes;
            return linkedList;
        }
    }

    public Collection<Resource> getSeeksSeeksNodes() {
        String seeksSeeksClause;
        LinkedList<Resource> contentNodes = new LinkedList<Resource>();
        String queryClause = null;
        queryClause = seeksSeeksClause = "{ ?atomNode a won:Atom. ?atomNode match:seeks/match:seeks ?contentNode. }";
        String queryString = "prefix won: <https://w3id.org/won/core#> \nprefix match: <https://w3id.org/won/matching#> \nprefix con: <https://w3id.org/won/content#> \nSELECT DISTINCT ?contentNode WHERE { \n" + queryClause + "\n }";
        Query query = QueryFactory.create((String)queryString);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)this.getAtomModel());){
            ResultSet rs = qexec.execSelect();
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                if (!qs.contains("contentNode")) continue;
                contentNodes.add(qs.get("contentNode").asResource());
            }
            LinkedList<Resource> linkedList = contentNodes;
            return linkedList;
        }
    }

    public void setContentPropertyStringValue(Property p, String value) {
        Resource node = this.getAtomContentNode();
        node.removeAll(p);
        node.addLiteral(p, (Object)value);
    }

    public void setSeeksPropertyStringValue(Property p, String value) {
        Collection<Resource> nodes = this.getSeeksNodes();
        for (Resource node : nodes) {
            node.removeAll(p);
            node.addLiteral(p, (Object)value);
        }
    }

    public void addPropertyStringValue(Property p, String value) {
        Resource node = this.getAtomContentNode();
        node.addLiteral(p, (Object)value);
    }

    public void addSeeksPropertyStringValue(Property p, String value) {
        Collection<Resource> nodes = this.getSeeksNodes();
        for (Resource node : nodes) {
            node.addLiteral(p, (Object)value);
        }
    }

    public String getContentPropertyStringValue(Resource contentNode, Property p) {
        RDFNode node = RdfUtils.findOnePropertyFromResource(this.getAtomModel(), contentNode, p);
        if (node != null && node.isLiteral()) {
            return node.asLiteral().getString();
        }
        return null;
    }

    public String getContentPropertyStringValue(Property p) {
        return this.getContentPropertyObject(p).asLiteral().getString();
    }

    public String getContentPropertyStringValue(String propertyPath) {
        Node node = this.getContentPropertyObject(propertyPath);
        return node != null ? node.getLiteralLexicalForm() : null;
    }

    public Collection<String> getContentPropertyStringValues(Resource contentNode, Property p, String language) {
        LinkedList<String> values = new LinkedList<String>();
        NodeIterator nodeIterator = this.getAtomModel().listObjectsOfProperty(contentNode, p);
        while (nodeIterator.hasNext()) {
            Literal literalValue = nodeIterator.next().asLiteral();
            if (language != null && !language.equals(literalValue.getLanguage())) continue;
            values.add(literalValue.getString());
        }
        return values;
    }

    public Collection<RDFNode> getContentPropertyObjects(Resource contentNode, Property p) {
        LinkedList<RDFNode> values = new LinkedList<RDFNode>();
        NodeIterator nodeIterator = this.getAtomModel().listObjectsOfProperty(contentNode, p);
        while (nodeIterator.hasNext()) {
            values.add(nodeIterator.next());
        }
        return values;
    }

    public Collection<String> getAllContentPropertyStringValues(Property p, String language) {
        LinkedList<String> values = new LinkedList<String>();
        Collection<Resource> nodes = this.getSeeksNodes();
        for (Resource node : nodes) {
            Collection<String> valuesOfContentNode = this.getContentPropertyStringValues(node, p, language);
            values.addAll(valuesOfContentNode);
        }
        Resource node = this.getAtomContentNode();
        Collection<String> valuesOfContentNode = this.getContentPropertyStringValues(node, p, language);
        values.addAll(valuesOfContentNode);
        return values;
    }

    public Collection<String> getContentPropertyStringValues(Property p, String language) {
        LinkedList<String> values = new LinkedList<String>();
        Resource node = this.getAtomContentNode();
        Collection<String> valuesOfContentNode = this.getContentPropertyStringValues(node, p, language);
        values.addAll(valuesOfContentNode);
        return values;
    }

    public Collection<String> getSeeksPropertyStringValues(Property p) {
        return this.getSeeksPropertyStringValues(p, null);
    }

    public Collection<String> getSeeksPropertyStringValues(Property p, String language) {
        LinkedList<String> values = new LinkedList<String>();
        Collection<Resource> nodes = this.getSeeksNodes();
        for (Resource node : nodes) {
            Collection<String> valuesOfContentNode = this.getContentPropertyStringValues(node, p, language);
            values.addAll(valuesOfContentNode);
        }
        return values;
    }

    public Collection<RDFNode> getSeeksPropertyObjects(Property p) {
        LinkedList<RDFNode> values = new LinkedList<RDFNode>();
        Collection<Resource> nodes = this.getSeeksNodes();
        for (Resource node : nodes) {
            Collection<RDFNode> valuesOfContentNode = this.getContentPropertyObjects(node, p);
            values.addAll(valuesOfContentNode);
        }
        return values;
    }

    public String getSomeContentPropertyStringValue(Resource contentNode, Property p) {
        return this.getSomeContentPropertyStringValue(contentNode, p, null);
    }

    public String getSomeContentPropertyStringValue(Resource contentNode, Property p, String ... preferredLanguages) {
        Collection<String> values = null;
        if (preferredLanguages != null) {
            for (int i = 0; i < preferredLanguages.length; ++i) {
                values = this.getContentPropertyStringValues(contentNode, p, preferredLanguages[i]);
                if (values == null || values.size() <= 0) continue;
                return values.iterator().next();
            }
        }
        if ((values = this.getContentPropertyStringValues(contentNode, p, null)) != null && values.size() > 0) {
            return values.iterator().next();
        }
        return null;
    }

    public String getSomeContentPropertyStringValue(Property p, String ... preferredLanguages) {
        String valueOfAtomContentNode;
        Resource contentNode = this.getAtomContentNode();
        if (preferredLanguages != null) {
            for (int i = 0; i < preferredLanguages.length; ++i) {
                String valueOfContentNode = this.getSomeContentPropertyStringValue(contentNode, p, preferredLanguages[i]);
                if (valueOfContentNode == null) continue;
                return valueOfContentNode;
            }
        }
        if ((valueOfAtomContentNode = this.getSomeContentPropertyStringValue(contentNode, p)) != null) {
            return valueOfAtomContentNode;
        }
        Collection<Resource> nodes = this.getSeeksNodes();
        if (preferredLanguages != null) {
            for (int i = 0; i < preferredLanguages.length; ++i) {
                for (Resource node : nodes) {
                    String valueOfContentNode = this.getSomeContentPropertyStringValue(node, p, preferredLanguages[i]);
                    if (valueOfContentNode == null) continue;
                    return valueOfContentNode;
                }
            }
        }
        for (Resource node : nodes) {
            String valueOfContentNode = this.getSomeContentPropertyStringValue(node, p);
            if (valueOfContentNode == null) continue;
            return valueOfContentNode;
        }
        return null;
    }

    public String getAtomContentPropertyStringValue(Property p, String ... preferredLanguages) {
        String valueOfContentNode;
        Resource node = this.getAtomContentNode();
        if (preferredLanguages != null) {
            for (int i = 0; i < preferredLanguages.length; ++i) {
                String valueOfContentNode2 = this.getSomeContentPropertyStringValue(node, p, preferredLanguages[i]);
                if (valueOfContentNode2 == null) continue;
                return valueOfContentNode2;
            }
        }
        if ((valueOfContentNode = this.getSomeContentPropertyStringValue(node, p)) != null) {
            return valueOfContentNode;
        }
        return null;
    }

    private RDFNode getContentPropertyObject(Property p) {
        Resource node = this.getAtomContentNode();
        RDFNode object = null;
        NodeIterator nodeIterator = this.getAtomModel().listObjectsOfProperty(node, p);
        if (nodeIterator.hasNext()) {
            if (object != null) {
                throw new IncorrectPropertyCountException("expected exactly one occurrence of property " + p.getURI(), 1, 2);
            }
            object = nodeIterator.next();
        }
        if (object == null) {
            throw new IncorrectPropertyCountException("expected exactly one occurrence of property " + p.getURI(), 1, 0);
        }
        return object;
    }

    public Collection<RDFNode> getContentPropertyObjects(Property p) {
        LinkedList<RDFNode> values = new LinkedList<RDFNode>();
        Resource node = this.getAtomContentNode();
        Collection<RDFNode> valuesOfContentNode = this.getContentPropertyObjects(node, p);
        values.addAll(valuesOfContentNode);
        return values;
    }

    private Node getContentPropertyObject(String propertyPath) {
        Path path = PathParser.parse((String)propertyPath, (PrefixMapping)DefaultPrefixUtils.getDefaultPrefixes());
        Resource resource = this.getAtomContentNode();
        Node node = resource.asNode();
        return RdfUtils.getNodeForPropertyPath(this.getAtomModel(), node, path);
    }

    private boolean isSplittableNode(RDFNode node) {
        return node.isResource() && (node.isAnon() || node.asResource().getURI().startsWith(this.getAtomUri()) && !node.asResource().getURI().equals(this.getAtomUri()));
    }

    private Resource copyNode(Resource node) {
        if (node.isAnon()) {
            return node.getModel().createResource();
        }
        int i = 0;
        String uri = node.getURI() + RandomStringUtils.randomAlphanumeric((int)4);
        String newUri = uri + "_" + i;
        while (node.getModel().containsResource((RDFNode)new ResourceImpl(newUri))) {
            newUri = uri + "_" + ++i;
        }
        return node.getModel().getResource(newUri);
    }

    public Model normalizeAtomModel() {
        Model copy = RdfUtils.cloneModel(this.getAtomModel());
        HashSet blacklist = new HashSet();
        Resource atomNode = copy.getResource(this.getAtomUri());
        this.recursiveCopyWhereMultipleInEdges((RDFNode)atomNode);
        return copy;
    }

    private void recursiveCopyWhereMultipleInEdges(RDFNode node) {
        ModelModification modelModification = new ModelModification();
        this.recursiveCopyWhereMultipleInEdges(node, modelModification, new HashSet<RDFNode>());
        modelModification.modify(node.getModel());
    }

    private void recursiveCopyWhereMultipleInEdges(RDFNode node, ModelModification modelModification, Collection<RDFNode> visited) {
        if (!node.isResource()) {
            return;
        }
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        List outgoingEdges = node.getModel().listStatements(node.asResource(), null, (RDFNode)null).toList();
        for (Statement stmt2 : outgoingEdges) {
            this.recursiveCopyWhereMultipleInEdges(stmt2.getObject(), modelModification, visited);
        }
        if (outgoingEdges.size() > 0) {
            Set<Resource> reachableFromNode = this.findReachableResources(node);
            List incomingEdges = node.getModel().listStatements(null, null, node).toList();
            if ((incomingEdges = incomingEdges.stream().filter(stmt -> !reachableFromNode.contains(stmt.getSubject())).collect(Collectors.toList())).size() > 1 && this.isSplittableNode(node)) {
                for (Statement stmt3 : incomingEdges) {
                    RDFNode copy = this.recursiveCopy(node, modelModification);
                    StatementImpl newEdge = new StatementImpl(stmt3.getSubject(), stmt3.getPredicate(), copy);
                    modelModification.add((Statement)newEdge);
                    modelModification.remove(stmt3);
                }
                modelModification.remove(outgoingEdges);
            }
        }
    }

    private boolean isReachableFrom(RDFNode src, RDFNode target) {
        return this.isReachableFrom(src, target, new HashSet<RDFNode>());
    }

    private boolean isReachableFrom(RDFNode src, RDFNode target, Collection<RDFNode> visited) {
        if (src.equals(target)) {
            return true;
        }
        if (!src.isResource()) {
            return false;
        }
        if (visited.contains(src)) {
            return false;
        }
        visited.add(src);
        StmtIterator it = src.getModel().listStatements(src.asResource(), null, (RDFNode)null);
        while (it.hasNext()) {
            Statement stmt = it.nextStatement();
            if (!this.isReachableFrom(src, stmt.getObject(), visited)) continue;
            return true;
        }
        return false;
    }

    private Set<Resource> findReachableResources(RDFNode src) {
        HashSet<Resource> reachable = new HashSet<Resource>();
        this.findReachableResources(src, reachable);
        return reachable;
    }

    private void findReachableResources(RDFNode src, Set<Resource> found) {
        if (!src.isResource()) {
            return;
        }
        if (found.contains(src)) {
            return;
        }
        found.add(src.asResource());
        StmtIterator it = src.getModel().listStatements(src.asResource(), null, (RDFNode)null);
        while (it.hasNext()) {
            Statement stmt = it.nextStatement();
            this.findReachableResources(src, found);
        }
    }

    private RDFNode recursiveCopy(RDFNode node, ModelModification modelModification) {
        return this.recursiveCopy(node, modelModification, null, null, new HashSet<RDFNode>());
    }

    private RDFNode recursiveCopy(RDFNode node, ModelModification modelModification, RDFNode toReplace, RDFNode replacement, Collection<RDFNode> visited) {
        if (node.equals(toReplace)) {
            return replacement;
        }
        if (!node.isResource()) {
            return node;
        }
        if (visited.contains(node)) {
            return this.copyNode(node.asResource());
        }
        visited.add(node);
        if (!this.isSplittableNode(node)) {
            return node;
        }
        Resource nodeInCopy = this.copyNode(node.asResource());
        visited.add((RDFNode)nodeInCopy);
        if (toReplace == null && replacement == null) {
            toReplace = node;
            replacement = nodeInCopy;
        }
        List outgoingEdges = node.getModel().listStatements(node.asResource(), null, (RDFNode)null).toList();
        for (Statement stmt : outgoingEdges) {
            RDFNode newObject = this.recursiveCopy(stmt.getObject(), modelModification, toReplace, replacement, visited);
            modelModification.add((Statement)new StatementImpl(nodeInCopy.asResource(), stmt.getPredicate(), newObject));
            modelModification.remove(stmt);
        }
        return nodeInCopy;
    }

    private class ModelModification {
        private List<Statement> statementsToAdd = new LinkedList<Statement>();
        private List<Statement> statementsToRemove = new LinkedList<Statement>();

        public Collection<Statement> getStatementsToAdd() {
            return Collections.unmodifiableCollection(this.statementsToAdd);
        }

        public Collection<Statement> getStatementsToRemove() {
            return Collections.unmodifiableCollection(this.statementsToRemove);
        }

        public void add(Statement stmt) {
            this.statementsToAdd.add(stmt);
        }

        public void add(Collection<Statement> statements) {
            this.statementsToAdd.addAll(statements);
        }

        public void remove(Statement stmt) {
            this.statementsToRemove.add(stmt);
        }

        public void remove(Collection<Statement> statements) {
            this.statementsToRemove.addAll(statements);
        }

        public void mergeModificationsFrom(ModelModification other) {
            this.statementsToRemove.addAll(other.statementsToRemove);
            this.statementsToAdd.addAll(other.statementsToAdd);
        }

        public Model copyAndModify(Model model) {
            Model ret = RdfUtils.cloneModel(model);
            this.modify(ret);
            return ret;
        }

        public void modify(Model model) {
            model.add(this.statementsToAdd);
            model.remove(this.statementsToRemove);
        }
    }
}

