/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.service.impl;

import java.net.URI;
import org.apache.jena.query.Dataset;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import won.cryptography.service.RandomNumberService;
import won.protocol.service.WonNodeInfo;
import won.protocol.service.WonNodeInformationService;
import won.protocol.util.WonRdfUtils;
import won.protocol.util.linkeddata.LinkedDataSource;
import won.protocol.util.linkeddata.WonLinkedDataUtils;

public class WonNodeInformationServiceImpl
implements WonNodeInformationService {
    private static final int RANDOM_ID_STRING_LENGTH = 20;
    @Autowired
    private RandomNumberService randomNumberService;
    @Autowired
    private LinkedDataSource linkedDataSource;
    @Value(value="${uri.node.default}")
    private URI defaultWonNodeUri;

    @Override
    public WonNodeInfo getWonNodeInformation(URI wonNodeURI) {
        assert (wonNodeURI != null);
        Dataset nodeDataset = this.linkedDataSource.getDataForResource(wonNodeURI);
        WonNodeInfo info = WonRdfUtils.WonNodeUtils.getWonNodeInfo(wonNodeURI, nodeDataset);
        if (info == null) {
            throw new IllegalStateException("Could not obtain WonNodeInformation for URI " + wonNodeURI);
        }
        return info;
    }

    @Override
    public URI generateAtomURI() {
        return this.generateAtomURI(this.getDefaultWonNodeURI());
    }

    @Override
    public URI generateEventURI(URI wonNodeURI) {
        WonNodeInfo wonNodeInformation = this.getWonNodeInformation(wonNodeURI);
        return URI.create(wonNodeInformation.getEventURIPrefix() + "/" + this.generateRandomID());
    }

    @Override
    public boolean isValidEventURI(URI eventURI) {
        return this.isValidEventURI(eventURI, this.getDefaultWonNodeURI());
    }

    @Override
    public boolean isValidEventURI(URI eventURI, URI wonNodeURI) {
        WonNodeInfo wonNodeInformation = this.getWonNodeInformation(wonNodeURI);
        return this.isValidURI(eventURI, wonNodeInformation.getEventURIPrefix());
    }

    @Override
    public URI generateConnectionURI() {
        return this.generateConnectionURI(this.getDefaultWonNodeURI());
    }

    @Override
    public URI generateConnectionURI(URI wonNodeURI) {
        WonNodeInfo wonNodeInformation = this.getWonNodeInformation(wonNodeURI);
        return URI.create(wonNodeInformation.getConnectionURIPrefix() + "/" + this.generateRandomID());
    }

    @Override
    public boolean isValidConnectionURI(URI connectionURI) {
        return this.isValidConnectionURI(connectionURI, this.getDefaultWonNodeURI());
    }

    @Override
    public boolean isValidConnectionURI(URI connectionURI, URI wonNodeURI) {
        WonNodeInfo wonNodeInformation = this.getWonNodeInformation(wonNodeURI);
        return this.isValidURI(connectionURI, wonNodeInformation.getConnectionURIPrefix());
    }

    @Override
    public URI generateEventURI() {
        return this.generateEventURI(this.getDefaultWonNodeURI());
    }

    @Override
    public URI generateAtomURI(URI wonNodeURI) {
        WonNodeInfo wonNodeInformation = this.getWonNodeInformation(wonNodeURI);
        return URI.create(wonNodeInformation.getAtomURIPrefix() + "/" + this.generateRandomID());
    }

    @Override
    public boolean isValidAtomURI(URI atomURI) {
        return this.isValidAtomURI(atomURI, this.getDefaultWonNodeURI());
    }

    @Override
    public boolean isValidAtomURI(URI atomURI, URI wonNodeURI) {
        WonNodeInfo wonNodeInformation = this.getWonNodeInformation(wonNodeURI);
        return this.isValidURI(atomURI, wonNodeInformation.getAtomURIPrefix());
    }

    private boolean isValidURI(URI uri, String prefix) {
        return uri != null && uri.toString().startsWith(prefix);
    }

    @Override
    public URI getWonNodeUri(URI resourceURI) {
        URI wonNodeURI = WonLinkedDataUtils.getWonNodeURIForAtomOrConnectionURI(resourceURI, this.linkedDataSource);
        if (wonNodeURI == null) {
            throw new IllegalStateException("Could not obtain WoN node URI for resource " + resourceURI);
        }
        return wonNodeURI;
    }

    @Override
    public URI getDefaultWonNodeURI() {
        return this.defaultWonNodeUri;
    }

    public void setDefaultWonNodeUri(URI defaultWonNodeUri) {
        this.defaultWonNodeUri = defaultWonNodeUri;
    }

    public void setLinkedDataSource(LinkedDataSource linkedDataSource) {
        this.linkedDataSource = linkedDataSource;
    }

    public void setRandomNumberService(RandomNumberService randomNumberService) {
        this.randomNumberService = randomNumberService;
    }

    private String generateRandomID() {
        return this.randomNumberService.generateRandomString(20);
    }
}

