/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.service;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WonNodeInfo {
    private String wonNodeURI;
    private String eventURIPrefix;
    private String connectionURIPrefix;
    private String atomURIPrefix;
    private String atomListURI;
    private Map<String, Map<String, String>> supportedProtocolImpl;

    protected WonNodeInfo(String wonNodeURI, String eventURIPrefix, String connectionURIPattern, String atomURIPattern, String atomListURI, Map<String, Map<String, String>> supportedProtocolImpl) {
        this.wonNodeURI = wonNodeURI;
        this.eventURIPrefix = eventURIPrefix;
        this.connectionURIPrefix = connectionURIPattern;
        this.atomURIPrefix = atomURIPattern;
        this.atomListURI = atomListURI;
        this.supportedProtocolImpl = supportedProtocolImpl;
    }

    public String getWonNodeURI() {
        return this.wonNodeURI;
    }

    public String getAtomListURI() {
        return this.atomListURI;
    }

    public String getSupportedProtocolImplParamValue(String protocol, String paramName) {
        Map<String, String> protocolMap = this.supportedProtocolImpl.get(protocol);
        if (protocolMap != null) {
            return protocolMap.get(paramName);
        }
        return null;
    }

    public Set<String> getSupportedProtocolImpls() {
        HashSet<String> protocols = new HashSet<String>();
        protocols.addAll(this.supportedProtocolImpl.keySet());
        return protocols;
    }

    public Set<String> getSupportedProtocolImplParams(String protocol) {
        HashSet<String> protocols = new HashSet<String>();
        Map<String, String> protocolMap = this.supportedProtocolImpl.get(protocol);
        if (protocolMap != null) {
            protocols.addAll(protocolMap.keySet());
        }
        return protocolMap.keySet();
    }

    public String getEventURIPrefix() {
        return this.eventURIPrefix;
    }

    public String getConnectionURIPrefix() {
        return this.connectionURIPrefix;
    }

    public String getAtomURIPrefix() {
        return this.atomURIPrefix;
    }
}

