/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.service;

import java.net.URI;
import java.util.Collection;
import java.util.Date;
import org.apache.jena.rdf.model.Model;
import org.springframework.data.domain.Slice;
import won.protocol.exception.NoSuchAtomException;
import won.protocol.exception.NoSuchConnectionException;
import won.protocol.message.WonMessageType;
import won.protocol.model.Atom;
import won.protocol.model.AtomState;
import won.protocol.model.Connection;
import won.protocol.model.DataWithEtag;
import won.protocol.model.MessageEventPlaceholder;

public interface AtomInformationService {
    public Collection<URI> listAtomURIs();

    public Slice<URI> listAtomURIs(int var1, Integer var2, AtomState var3);

    public Slice<URI> listAtomURIsBefore(URI var1, Integer var2, AtomState var3);

    public Slice<URI> listAtomURIsAfter(URI var1, Integer var2, AtomState var3);

    public Collection<URI> listModifiedAtomURIsAfter(Date var1);

    public Collection<URI> listConnectionURIs();

    public Collection<Connection> listConnections();

    public Collection<Connection> listModifiedConnectionsAfter(Date var1);

    public Slice<URI> listConnectionURIs(int var1, Integer var2, Date var3);

    public Slice<Connection> listConnections(int var1, Integer var2, Date var3);

    public Slice<Connection> listConnectionsBefore(URI var1, Integer var2, Date var3);

    public Slice<Connection> listConnectionsAfter(URI var1, Integer var2, Date var3);

    public Collection<URI> listConnectionURIs(URI var1) throws NoSuchAtomException;

    public Collection<Connection> listConnections(URI var1) throws NoSuchAtomException;

    public Slice<URI> listConnectionURIs(URI var1, int var2, Integer var3, WonMessageType var4, Date var5);

    public Slice<Connection> listConnections(URI var1, int var2, Integer var3, WonMessageType var4, Date var5);

    public Slice listConnectionsBefore(URI var1, URI var2, Integer var3, WonMessageType var4, Date var5);

    public Slice listConnectionsAfter(URI var1, URI var2, Integer var3, WonMessageType var4, Date var5);

    public Atom readAtom(URI var1) throws NoSuchAtomException;

    public DataWithEtag<Atom> readAtom(URI var1, String var2) throws NoSuchAtomException;

    public Model readAtomContent(URI var1) throws NoSuchAtomException;

    public Connection readConnection(URI var1) throws NoSuchConnectionException;

    public DataWithEtag<Connection> readConnection(URI var1, String var2);

    public Model readConnectionContent(URI var1) throws NoSuchConnectionException;

    public Slice<MessageEventPlaceholder> listConnectionEvents(URI var1, int var2, Integer var3, WonMessageType var4);

    public Slice<MessageEventPlaceholder> listConnectionEventsBefore(URI var1, URI var2, Integer var3, WonMessageType var4);

    public Slice<MessageEventPlaceholder> listConnectionEventsAfter(URI var1, URI var2, Integer var3, WonMessageType var4);

    public static class PagedResource<T, E> {
        private T content;
        private E resumeBefore = null;
        private E resumeAfter = null;

        public PagedResource(T content) {
            this.content = content;
        }

        public PagedResource(T content, E resumeBefore, E resumeAfter) {
            this.content = content;
            this.resumeBefore = resumeBefore;
            this.resumeAfter = resumeAfter;
        }

        public T getContent() {
            return this.content;
        }

        public boolean hasNext() {
            return this.resumeAfter != null;
        }

        public E getResumeAfter() {
            return this.resumeAfter;
        }

        public boolean hasPrevious() {
            return this.resumeBefore != null;
        }

        public E getResumeBefore() {
            return this.resumeBefore;
        }
    }
}

