/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.rest;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;

public class WonEtagHelper {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final char VERSION_MEDIATYPE_DELIMITER = ' ';
    private String version = null;
    private MediaType mediaType = null;

    private WonEtagHelper(String version, MediaType mediaType) {
        this.version = version;
        this.mediaType = mediaType;
    }

    public static WonEtagHelper forVersion(String version) {
        if (version == null) {
            return null;
        }
        return new WonEtagHelper(version, null);
    }

    public static WonEtagHelper fromEtagValue(String etagValue) {
        if (etagValue == null) {
            return null;
        }
        if ((etagValue = etagValue.trim()).startsWith("W/")) {
            logger.debug("weak etag matching is not supported, cannot process: " + etagValue);
            return null;
        }
        if (!etagValue.startsWith("\"")) {
            logger.debug("etag must start with '\"', cannot process: " + etagValue);
            return null;
        }
        if (!etagValue.endsWith("\"")) {
            logger.debug("etag must end with '\"', cannot process: " + etagValue);
            return null;
        }
        int index = etagValue.indexOf(32);
        if (index == -1) {
            return new WonEtagHelper(etagValue.substring(1, etagValue.length() - 1), null);
        }
        MediaType mt = null;
        try {
            mt = MediaType.parseMediaType((String)etagValue.substring(index, etagValue.length() - 1));
        }
        catch (Exception e) {
            logger.debug("not a valid media type in etag value, cannot process: " + etagValue);
            return null;
        }
        return new WonEtagHelper(etagValue.substring(1, index), mt);
    }

    public static WonEtagHelper fromHeaderIfCompatibleWithAcceptHeader(HttpHeaders headers) {
        WonEtagHelper helper = WonEtagHelper.fromIfNoneMatchHeader(headers);
        if (helper == null || helper.getMediaType() == null) {
            return null;
        }
        if (headers.getAccept().stream().anyMatch(m -> m.isCompatibleWith(helper.getMediaType()))) {
            return helper;
        }
        return null;
    }

    public static WonEtagHelper fromIfNoneMatchHeader(HttpHeaders headers) {
        List etags = headers.getIfNoneMatch();
        if (etags.size() == 0) {
            return null;
        }
        if (etags.size() > 1) {
            logger.info("found more than one If-None-Match header values, only using first one");
        }
        return WonEtagHelper.fromEtagValue((String)etags.get(0));
    }

    public static WonEtagHelper fromEtagHeader(HttpHeaders headers) {
        return WonEtagHelper.fromEtagValue(headers.getETag());
    }

    public static void setMediaTypeForEtagHeaderIfPresent(MediaType mediaType, HttpHeaders headers) {
        WonEtagHelper wonEtagHelper = WonEtagHelper.fromEtagHeader(headers);
        if (wonEtagHelper != null) {
            wonEtagHelper.setMediaType(mediaType);
            WonEtagHelper.setEtagHeader(wonEtagHelper, headers);
        }
    }

    public static void setEtagHeader(WonEtagHelper wonEtagHelper, HttpHeaders headers) {
        if (wonEtagHelper.isValid()) {
            headers.setETag(wonEtagHelper.getEtagString());
        }
    }

    public static String getVersionIdentifier(WonEtagHelper wonEtagHelper) {
        if (wonEtagHelper != null) {
            return wonEtagHelper.getVersion();
        }
        return null;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public String getVersion() {
        return this.version;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public boolean isValid() {
        return this.version != null;
    }

    public String getEtagString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"').append(this.version);
        if (this.mediaType != null) {
            stringBuilder.append(' ');
            stringBuilder.append(this.mediaType.toString());
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }
}

