/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.WriterDatasetRIOTFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class RdfModelConverter
extends AbstractHttpMessageConverter<Model> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public RdfModelConverter() {
        this(RdfModelConverter.buildMediaTypeArray());
    }

    public RdfModelConverter(MediaType supportedMediaType) {
        super(supportedMediaType);
    }

    public RdfModelConverter(MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
    }

    protected boolean supports(Class<?> clazz) {
        return Model.class.isAssignableFrom(clazz);
    }

    protected Model readInternal(Class<? extends Model> aClass, HttpInputMessage httpInputMessage) throws IOException, HttpMessageNotReadableException {
        Model model = ModelFactory.createDefaultModel();
        Lang rdfLanguage = RdfModelConverter.mimeTypeToJenaLanguage(httpInputMessage.getHeaders().getContentType(), Lang.TURTLE);
        RDFDataMgr.read((Model)model, (InputStream)httpInputMessage.getBody(), (String)"", (Lang)rdfLanguage);
        return model;
    }

    protected void writeInternal(Model model, HttpOutputMessage httpOutputMessage) throws IOException, HttpMessageNotWritableException {
        Lang rdfLanguage = RdfModelConverter.mimeTypeToJenaLanguage(httpOutputMessage.getHeaders().getContentType(), Lang.N3);
        RDFDataMgr.write((OutputStream)httpOutputMessage.getBody(), (Model)model, (Lang)rdfLanguage);
        httpOutputMessage.getBody().flush();
    }

    private static Lang mimeTypeToJenaLanguage(MediaType mediaType, Lang defaultLanguage) {
        Lang lang = RDFLanguages.contentTypeToLang((String)mediaType.toString());
        if (lang == null) {
            return defaultLanguage;
        }
        return lang;
    }

    private static MediaType[] buildMediaTypeArray() {
        Collection languages = RDFLanguages.getRegisteredLanguages();
        HashSet<MediaType> mediaTypeSet = new HashSet<MediaType>();
        for (Lang lang : languages) {
            if (!RdfModelConverter.datasetWriterExistsForLang(lang)) continue;
            ContentType ct = lang.getContentType();
            logger.debug("registering converter for rdf content type {}", (Object)lang.getContentType());
            MediaType mt = new MediaType(ct.getType(), ct.getSubType());
            mediaTypeSet.add(mt);
        }
        return mediaTypeSet.toArray(new MediaType[0]);
    }

    private static boolean datasetWriterExistsForLang(Lang lang) {
        RDFFormat serialization = RDFWriterRegistry.defaultSerialization((Lang)lang);
        WriterDatasetRIOTFactory wf = RDFWriterRegistry.getWriterDatasetFactory((RDFFormat)serialization);
        return wf != null;
    }
}

