/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.StopWatch;
import won.protocol.rest.RDFMediaType;
import won.protocol.rest.WonEtagHelper;
import won.protocol.util.RdfUtils;

public class RdfDatasetConverter
extends AbstractHttpMessageConverter<Dataset> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final MediaType[] supportedMediaTypes = new MediaType[]{RDFMediaType.APPLICATION_TRIG, RDFMediaType.APPLICATION_NQUADS, RDFMediaType.APPLICATION_X_TURTLE, RDFMediaType.TEXT_RDF_N3, RDFMediaType.TEXT_TURTLE, RDFMediaType.APPLICATION_JSONLD};

    public RdfDatasetConverter() {
        this(supportedMediaTypes);
    }

    public RdfDatasetConverter(MediaType supportedMediaType) {
        super(supportedMediaType);
    }

    public RdfDatasetConverter(MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
    }

    protected boolean supports(Class<?> clazz) {
        return Dataset.class.isAssignableFrom(clazz);
    }

    protected Dataset readInternal(Class<? extends Dataset> aClass, HttpInputMessage httpInputMessage) throws IOException, HttpMessageNotReadableException {
        Lang rdfLanguage = RdfDatasetConverter.mimeTypeToJenaLanguage(httpInputMessage.getHeaders().getContentType(), Lang.TRIG);
        return RdfUtils.toDataset(httpInputMessage.getBody(), new RDFFormat(rdfLanguage));
    }

    protected void writeInternal(Dataset dataset, HttpOutputMessage httpOutputMessage) throws IOException, HttpMessageNotWritableException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        MediaType contentType = httpOutputMessage.getHeaders().getContentType();
        Lang rdfLanguage = RdfDatasetConverter.mimeTypeToJenaLanguage(contentType, Lang.TRIG);
        WonEtagHelper.setMediaTypeForEtagHeaderIfPresent(contentType, httpOutputMessage.getHeaders());
        RDFDataMgr.write((OutputStream)httpOutputMessage.getBody(), (Dataset)dataset, (Lang)rdfLanguage);
        httpOutputMessage.getBody().flush();
        stopWatch.stop();
        logger.debug("writing dataset took " + stopWatch.getLastTaskTimeMillis() + " millls");
    }

    private static Lang mimeTypeToJenaLanguage(MediaType mediaType, Lang defaultLanguage) {
        Lang lang = RDFLanguages.contentTypeToLang((String)mediaType.toString());
        if (lang == null) {
            return defaultLanguage;
        }
        return lang;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Arrays.asList(supportedMediaTypes);
    }
}

