/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.rest;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.http.MediaType;

public class RDFMediaType {
    public static final MediaType TEXT_TURTLE = new MediaType("text", "turtle");
    public static final MediaType APPLICATION_RDF_XML = new MediaType("application", "rdf+xml");
    public static final MediaType APPLICATION_X_TURTLE = new MediaType("application", "x-turtle");
    public static final MediaType TEXT_RDF_N3 = new MediaType("text", "rdf+n3");
    public static final MediaType APPLICATION_JSON = new MediaType("application", "json");
    public static final MediaType APPLICATION_TRIG = new MediaType("application", "trig");
    public static final MediaType APPLICATION_JSONLD = new MediaType("application", "ld+json");
    public static final MediaType APPLICATION_NQUADS = new MediaType("application", "n-quads");
    public static final Set<MediaType> rdfMediaTypes;

    public static boolean isRDFMediaType(MediaType mediaType) {
        return rdfMediaTypes.contains(mediaType);
    }

    static {
        HashSet<MediaType> types = new HashSet<MediaType>(Arrays.asList(TEXT_TURTLE, APPLICATION_RDF_XML, APPLICATION_X_TURTLE, TEXT_RDF_N3, APPLICATION_JSON, APPLICATION_TRIG, APPLICATION_JSONLD, APPLICATION_NQUADS));
        rdfMediaTypes = Collections.unmodifiableSet(types);
    }
}

