/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.rest;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import won.cryptography.keymanagement.AtomUriAsAliasStrategy;
import won.cryptography.keymanagement.KeyPairAliasDerivationStrategy;
import won.cryptography.service.CryptographyUtils;
import won.cryptography.service.TrustStoreService;
import won.cryptography.service.keystore.KeyStoreService;
import won.cryptography.ssl.PredefinedAliasPrivateKeyStrategy;
import won.protocol.rest.DatasetResponseWithStatusCodeAndHeaders;
import won.protocol.rest.LinkedDataRestClient;
import won.protocol.rest.RdfDatasetConverter;

public class LinkedDataRestClientHttps
extends LinkedDataRestClient {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private HttpMessageConverter datasetConverter;
    String acceptHeaderValue = null;
    private Integer readTimeout = 5000;
    private Integer connectionTimeout = 5000;
    private KeyStoreService keyStoreService;
    private TrustStoreService trustStoreService;
    private TrustStrategy trustStrategy;
    private KeyPairAliasDerivationStrategy keyPairAliasDerivationStrategy = new AtomUriAsAliasStrategy();

    public LinkedDataRestClientHttps(KeyStoreService keyStoreService, TrustStoreService trustStoreService, TrustStrategy trustStrategy, KeyPairAliasDerivationStrategy keyPairAliasDerivationStrategy) {
        this.keyStoreService = keyStoreService;
        this.trustStoreService = trustStoreService;
        this.trustStrategy = trustStrategy;
        this.keyPairAliasDerivationStrategy = keyPairAliasDerivationStrategy;
    }

    @PostConstruct
    public void initialize() {
        this.datasetConverter = new RdfDatasetConverter();
        HttpHeaders headers = new HttpHeaders();
        this.acceptHeaderValue = MediaType.toString((Collection)this.datasetConverter.getSupportedMediaTypes());
    }

    private RestTemplate createRestTemplateForReadingLinkedData(String webID) {
        RestTemplate template = null;
        try {
            template = CryptographyUtils.createSslRestTemplate(this.keyStoreService.getUnderlyingKeyStore(), this.keyStoreService.getPassword(), new PredefinedAliasPrivateKeyStrategy(this.keyPairAliasDerivationStrategy.getAliasForAtomUri(webID)), this.trustStoreService.getUnderlyingKeyStore(), this.trustStrategy, this.readTimeout, this.connectionTimeout, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create rest template for webID '" + webID + "'", e);
        }
        template.getMessageConverters().add(0, this.datasetConverter);
        return template;
    }

    @Override
    public DatasetResponseWithStatusCodeAndHeaders readResourceDataWithHeaders(URI resourceURI) {
        return this.readResourceDataWithHeaders(resourceURI, (URI)null);
    }

    @Override
    public DatasetResponseWithStatusCodeAndHeaders readResourceDataWithHeaders(URI resourceURI, URI requesterWebID) {
        RestTemplate restTemplate;
        RdfDatasetConverter datasetConverter = new RdfDatasetConverter();
        try {
            restTemplate = this.getRestTemplateForReadingLinkedData(requesterWebID == null ? null : requesterWebID.toString());
        }
        catch (Exception e) {
            logger.error("Failed to create ssl tofu rest template", (Throwable)e);
            throw new RuntimeException(e);
        }
        restTemplate.getMessageConverters().add(datasetConverter);
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.add("Accept", this.acceptHeaderValue);
        return super.readResourceData(resourceURI, restTemplate, requestHeaders);
    }

    @Override
    public DatasetResponseWithStatusCodeAndHeaders readResourceDataWithHeaders(URI resourceURI, URI requesterWebID, HttpHeaders requestHeaders) {
        requestHeaders.add("Accept", this.acceptHeaderValue);
        return super.readResourceData(resourceURI, this.getRestTemplateForReadingLinkedData(requesterWebID == null ? null : requesterWebID.toString()), requestHeaders);
    }

    private RestTemplate getRestTemplateForReadingLinkedData(String webID) {
        return this.createRestTemplateForReadingLinkedData(webID);
    }

    @Override
    public DatasetResponseWithStatusCodeAndHeaders readResourceDataWithHeaders(URI resourceURI, HttpHeaders requestHeaders) {
        return this.readResourceDataWithHeaders(resourceURI, null, requestHeaders);
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }
}

