/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.rest;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import won.protocol.rest.DatasetResponseWithStatusCodeAndHeaders;
import won.protocol.rest.LinkedDataFetchingException;

public abstract class LinkedDataRestClient {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public Dataset readResourceData(URI resourceURI) {
        return this.readResourceDataWithHeaders(resourceURI).getDataset();
    }

    public abstract DatasetResponseWithStatusCodeAndHeaders readResourceDataWithHeaders(URI var1, HttpHeaders var2);

    public Dataset readResourceData(URI resourceURI, URI requesterWebID) {
        return this.readResourceDataWithHeaders(resourceURI, requesterWebID).getDataset();
    }

    public abstract DatasetResponseWithStatusCodeAndHeaders readResourceDataWithHeaders(URI var1);

    public abstract DatasetResponseWithStatusCodeAndHeaders readResourceDataWithHeaders(URI var1, URI var2);

    public abstract DatasetResponseWithStatusCodeAndHeaders readResourceDataWithHeaders(URI var1, URI var2, HttpHeaders var3);

    protected DatasetResponseWithStatusCodeAndHeaders readResourceData(URI resourceURI, RestTemplate restTemplate, HttpHeaders requestHeaders) {
        Dataset result;
        assert (resourceURI != null) : "resource URI must not be null";
        logger.debug("fetching linked data resource: {}", (Object)resourceURI);
        int statusCode = -1;
        HttpHeaders responseHeaders = null;
        try {
            HttpEntity entity = new HttpEntity(null, (MultiValueMap)requestHeaders);
            ResponseEntity response = restTemplate.exchange(resourceURI, HttpMethod.GET, entity, Dataset.class);
            statusCode = response.getStatusCode().value();
            responseHeaders = response.getHeaders();
            if (response.getStatusCode().is4xxClientError()) {
                throw new HttpClientErrorException(response.getStatusCode());
            }
            if (response.getStatusCode().is5xxServerError()) {
                throw new HttpServerErrorException(response.getStatusCode());
            }
            result = (Dataset)response.getBody();
        }
        catch (RestClientException e) {
            if (e instanceof HttpClientErrorException) {
                throw new LinkedDataFetchingException(resourceURI, MessageFormat.format("caught a HttpClientErrorException exception, for {0}. Underlying error message is: {1}, response Body: {2}", resourceURI, e.getMessage(), ((HttpClientErrorException)e).getResponseBodyAsString()), e);
            }
            if (e instanceof HttpServerErrorException) {
                throw new LinkedDataFetchingException(resourceURI, MessageFormat.format("caught a HttpServerErrorException exception, for {0}. Underlying error message is: {1}, response Body: {2}", resourceURI, e.getMessage(), ((HttpServerErrorException)e).getResponseBodyAsString()), e);
            }
            throw new LinkedDataFetchingException(resourceURI, MessageFormat.format("caught a clientHandler exception, which may indicate that the URI that was accessed isn''t a linked data URI, please check {0}. Underlying error message is: {1}", resourceURI, e.getMessage()), e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("fetched model with {} statements in default model for resource {}", (Object)result.getDefaultModel().size(), (Object)resourceURI);
        }
        return new DatasetResponseWithStatusCodeAndHeaders(result, statusCode, responseHeaders);
    }
}

