/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.rest;

import java.lang.invoke.MethodHandles;
import javax.annotation.PostConstruct;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import won.cryptography.keymanagement.AtomUriAsAliasStrategy;
import won.cryptography.keymanagement.KeyPairAliasDerivationStrategy;
import won.cryptography.service.CryptographyUtils;
import won.cryptography.service.TrustStoreService;
import won.cryptography.service.keystore.KeyStoreService;
import won.cryptography.ssl.PredefinedAliasPrivateKeyStrategy;

public class LinkedDataRestBridge {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private RestTemplate restTemplateWithDefaultWebId;
    private Integer readTimeout = 10000;
    private Integer connectionTimeout = 10000;
    private KeyStoreService keyStoreService;
    private TrustStoreService trustStoreService;
    private TrustStrategy trustStrategy;
    private KeyPairAliasDerivationStrategy keyPairAliasDerivationStrategy = new AtomUriAsAliasStrategy();

    public LinkedDataRestBridge(KeyStoreService keyStoreService, TrustStoreService trustStoreService, TrustStrategy trustStrategy, KeyPairAliasDerivationStrategy keyPairAliasDerivationStrategy) {
        this.keyStoreService = keyStoreService;
        this.trustStoreService = trustStoreService;
        this.trustStrategy = trustStrategy;
        this.keyPairAliasDerivationStrategy = keyPairAliasDerivationStrategy;
    }

    @PostConstruct
    public void initialize() {
        String defaultAlias = this.keyPairAliasDerivationStrategy.getAliasForAtomUri(null);
        if (defaultAlias != null) {
            try {
                this.restTemplateWithDefaultWebId = this.createRestTemplateForReadingLinkedData(null);
            }
            catch (Exception e) {
                throw new RuntimeException("could not create rest template for default alias " + defaultAlias);
            }
        } else {
            this.restTemplateWithDefaultWebId = new RestTemplate();
        }
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplateWithDefaultWebId;
    }

    public RestTemplate getRestTemplate(String requesterWebID) {
        RestTemplate restTemplate;
        try {
            restTemplate = this.getRestTemplateForReadingLinkedData(requesterWebID);
        }
        catch (Exception e) {
            logger.error("Failed to create ssl tofu rest template", (Throwable)e);
            throw new RuntimeException(e);
        }
        return restTemplate;
    }

    private RestTemplate getRestTemplateForReadingLinkedData(String webID) throws Exception {
        if (webID == null) {
            return this.restTemplateWithDefaultWebId;
        }
        return this.createRestTemplateForReadingLinkedData(webID);
    }

    private RestTemplate createRestTemplateForReadingLinkedData(String webID) throws Exception {
        RestTemplate template = CryptographyUtils.createSslRestTemplate(this.keyStoreService.getUnderlyingKeyStore(), this.keyStoreService.getPassword(), new PredefinedAliasPrivateKeyStrategy(this.keyPairAliasDerivationStrategy.getAliasForAtomUri(webID)), this.trustStoreService.getUnderlyingKeyStore(), this.trustStrategy, this.readTimeout, this.connectionTimeout, true);
        template.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            protected boolean hasError(HttpStatus statusCode) {
                return false;
            }
        });
        return template;
    }
}

