/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.repository.rdfstorage.impl;

import java.net.URI;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.springframework.beans.factory.annotation.Autowired;
import won.protocol.model.DataWithEtag;
import won.protocol.model.DatasetHolder;
import won.protocol.repository.DatasetHolderRepository;
import won.protocol.repository.rdfstorage.RDFStorageService;

public class JpaRepositoryBasedRdfStorageServiceImpl
implements RDFStorageService {
    @Autowired
    private DatasetHolderRepository datasetHolderRepository;

    @Override
    public void storeModel(URI resourceURI, Model model) {
        Dataset dataset = DatasetFactory.createGeneral();
        dataset.setDefaultModel(model);
        this.storeDataset(resourceURI, dataset);
    }

    @Override
    public void storeDataset(URI resourceURI, Dataset dataset) {
        DatasetHolder datasetHolder = this.datasetHolderRepository.findOneByUri(resourceURI);
        if (datasetHolder != null) {
            datasetHolder.setDataset(dataset);
        } else {
            datasetHolder = new DatasetHolder(resourceURI, dataset);
        }
        this.datasetHolderRepository.save(datasetHolder);
    }

    @Override
    public Model loadModel(URI resourceURI) {
        DatasetHolder datasetHolder = this.datasetHolderRepository.findOneByUri(resourceURI);
        return datasetHolder == null ? null : datasetHolder.getDataset().getDefaultModel();
    }

    @Override
    public DataWithEtag<Model> loadModel(URI resourceURI, String etag) {
        Integer version = Integer.valueOf(etag);
        DatasetHolder datasetHolder = this.datasetHolderRepository.findOneByUriAndVersionNot(resourceURI, version);
        DataWithEtag<Model> dataWithEtag = new DataWithEtag<Model>(datasetHolder == null ? null : datasetHolder.getDataset().getDefaultModel(), datasetHolder == null ? etag : Integer.toString(datasetHolder.getVersion()), etag);
        return dataWithEtag;
    }

    @Override
    public Dataset loadDataset(URI resourceURI) {
        DatasetHolder datasetHolder = this.datasetHolderRepository.findOneByUri(resourceURI);
        return datasetHolder == null ? null : datasetHolder.getDataset();
    }

    @Override
    public DataWithEtag<Dataset> loadDataset(URI resourceURI, String etag) {
        Integer version = etag == null ? -1 : Integer.valueOf(etag);
        DatasetHolder datasetHolder = this.datasetHolderRepository.findOneByUriAndVersionNot(resourceURI, version);
        DataWithEtag<Dataset> dataWithEtag = new DataWithEtag<Dataset>(datasetHolder == null ? null : datasetHolder.getDataset(), datasetHolder == null ? etag : Integer.toString(datasetHolder.getVersion()), etag);
        return dataWithEtag;
    }

    @Override
    public boolean removeContent(URI resourceURI) {
        try {
            this.datasetHolderRepository.delete(resourceURI);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

