/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.repository;

import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.LockModeType;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import won.protocol.message.WonMessageType;
import won.protocol.model.MessageEventPlaceholder;
import won.protocol.model.unread.UnreadMessageInfoForConnection;
import won.protocol.repository.WonRepository;

public interface MessageEventRepository
extends WonRepository<MessageEventPlaceholder> {
    public MessageEventPlaceholder findOneByMessageURI(URI var1);

    @Query(value="select case when (count(msg) > 0) then true else false end from MessageEventPlaceholder msg left outer join Connection con on ( msg.parentURI = con.connectionURI or  msg.parentURI = con.atomURI  )  where msg.messageURI = :messageUri and (   ( con is null and msg.parentURI = :webId )   or con.atomURI = :webId    or con.targetAtomURI = :webId    or msg.recipientNodeURI = :webId    or msg.senderNodeURI = :webId )")
    public boolean isReadPermittedForWebID(@Param(value="messageUri") URI var1, @Param(value="webId") URI var2);

    @Query(value="select \n\tnew won.protocol.model.unread.UnreadMessageInfoForConnection(\n\t\tc.connectionURI, \n\t\tc.state, \n\t\tcount(*), \n\t\tmax(m.creationDate), \n\t\tmin(m.creationDate) \n  ) \n    from Connection c join MessageEventPlaceholder m on \n    \tc.connectionURI = m.parentURI\n    left join MessageEventPlaceholder last on \n        m.parentURI = last.parentURI\n        and last.messageURI in :lastSeenMessageUris \n    where \n        c.atomURI = :atomUri \n\t\tand m.messageType not in ('SUCCESS_RESPONSE', 'FAILURE_RESPONSE') \n        and (last is null or m.creationDate > last.creationDate) \n    group by c.connectionURI, c.state \n")
    public List<UnreadMessageInfoForConnection> getUnreadInfoForAtom(@Param(value="atomUri") URI var1, @Param(value="lastSeenMessageUris") Collection<URI> var2);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select n,c from AtomMessageContainer c join MessageEventPlaceholder msg on msg.parentURI = c.parentUri join Atom n on c.parentUri = n.atomURI where msg.messageURI = :messageUri")
    public void lockAtomAndMessageContainerByContainedMessageForUpdate(@Param(value="messageUri") URI var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select con,c from AtomMessageContainer c join MessageEventPlaceholder msg on msg.parentURI = c.parentUri join Connection con on c.parentUri = con.connectionURI where msg.messageURI = :messageUri")
    public void lockConnectionAndMessageContainerByContainedMessageForUpdate(@Param(value="messageUri") URI var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select msg from MessageEventPlaceholder msg where msg.messageURI = :uri")
    public MessageEventPlaceholder findOneByMessageURIforUpdate(@Param(value="uri") URI var1);

    public List<MessageEventPlaceholder> findByParentURI(URI var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select msg from MessageEventPlaceholder msg where msg.parentURI = :parent and msg.messageType = :messageType")
    public List<MessageEventPlaceholder> findByParentURIAndMessageTypeForUpdate(@Param(value="parent") URI var1, @Param(value="messageType") WonMessageType var2);

    @Query(value="select count(*) from MessageEventPlaceholder msg where msg.parentURI = :parent and msg.messageType = :messageType")
    public long countByParentURIAndMessageType(@Param(value="parent") URI var1, @Param(value="messageType") WonMessageType var2);

    @Query(value="select msg from MessageEventPlaceholder msg where msg.parentURI = :parent and msg.messageType = :messageType")
    public List<MessageEventPlaceholder> findByParentURIAndMessageType(@Param(value="parent") URI var1, @Param(value="messageType") WonMessageType var2);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select msg from MessageEventPlaceholder msg left outer join MessageEventPlaceholder msg2 on msg.parentURI = msg2.parentURI and msg.creationDate < msg2.creationDate where msg.parentURI = :parent and msg2.id is null")
    public MessageEventPlaceholder findNewestByParentURIforUpdate(@Param(value="parent") URI var1);

    @Query(value="select msg from MessageEventPlaceholder msg left outer join MessageEventPlaceholder msg2 on msg.parentURI = msg2.parentURI and msg.creationDate < msg2.creationDate where msg.parentURI = :parent and msg2.id is null")
    public MessageEventPlaceholder findNewestByParentURI(@Param(value="parent") URI var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select msg from MessageEventPlaceholder msg left outer join MessageEventPlaceholder msg2 on msg.parentURI = msg2.parentURI and msg.creationDate > msg2.creationDate where msg.parentURI = :parent and msg2.id is null")
    public MessageEventPlaceholder findOldestByParentURIforUpdate(@Param(value="parent") URI var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select msg from MessageEventPlaceholder msg where msg.parentURI = :parent and referencedByOtherMessage = false")
    public List<MessageEventPlaceholder> findByParentURIAndNotReferencedByOtherMessageForUpdate(@Param(value="parent") URI var1);

    @Query(value="select msg from MessageEventPlaceholder msg where msg.parentURI = :parent and referencedByOtherMessage = false")
    public List<MessageEventPlaceholder> findByParentURIAndNotReferencedByOtherMessage(@Param(value="parent") URI var1);

    @Query(value="select msg from MessageEventPlaceholder msg where msg.parentURI = :parent")
    public Slice<MessageEventPlaceholder> findByParentURI(@Param(value="parent") URI var1, Pageable var2);

    @Query(value="select msg from MessageEventPlaceholder msg left join fetch msg.datasetHolder where msg.parentURI = :parent")
    public Slice<MessageEventPlaceholder> findByParentURIFetchDatasetEagerly(@Param(value="parent") URI var1, Pageable var2);

    @Query(value="select messageURI from MessageEventPlaceholder msg where msg.parentURI = :parent and msg.messageType = :messageType")
    public Slice<URI> getMessageURIsByParentURI(@Param(value="parent") URI var1, @Param(value="messageType") WonMessageType var2, Pageable var3);

    @Query(value="select msg from MessageEventPlaceholder msg where msg.parentURI = :parent and msg.messageType = :messageType")
    public Slice<MessageEventPlaceholder> findByParentURIAndType(@Param(value="parent") URI var1, @Param(value="messageType") WonMessageType var2, Pageable var3);

    @Query(value="select msg from MessageEventPlaceholder msg left join fetch msg.datasetHolder where msg.parentURI = :parent and msg.messageType = :messageType")
    public Slice<MessageEventPlaceholder> findByParentURIAndTypeFetchDatasetEagerly(@Param(value="parent") URI var1, @Param(value="messageType") WonMessageType var2, Pageable var3);

    @Query(value="select messageURI from MessageEventPlaceholder msg where msg.parentURI = :parent and msg.creationDate < :referenceDate")
    public Slice<URI> getMessageURIsByParentURIBefore(@Param(value="parent") URI var1, @Param(value="referenceDate") Date var2, Pageable var3);

    @Query(value="select msg from MessageEventPlaceholder msg where msg.parentURI = :parent and msg.creationDate < :referenceDate")
    public Slice<MessageEventPlaceholder> findByParentURIBefore(@Param(value="parent") URI var1, @Param(value="referenceDate") Date var2, Pageable var3);

    @Query(value="select msg from MessageEventPlaceholder msg left join fetch msg.datasetHolder where msg.parentURI = :parent and msg.creationDate < :referenceDate")
    public Slice<MessageEventPlaceholder> findByParentURIBeforeFetchDatasetEagerly(@Param(value="parent") URI var1, @Param(value="referenceDate") Date var2, Pageable var3);

    @Query(value="select msg from MessageEventPlaceholder msg left join fetch msg.datasetHolder where msg.parentURI = :parent and msg.creationDate < (select msg2.creationDate from MessageEventPlaceholder msg2 where msg2.messageURI = :referenceMessageUri )")
    public Slice<MessageEventPlaceholder> findByParentURIBeforeFetchDatasetEagerly(@Param(value="parent") URI var1, @Param(value="referenceMessageUri") URI var2, Pageable var3);

    @Query(value="select messageURI from MessageEventPlaceholder msg where msg.parentURI = :parent and msg.creationDate < :referenceDate and msg.messageType = :messageType")
    public Slice<URI> getMessageURIsByParentURIBefore(@Param(value="parent") URI var1, @Param(value="referenceDate") Date var2, @Param(value="messageType") WonMessageType var3, Pageable var4);

    @Query(value="select msg from MessageEventPlaceholder msg where msg.parentURI = :parent and msg.creationDate < :referenceDate and msg.messageType = :messageType")
    public Slice<MessageEventPlaceholder> findByParentURIAndTypeBefore(@Param(value="parent") URI var1, @Param(value="referenceDate") Date var2, @Param(value="messageType") WonMessageType var3, Pageable var4);

    @Query(value="select msg from MessageEventPlaceholder msg left join fetch msg.datasetHolder where msg.parentURI = :parent and msg.creationDate < :referenceDate and msg.messageType = :messageType")
    public Slice<MessageEventPlaceholder> findByParentURIAndTypeBeforeFetchDatasetEagerly(@Param(value="parent") URI var1, @Param(value="referenceDate") Date var2, @Param(value="messageType") WonMessageType var3, Pageable var4);

    @Query(value="select msg from MessageEventPlaceholder msg left join fetch msg.datasetHolder where msg.parentURI = :parent and msg.messageType = :messageType and msg.creationDate < (select msg2.creationDate from MessageEventPlaceholder msg2 where msg2.messageURI = :referenceMessageUri )")
    public Slice<MessageEventPlaceholder> findByParentURIAndTypeBeforeFetchDatasetEagerly(@Param(value="parent") URI var1, @Param(value="referenceMessageUri") URI var2, @Param(value="messageType") WonMessageType var3, Pageable var4);

    @Query(value="select messageURI from MessageEventPlaceholder msg where msg.parentURI = :parent and msg.creationDate > :referenceDate")
    public Slice<URI> getMessageURIsByParentURIAfter(@Param(value="parent") URI var1, @Param(value="referenceDate") Date var2, Pageable var3);

    @Query(value="select msg from MessageEventPlaceholder msg where msg.parentURI = :parent and msg.creationDate > :referenceDate")
    public Slice<MessageEventPlaceholder> findByParentURIAfter(@Param(value="parent") URI var1, @Param(value="referenceDate") Date var2, Pageable var3);

    @Query(value="select msg from MessageEventPlaceholder msg left join fetch msg.datasetHolder where msg.parentURI = :parent and msg.creationDate > :referenceDate")
    public Slice<MessageEventPlaceholder> findByParentURIAfterFetchDatasetEagerly(@Param(value="parent") URI var1, @Param(value="referenceDate") Date var2, Pageable var3);

    @Query(value="select messageURI from MessageEventPlaceholder msg where msg.parentURI = :parent and msg.creationDate > :referenceDate and msg.messageType = :messageType")
    public Slice<URI> getMessageURIsByParentURIAfter(@Param(value="parent") URI var1, @Param(value="referenceDate") Date var2, @Param(value="messageType") WonMessageType var3, Pageable var4);

    @Query(value="select msg from MessageEventPlaceholder msg left join fetch msg.datasetHolder where msg.parentURI = :parent and msg.creationDate > :referenceDate and msg.messageType = :messageType")
    public Slice<MessageEventPlaceholder> findByParentURIAndTypeAfter(@Param(value="parent") URI var1, @Param(value="referenceDate") Date var2, @Param(value="messageType") WonMessageType var3, Pageable var4);

    @Query(value="select msg from MessageEventPlaceholder msg where msg.parentURI = :parent and msg.creationDate > :referenceDate and msg.messageType = :messageType")
    public Slice<MessageEventPlaceholder> findByParentURIAndTypeAfterFetchDatasetEagerly(@Param(value="parent") URI var1, @Param(value="referenceDate") Date var2, @Param(value="messageType") WonMessageType var3, Pageable var4);

    @Query(value="select msg from MessageEventPlaceholder msg where msg.correspondingRemoteMessageURI = :uri")
    public MessageEventPlaceholder findOneByCorrespondingRemoteMessageURI(@Param(value="uri") URI var1);

    @Query(value="select max(msg.creationDate) from MessageEventPlaceholder msg where msg.creationDate <= :referenceDate and parentURI = :parent")
    public Date findMaxActivityDateOfParentAtTime(@Param(value="parent") URI var1, @Param(value="referenceDate") Date var2);

    @Query(value="select max(msg.creationDate) from MessageEventPlaceholder msg where msg.creationDate <= :referenceDate and parentURI = :parent and msg.messageType = :messageType")
    public Date findMaxActivityDateOfParentAtTime(@Param(value="parent") URI var1, @Param(value="messageType") WonMessageType var2, @Param(value="referenceDate") Date var3);

    @Query(value="select case when (count(otherMsg) > 0) then true else false end from MessageEventPlaceholder msg, MessageEventPlaceholder otherMsg join Connection otherCon on (otherMsg.parentURI = otherCon.connectionURI) where msg.messageURI = :messageUri and otherMsg.messageURI <> msg.messageURI and otherCon.atomURI = msg.recipientAtomURI and otherMsg.recipientAtomURI = msg.recipientAtomURI and otherMsg.innermostMessageURI = msg.innermostMessageURI and (     msg.creationDate > otherMsg.creationDate     or (        msg.creationDate = otherMsg.creationDate and         msg.id > otherMsg.id     ))")
    public boolean existEarlierMessageWithSameInnermostMessageURIAndRecipientAtomURI(@Param(value="messageUri") URI var1);

    @Query(value="select case when (count(otherMsg) > 0) then true else false end from MessageEventPlaceholder msg, MessageEventPlaceholder otherMsg join Connection otherCon on (otherMsg.parentURI = otherCon.connectionURI) where msg.messageURI = :messageUri and otherMsg.senderAtomURI = :senderAtomUri and otherMsg.messageURI <> msg.messageURI and otherCon.atomURI = msg.recipientAtomURI and otherMsg.recipientAtomURI = msg.recipientAtomURI and otherMsg.innermostMessageURI = msg.innermostMessageURI")
    public boolean isReceivedSameInnermostMessageFromSender(@Param(value="messageUri") URI var1, @Param(value="senderAtomUri") URI var2);

    public void deleteByParentURI(URI var1);
}

