/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.repository;

import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.persistence.LockModeType;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import won.protocol.message.WonMessageType;
import won.protocol.model.Connection;
import won.protocol.model.ConnectionState;
import won.protocol.repository.WonRepository;

public interface ConnectionRepository
extends WonRepository<Connection> {
    public List<Connection> findByConnectionURI(URI var1);

    public Connection findOneByConnectionURI(URI var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select con from Connection con where connectionURI = :uri")
    public Optional<Connection> findOneByConnectionURIForUpdate(@Param(value="uri") URI var1);

    public Connection findOneByConnectionURIAndVersionNot(URI var1, int var2);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select con from Connection con where atomURI = :atomUri and targetAtomURI = :targetAtomUri and socketURI = :socketUri and targetSocketURI = :targetSocketUri")
    public Optional<Connection> findOneByAtomURIAndTargetAtomURIAndSocketURIAndTargetSocketURIForUpdate(@Param(value="atomUri") URI var1, @Param(value="targetAtomUri") URI var2, @Param(value="socketUri") URI var3, @Param(value="targetSocketUri") URI var4);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select con from Connection con where atomURI = :atomUri and targetAtomURI = :targetAtomUri and socketURI = :socketUri and targetSocketURI is null")
    public Optional<Connection> findOneByAtomURIAndTargetAtomURIAndSocketURIAndNullTargetSocketForUpdate(@Param(value="atomUri") URI var1, @Param(value="targetAtomUri") URI var2, @Param(value="socketUri") URI var3);

    public List<Connection> findByAtomURI(URI var1);

    public List<Connection> findByAtomURIAndStateAndTypeURI(URI var1, ConnectionState var2, URI var3);

    public List<Connection> findByAtomURIAndState(URI var1, ConnectionState var2);

    public List<Connection> findBySocketURIAndState(URI var1, ConnectionState var2);

    public List<Connection> findByAtomURIAndTypeURI(URI var1, URI var2);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select count (*) from Connection con where socketURI = :socketUri")
    public long countBySocketUriForUpdate(URI var1);

    public long countByAtomURIAndState(URI var1, ConnectionState var2);

    public long countBySocketURIAndState(URI var1, ConnectionState var2);

    @Query(value="select connectionURI from Connection")
    public List<URI> getAllConnectionURIs();

    @Query(value="select conn from Connection conn")
    public List<Connection> getAllConnections();

    @Query(value="select connectionURI from Connection where atomURI = ?1")
    public List<URI> getAllConnectionURIsForAtomURI(URI var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select c from Connection c where c.atomURI = ?1 and c.state != ?2")
    public List<Connection> findByAtomURIAndNotStateForUpdate(URI var1, ConnectionState var2);

    @Query(value="select c from Connection c where c.atomURI = ?1 and c.state != ?2")
    public List<Connection> findByAtomURIAndNotState(URI var1, ConnectionState var2);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select c from Connection c where c.atomURI = ?1 and c.socketURI = ?2 and c.state != ?3")
    public List<Connection> findByAtomURIAndSocketURIAndNotStateForUpdate(URI var1, URI var2, ConnectionState var3);

    @Query(value="select c from Connection c where c.atomURI = ?1 and c.socketURI = ?2 and c.state != ?3")
    public List<Connection> findByAtomURIAndSocketURIAndNotState(URI var1, URI var2, ConnectionState var3);

    @Query(value="select conn from Connection conn where lastUpdate > :modifiedAfter")
    public List<Connection> findModifiedConnectionsAfter(@Param(value="modifiedAfter") Date var1);

    @Query(value="select msg.parentURI from MessageEventPlaceholder msg where (msg.senderURI = msg.parentURI or msg.recipientURI = msg.parentURI) group by msg.parentURI")
    public Slice<URI> getConnectionURIByActivityDate(Pageable var1);

    @Query(value="select conn from Connection conn where conn.connectionURI in (select distinct msg.parentURI from MessageEventPlaceholder msg where (msg.senderURI = msg.parentURI or msg.recipientURI = msg.parentURI))")
    public Slice<Connection> getConnectionsByActivityDate(Pageable var1);

    @Query(value="select msg.parentURI from MessageEventPlaceholder msg where ((msg.senderURI = msg.parentURI or msg.recipientURI = msg.parentURI) and (msg.creationDate < :referenceDate))group by msg.parentURI")
    public Slice<URI> getConnectionURIByActivityDate(@Param(value="referenceDate") Date var1, Pageable var2);

    @Query(value="select conn from Connection conn where conn.connectionURI in (select distinct msg.parentURI from MessageEventPlaceholder msg where ((msg.senderURI = msg.parentURI or msg.recipientURI = msg.parentURI) and (msg.creationDate < :referenceDate)))")
    public Slice<Connection> getConnectionsByActivityDate(@Param(value="referenceDate") Date var1, Pageable var2);

    @Query(value="select conn from Connection conn where conn.connectionURI in (select msg.parentURI from MessageEventPlaceholder msg where ((msg.senderURI = msg.parentURI or msg.recipientURI = msg.parentURI) and (msg.creationDate < :referenceDate))group by msg.parentURI having max(msg.creationDate) < :resumeDate)")
    public Slice<Connection> getConnectionsBeforeByActivityDate(@Param(value="resumeDate") Date var1, @Param(value="referenceDate") Date var2, Pageable var3);

    @Query(value="select conn from Connection conn where conn.connectionURI in (select msg.parentURI from MessageEventPlaceholder msg where ((msg.senderURI = msg.parentURI or msg.recipientURI = msg.parentURI) and (msg.creationDate < :referenceDate))group by msg.parentURI having max(msg.creationDate) > :resumeDate)")
    public Slice<Connection> getConnectionsAfterByActivityDate(@Param(value="resumeDate") Date var1, @Param(value="referenceDate") Date var2, Pageable var3);

    @Query(value="select msg.parentURI from MessageEventPlaceholder msg where (msg.senderAtomURI = :atom and msg.senderURI = msg.parentURI)    or (msg.recipientAtomURI = :atom and msg.recipientURI = msg.parentURI) group by msg.parentURI")
    public Slice<URI> getConnectionURIByActivityDate(@Param(value="atom") URI var1, Pageable var2);

    @Query(value="select conn from Connection conn where conn.connectionURI in (select distinct msg.parentURI  from MessageEventPlaceholder msg where (msg.senderAtomURI = :atom and msg.senderURI = msg.parentURI)    or (msg.recipientAtomURI = :atom and msg.recipientURI = msg.parentURI))")
    public Slice<Connection> getConnectionsByActivityDate(@Param(value="atom") URI var1, Pageable var2);

    @Query(value="select msg.parentURI from MessageEventPlaceholder msg where (((msg.senderAtomURI = :atom and msg.senderURI = msg.parentURI)    or (msg.recipientAtomURI = :atom and msg.recipientURI = msg.parentURI)) and (msg.creationDate < :referenceDate)) group by msg.parentURI")
    public Slice<URI> getConnectionURIByActivityDate(@Param(value="atom") URI var1, @Param(value="referenceDate") Date var2, Pageable var3);

    @Query(value="select conn from Connection conn where conn.connectionURI in (select distinct msg.parentURI  from MessageEventPlaceholder msg where (((msg.senderAtomURI = :atom and msg.senderURI = msg.parentURI)    or (msg.recipientAtomURI = :atom and msg.recipientURI = msg.parentURI)) and (msg.creationDate < :referenceDate)))")
    public Slice<Connection> getConnectionsByActivityDate(@Param(value="atom") URI var1, @Param(value="referenceDate") Date var2, Pageable var3);

    @Query(value="select msg.parentURI from MessageEventPlaceholder msg where (((msg.senderAtomURI = :atom and msg.senderURI = msg.parentURI)    or (msg.recipientAtomURI = :atom and msg.recipientURI = msg.parentURI)) and (msg.creationDate < :referenceDate)   and (msg.messageType = :messageType)) group by msg.parentURI")
    public Slice<URI> getConnectionURIByActivityDate(@Param(value="atom") URI var1, @Param(value="messageType") WonMessageType var2, @Param(value="referenceDate") Date var3, Pageable var4);

    @Query(value="select conn from Connection conn where conn.connectionURI in (select distinct msg.parentURI  from MessageEventPlaceholder msg where (((msg.senderAtomURI = :atom and msg.senderURI = msg.parentURI)    or (msg.recipientAtomURI = :atom and msg.recipientURI = msg.parentURI)) and (msg.creationDate < :referenceDate)   and (msg.messageType = :messageType)))")
    public Slice<Connection> getConnectionsByActivityDate(@Param(value="atom") URI var1, @Param(value="messageType") WonMessageType var2, @Param(value="referenceDate") Date var3, Pageable var4);

    @Query(value="select msg.parentURI from MessageEventPlaceholder msg where (((msg.senderAtomURI = :atom and msg.senderURI = msg.parentURI)    or (msg.recipientAtomURI = :atom and msg.recipientURI = msg.parentURI))    and (msg.messageType = :messageType)) group by msg.parentURI")
    public Slice<URI> getConnectionURIByActivityDate(@Param(value="atom") URI var1, @Param(value="messageType") WonMessageType var2, Pageable var3);

    @Query(value="select conn from Connection conn where conn.connectionURI in (select distinct msg.parentURI  from MessageEventPlaceholder msg where (((msg.senderAtomURI = :atom and msg.senderURI = msg.parentURI)    or (msg.recipientAtomURI = :atom and msg.recipientURI = msg.parentURI))    and (msg.messageType = :messageType)))")
    public Slice<Connection> getConnectionsByActivityDate(@Param(value="atom") URI var1, @Param(value="messageType") WonMessageType var2, Pageable var3);

    @Query(value="select conn from Connection conn where conn.connectionURI in (select msg.parentURI from MessageEventPlaceholder msg where (((msg.senderAtomURI = :atom and msg.senderURI = msg.parentURI)    or (msg.recipientAtomURI = :atom and msg.recipientURI = msg.parentURI)) and (msg.creationDate < :referenceDate))group by msg.parentURI having max(msg.creationDate) < :resumeDate)")
    public Slice<Connection> getConnectionsBeforeByActivityDate(@Param(value="atom") URI var1, @Param(value="resumeDate") Date var2, @Param(value="referenceDate") Date var3, Pageable var4);

    @Query(value="select conn from Connection conn where conn.connectionURI in (select msg.parentURI from MessageEventPlaceholder msg where (((msg.senderAtomURI = :atom and msg.senderURI = msg.parentURI) or (msg.recipientAtomURI = :atom and msg.recipientURI = msg.parentURI))    and (msg.creationDate < :referenceDate) and (msg.messageType = :messageType))group by msg.parentURI having max(msg.creationDate) < :resumeDate)")
    public Slice<Connection> getConnectionsBeforeByActivityDate(@Param(value="atom") URI var1, @Param(value="resumeDate") Date var2, @Param(value="messageType") WonMessageType var3, @Param(value="referenceDate") Date var4, Pageable var5);

    @Query(value="select conn from Connection conn where conn.connectionURI in (select msg.parentURI from MessageEventPlaceholder msg where (((msg.senderAtomURI = :atom and msg.senderURI = msg.parentURI)    or (msg.recipientAtomURI = :atom and msg.recipientURI = msg.parentURI)) and (msg.creationDate < :referenceDate))group by msg.parentURI having max(msg.creationDate) > :resumeDate)")
    public Slice<Connection> getConnectionsAfterByActivityDate(@Param(value="atom") URI var1, @Param(value="resumeDate") Date var2, @Param(value="referenceDate") Date var3, Pageable var4);

    @Query(value="select conn from Connection conn where conn.connectionURI in (select msg.parentURI from MessageEventPlaceholder msg where (((msg.senderAtomURI = :atom and msg.senderURI = msg.parentURI) or (msg.recipientAtomURI = :atom and msg.recipientURI = msg.parentURI))    and (msg.creationDate < :referenceDate) and (msg.messageType = :messageType))group by msg.parentURI having max(msg.creationDate) > :resumeDate)")
    public Slice<Connection> getConnectionsAfterByActivityDate(@Param(value="atom") URI var1, @Param(value="resumeDate") Date var2, @Param(value="messageType") WonMessageType var3, @Param(value="referenceDate") Date var4, Pageable var5);
}

