/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.repository;

import java.net.URI;
import javax.persistence.LockModeType;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import won.protocol.model.ConnectionMessageContainer;
import won.protocol.repository.WonRepository;

public interface ConnectionMessageContainerRepository
extends WonRepository<ConnectionMessageContainer> {
    public ConnectionMessageContainer findOneByParentUri(URI var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select c from ConnectionMessageContainer c where c.parentUri = :parentUri")
    public ConnectionMessageContainer findOneByParentUriForUpdate(@Param(value="parentUri") URI var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select connection, c from Connection connection join ConnectionMessageContainer c on connection.connectionURI = c.parentUri where c.parentUri = :parentUri")
    public void lockParentAndContainerByParentUriForUpdate(@Param(value="parentUri") URI var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select c from ConnectionMessageContainer c join  MessageEventPlaceholder msg on msg.parentURI = c.parentUri where msg.messageURI = :messageUri")
    public ConnectionMessageContainer findOneByContainedMessageUriForUpdate(@Param(value="messageUri") URI var1);

    @Query(value="select case when (count(con) > 0) then true else false end from Connection con  where con.connectionURI = :connectionUri and (    con.atomURI = :webId    or con.targetAtomURI = :webId )")
    public boolean isReadPermittedForWebID(@Param(value="connectionUri") URI var1, @Param(value="webId") URI var2);
}

