/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.repository;

import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.persistence.LockModeType;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import won.protocol.model.Atom;
import won.protocol.model.AtomState;
import won.protocol.repository.WonRepository;

public interface AtomRepository
extends WonRepository<Atom> {
    public List<Atom> findByAtomURI(URI var1);

    @Query(value="select atomURI from Atom")
    public List<URI> getAllAtomURIs();

    @Query(value="select atomURI from Atom atom")
    public Slice<URI> getAllAtomURIs(Pageable var1);

    @Query(value="select atomURI from Atom atom where atom.state = :atomState")
    public Slice<URI> getAllAtomURIs(@Param(value="atomState") AtomState var1, Pageable var2);

    public Atom findOneByAtomURI(URI var1);

    public Atom findOneByAtomURIAndVersionNot(URI var1, int var2);

    @Query(value="select atomURI from Atom atom where atom.creationDate < :referenceDate")
    public Slice<URI> getAtomURIsBefore(@Param(value="referenceDate") Date var1, Pageable var2);

    @Query(value="select atomURI from Atom atom where atom.creationDate < :referenceDate and atom.state = :atomState")
    public Slice<URI> getAtomURIsBefore(@Param(value="referenceDate") Date var1, @Param(value="atomState") AtomState var2, Pageable var3);

    @Query(value="select atomURI from Atom atom where atom.creationDate > :referenceDate")
    public Slice<URI> getAtomURIsAfter(@Param(value="referenceDate") Date var1, Pageable var2);

    @Query(value="select atomURI from Atom atom where atom.creationDate > :referenceDate and atom.state = :atomState")
    public Slice<URI> getAtomURIsAfter(@Param(value="referenceDate") Date var1, @Param(value="atomState") AtomState var2, Pageable var3);

    @Query(value="select atomURI from Atom atom where atom.lastUpdate > :modifiedDate")
    public List<URI> findModifiedAtomURIsAfter(@Param(value="modifiedDate") Date var1);

    @Query(value="select state, count(*) from Connection where atomURI = :atom group by state")
    public List<Object[]> getCountsPerConnectionState(@Param(value="atom") URI var1);

    @Query(value="select state, connectionURI from Connection where atomURI = :atom")
    public List<Object[]> getConnectionUrisAndState(@Param(value="atom") URI var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select atom from Atom atom where atomURI= :uri")
    public Atom findOneByAtomURIForUpdate(@Param(value="uri") URI var1);

    @Query(value="select distinct atom from Atom atom join Connection c on ( c.atomURI = atom.atomURI ) join MessageEventPlaceholder mep on (mep.parentURI = atom.atomURI or mep.parentURI = c.connectionURI) where atom.state = 'ACTIVE' and mep.messageType <> 'ATOM_MESSAGE' and  (select count(*) from Connection con where con.atomURI = atom.atomURI and con.state = 'CONNECTED') = 0and ( mep.senderURI = c.connectionURI or mep.senderAtomURI = atom.atomURI)group by atom having max(mep.creationDate) > :startDate and max(mep.creationDate) < :endDate ")
    public Slice<Atom> findAtomsInactiveBetweenAndNotConnected(@Param(value="startDate") Date var1, @Param(value="endDate") Date var2, Pageable var3);

    @Query(value="select distinct atom from Atom atom join Connection c on ( c.atomURI = atom.atomURI ) join MessageEventPlaceholder mep on (mep.parentURI = atom.atomURI or mep.parentURI = c.connectionURI) where atom.state = 'ACTIVE' and mep.messageType <> 'ATOM_MESSAGE' and ( mep.senderURI = c.connectionURI or mep.senderAtomURI = atom.atomURI)group by atom having max(mep.creationDate) > :startDate and max(mep.creationDate) < :endDate ")
    public Slice<Atom> findAtomsInactiveBetween(@Param(value="startDate") Date var1, @Param(value="endDate") Date var2, Pageable var3);

    @Query(value="select distinct atom from Atom atom join Connection c on ( c.atomURI = atom.atomURI ) join MessageEventPlaceholder mep on (mep.parentURI = atom.atomURI or mep.parentURI = c.connectionURI) where atom.state = 'ACTIVE' and mep.messageType <> 'ATOM_MESSAGE' and  (select count(*) from Connection con where con.atomURI = atom.atomURI and con.state = 'CONNECTED') = 0and ( mep.senderURI = c.connectionURI or mep.senderAtomURI = atom.atomURI)group by atom having max(mep.creationDate) < :sinceDate")
    public Slice<Atom> findAtomsInactiveSinceAndNotConnected(@Param(value="sinceDate") Date var1, Pageable var2);

    @Query(value="select distinct atom from Atom atom join Connection c on ( c.atomURI = atom.atomURI ) join MessageEventPlaceholder mep on (mep.parentURI = atom.atomURI or mep.parentURI = c.connectionURI) where atom.state = 'ACTIVE' and mep.messageType <> 'ATOM_MESSAGE' and ( mep.senderURI = c.connectionURI or mep.senderAtomURI = atom.atomURI)group by atom having max(mep.creationDate) < :sinceDate")
    public Slice<Atom> findAtomsInactiveSince(@Param(value="sinceDate") Date var1, Pageable var2);
}

