/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.repository;

import java.net.URI;
import javax.persistence.LockModeType;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import won.protocol.model.AtomMessageContainer;
import won.protocol.repository.WonRepository;

public interface AtomMessageContainerRepository
extends WonRepository<AtomMessageContainer> {
    public AtomMessageContainer findOneByParentUri(URI var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select c from AtomMessageContainer c where c.parentUri = :parentUri")
    public AtomMessageContainer findOneByParentUriForUpdate(@Param(value="parentUri") URI var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select atom, c from Atom atom join AtomMessageContainer c on atom.atomURI = c.parentUri where c.parentUri = :parentUri")
    public void lockParentAndContainerByParentUriForUpdate(@Param(value="parentUri") URI var1);

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Query(value="select c from AtomMessageContainer c join MessageEventPlaceholder msg on msg.parentURI = c.parentUri where msg.messageURI = :messageUri")
    public AtomMessageContainer findOneByContainedMessageUriForUpdate(@Param(value="messageUri") URI var1);

    @Query(value="select case when (count(n) > 0) then true else false end from Atom n left outer join Connection con on (n.atomURI = con.atomURI)  where n.atomURI = :atomUri and (    n.atomURI = :webId or    con.targetAtomURI = :webId )")
    public boolean isReadPermittedForWebID(@Param(value="atomUri") URI var1, @Param(value="webId") URI var2);
}

