/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model.unread;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import won.protocol.model.ConnectionState;
import won.protocol.model.unread.UnreadMessageInfo;
import won.protocol.model.unread.UnreadMessageInfoForConnection;

public class UnreadMessageInfoForAtom {
    private URI atomURI;
    private UnreadMessageInfo unreadMessageInfo;
    private Map<ConnectionState, UnreadMessageInfo> unreadInfoByConnectionState;
    private Collection<UnreadMessageInfoForConnection> unreadMessageInfoForConnections;

    public UnreadMessageInfoForAtom(URI atomURI) {
        this.atomURI = atomURI;
        this.unreadInfoByConnectionState = new HashMap<ConnectionState, UnreadMessageInfo>();
        this.unreadMessageInfoForConnections = new ArrayList<UnreadMessageInfoForConnection>();
    }

    public void addUnreadMessageInfoForConnection(UnreadMessageInfoForConnection connectionInfo) {
        this.unreadMessageInfoForConnections.add(connectionInfo);
        this.unreadMessageInfo = this.aggregate(connectionInfo.getUnreadInformation(), this.unreadMessageInfo);
        this.aggregateByConnectionState(connectionInfo);
    }

    private void aggregateByConnectionState(UnreadMessageInfoForConnection connectionInfo) {
        UnreadMessageInfo info = this.unreadInfoByConnectionState.get((Object)connectionInfo.getConnectionState());
        info = this.aggregate(connectionInfo.getUnreadInformation(), info);
        this.unreadInfoByConnectionState.put(connectionInfo.getConnectionState(), info);
    }

    private UnreadMessageInfo aggregate(UnreadMessageInfo newInfo, UnreadMessageInfo aggregatedInfo) {
        if (aggregatedInfo == null) {
            return newInfo.clone();
        }
        return aggregatedInfo.aggregateWith(newInfo);
    }

    public URI getAtomURI() {
        return this.atomURI;
    }

    public Map<ConnectionState, UnreadMessageInfo> getUnreadInfoByConnectionState() {
        return this.unreadInfoByConnectionState;
    }

    public Collection<UnreadMessageInfoForConnection> getUnreadMessageInfoForConnections() {
        return this.unreadMessageInfoForConnections;
    }
}

