/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model.parentaware;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.proxy.HibernateProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.model.parentaware.ParentAware;

public class ParentAwarePersistEventListener
implements PersistEventListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final ParentAwarePersistEventListener INSTANCE = new ParentAwarePersistEventListener();

    public void onPersist(PersistEvent event) throws HibernateException {
        Object entity = event.getObject();
        if (entity instanceof ParentAware) {
            ParentAware rootAware = (ParentAware)entity;
            Object parent = rootAware.getParent();
            if (parent == null) {
                return;
            }
            if (!(parent instanceof HibernateProxy)) {
                parent.incrementVersion();
            }
            Hibernate.initialize(parent);
            event.getSession().save(parent);
            if (logger.isDebugEnabled()) {
                logger.debug("Incrementing {} entity version because a {} child entity has been inserted", parent, entity);
            }
        }
    }

    public void onPersist(PersistEvent event, Map createdAlready) throws HibernateException {
        this.onPersist(event);
    }
}

