/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model.parentaware;

import java.lang.invoke.MethodHandles;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEntityEvent;
import org.hibernate.event.spi.FlushEntityEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.model.parentaware.ParentAware;

public class ParentAwareFlushEventListener
implements FlushEntityEventListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final ParentAwareFlushEventListener INSTANCE = new ParentAwareFlushEventListener();

    public void onFlushEntity(FlushEntityEvent event) throws HibernateException {
        Object entity;
        EntityEntry entry = event.getEntityEntry();
        boolean mightBeDirty = entry.requiresDirtyCheck(entity = event.getEntity());
        if (mightBeDirty && entity instanceof ParentAware) {
            ParentAware parentAware = (ParentAware)entity;
            if (this.updated(event)) {
                Object parent = parentAware.getParent();
                if (parent == null) {
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Incrementing {} entity version because a {} child entity has been updated", parent, entity);
                }
                if (!(parent instanceof HibernateProxy)) {
                    parent.incrementVersion();
                }
                Hibernate.initialize(parent);
                event.getSession().save(parent);
            }
        }
    }

    private boolean deleted(FlushEntityEvent event) {
        return event.getEntityEntry().getStatus() == Status.DELETED;
    }

    private boolean updated(FlushEntityEvent event) {
        EntityEntry entry = event.getEntityEntry();
        Object entity = event.getEntity();
        EntityPersister persister = entry.getPersister();
        Object[] values = event.getPropertyValues();
        EventSource session = event.getSession();
        int[] dirtyProperties = event.hasDatabaseSnapshot() ? persister.findModified(event.getDatabaseSnapshot(), values, entity, (SharedSessionContractImplementor)session) : persister.findDirty(values, entry.getLoadedState(), entity, (SharedSessionContractImplementor)session);
        return dirtyProperties != null;
    }
}

