/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public enum SocketType {
    ChatSocket("wx-chat", "ChatSocket"),
    HolderSocket("wx-hold", "HolderSocket"),
    HoldableSocket("wx-hold", "HoldableSocket"),
    GroupSocket("wx-group", "GroupSocket"),
    ReviewSocket("wx-review", "ReviewSocket"),
    BuddySocket("wx-buddy", "BuddySocket"),
    CoordinatorSocket("CoordinatorSocket"),
    ParticipantSocket("ParticipantSocket"),
    CommentSocket("CommentSocket"),
    CommentModeratedSocket("CommentModeratedSocket"),
    CommentUnrestrictedSocket("CommentUnrestrictedSocket"),
    ControlSocket("ControlSocket"),
    BAPCCoordinatorSocket("BAPCCoordinatorSocket"),
    BAPCParticipantSocket("BAPCParticipantSocket"),
    BACCCoordinatorSocket("BACCCoordinatorSocket"),
    BACCParticipantSocket("BACCParticipantSocket"),
    BAAtomicPCCoordinatorSocket("BAAtomicPCCoordinatorSocket"),
    BAAtomicCCCoordinatorSocket("BAAtomicCCCoordinatorSocket");

    private static final Map<String, String> namespaces;
    private String name;
    private String nsPrefix;

    public static String[] getNames() {
        String[] ret = new String[SocketType.values().length];
        int i = 0;
        for (SocketType ft : SocketType.values()) {
            ret[i++] = ft.getURI().toString();
        }
        return ret;
    }

    public static SocketType getSocketType(URI uri) {
        if (uri.equals(ControlSocket.getURI())) {
            return ControlSocket;
        }
        if (uri.equals(GroupSocket.getURI())) {
            return GroupSocket;
        }
        if (uri.equals(ReviewSocket.getURI())) {
            return ReviewSocket;
        }
        if (uri.equals(ChatSocket.getURI())) {
            return ChatSocket;
        }
        if (uri.equals(HolderSocket.getURI())) {
            return HolderSocket;
        }
        if (uri.equals(HoldableSocket.getURI())) {
            return HoldableSocket;
        }
        if (uri.equals(CoordinatorSocket.getURI())) {
            return CoordinatorSocket;
        }
        if (uri.equals(ParticipantSocket.getURI())) {
            return ParticipantSocket;
        }
        if (uri.equals(BAPCCoordinatorSocket.getURI())) {
            return BAPCCoordinatorSocket;
        }
        if (uri.equals(BAPCParticipantSocket.getURI())) {
            return BAPCParticipantSocket;
        }
        if (uri.equals(BACCCoordinatorSocket.getURI())) {
            return BACCCoordinatorSocket;
        }
        if (uri.equals(BACCParticipantSocket.getURI())) {
            return BACCParticipantSocket;
        }
        if (uri.equals(BAAtomicPCCoordinatorSocket.getURI())) {
            return BAAtomicPCCoordinatorSocket;
        }
        if (uri.equals(BAAtomicCCCoordinatorSocket.getURI())) {
            return BAAtomicCCCoordinatorSocket;
        }
        if (uri.equals(CommentSocket.getURI())) {
            return CommentSocket;
        }
        if (uri.equals(CommentModeratedSocket.getURI())) {
            return CommentModeratedSocket;
        }
        if (uri.equals(CommentUnrestrictedSocket.getURI())) {
            return CommentUnrestrictedSocket;
        }
        return null;
    }

    private SocketType(String name) {
        this.name = name;
        this.nsPrefix = "won";
    }

    private SocketType(String prefix, String name) {
        this(name);
        this.nsPrefix = prefix;
    }

    public URI getURI() {
        String ns = namespaces.get(this.nsPrefix);
        if (ns == null) {
            throw new IllegalStateException("No namespace configured for prefix '" + this.nsPrefix + "'");
        }
        return URI.create(ns + this.name);
    }

    static {
        namespaces = new HashMap<String, String>();
        namespaces.put("wx-chat", "https://w3id.org/won/ext/chat#");
        namespaces.put("wx-hold", "https://w3id.org/won/ext/hold#");
        namespaces.put("wx-group", "https://w3id.org/won/ext/group#");
        namespaces.put("wx-review", "https://w3id.org/won/ext/review#");
        namespaces.put("wx-buddy", "https://w3id.org/won/ext/buddy#");
        namespaces.put("won", "https://w3id.org/won/core#");
    }
}

