/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model;

import java.net.URI;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import won.protocol.model.BooleanTFConverter;
import won.protocol.model.URIConverter;

@Entity
@Table(name="socket", indexes={@Index(name="IDX_UNIQUE_SOCKET", columnList="socketURI")})
public class Socket {
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Column(name="atomURI")
    @Convert(converter=URIConverter.class)
    private URI atomURI;
    @Column(name="typeURI")
    @Convert(converter=URIConverter.class)
    private URI typeURI;
    @Column(name="socketURI")
    @Convert(converter=URIConverter.class)
    private URI socketURI;
    @Column(name="defaultSocket")
    @Convert(converter=BooleanTFConverter.class)
    private boolean isDefaultSocket = false;

    public Long getId() {
        return this.id;
    }

    public URI getAtomURI() {
        return this.atomURI;
    }

    public void setAtomURI(URI atomURI) {
        this.atomURI = atomURI;
    }

    public URI getTypeURI() {
        return this.typeURI;
    }

    public void setTypeURI(URI typeURI) {
        this.typeURI = typeURI;
    }

    public URI getSocketURI() {
        return this.socketURI;
    }

    public void setSocketURI(URI socketURI) {
        this.socketURI = socketURI;
    }

    public boolean isDefaultSocket() {
        return this.isDefaultSocket;
    }

    public void setDefaultSocket(boolean isDefaultSocket) {
        this.isDefaultSocket = isDefaultSocket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Socket socket = (Socket)o;
        if (this.id != null ? !this.id.equals(socket.id) : socket.id != null) {
            return false;
        }
        if (this.atomURI != null ? !this.atomURI.equals(socket.atomURI) : socket.atomURI != null) {
            return false;
        }
        return !(this.typeURI != null ? !this.typeURI.equals(socket.typeURI) : socket.typeURI != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.atomURI != null ? this.atomURI.hashCode() : 0);
        result = 31 * result + (this.typeURI != null ? this.typeURI.hashCode() : 0);
        return result;
    }
}

