/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.model.URIConverter;

@Entity
@Table(name="rdf_models")
public class ModelHolder {
    private static final int DEFAULT_BYTE_ARRAY_SIZE = 500;
    @Transient
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Id
    @Column(name="modelURI", unique=true)
    @Convert(converter=URIConverter.class)
    private URI uri;
    @Lob
    @Column(name="model", nullable=false, length=100000)
    private byte[] modelBytes;
    @Transient
    private Model cachedModel;

    ModelHolder() {
    }

    public ModelHolder(URI uri, Model model) {
        this.uri = uri;
        this.setModel(model);
        this.cachedModel = model;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    byte[] getModelBytes() {
        return this.modelBytes;
    }

    void setModelBytes(byte[] modelBytes) {
        this.modelBytes = modelBytes;
        this.cachedModel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(Model model) {
        assert (this.uri != null) : "uri must not be null";
        assert (this.modelBytes != null) : "model must not be null";
        ByteArrayOutputStream out = new ByteArrayOutputStream(500);
        ModelHolder modelHolder = this;
        synchronized (modelHolder) {
            RDFDataMgr.write((OutputStream)out, (Model)model, (Lang)Lang.TTL);
            this.modelBytes = out.toByteArray();
            if (logger.isDebugEnabled()) {
                logger.debug("wrote model {} to byte array of length {}", (Object)this.uri, (Object)this.modelBytes.length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model getModel() {
        assert (this.uri != null) : "uri must not be null";
        assert (this.modelBytes != null) : "model must not be null";
        if (this.cachedModel != null) {
            return this.cachedModel;
        }
        ModelHolder modelHolder = this;
        synchronized (modelHolder) {
            if (this.cachedModel != null) {
                return this.cachedModel;
            }
            Model model = ModelFactory.createDefaultModel();
            ByteArrayInputStream is = new ByteArrayInputStream(this.modelBytes);
            try {
                RDFDataMgr.read((Model)model, (InputStream)is, (String)this.uri.toString(), (Lang)Lang.TTL);
            }
            catch (Exception e) {
                logger.warn("could not read model {} from byte array. Byte array is null: {}, has length {}", new Object[]{this.uri, this.modelBytes == null, this.modelBytes == null ? -1 : this.modelBytes.length});
                logger.warn("caught exception while reading model", (Throwable)e);
            }
            this.cachedModel = model;
            return model;
        }
    }
}

