/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model;

import java.net.URI;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageType;
import won.protocol.model.DatasetHolder;
import won.protocol.model.MessageContainer;
import won.protocol.model.URIConverter;
import won.protocol.model.parentaware.ParentAware;

@Entity
@Table(name="message_event", indexes={@Index(name="IDX_ME_PARENT_URI", columnList="parentURI"), @Index(name="IDX_ME_PARENT_URI_MESSAGE_TYPE", columnList="parentURI, messageType"), @Index(name="IDX_ME_PARENT_URI_REFERENCED_BY_OTHER_MESSAGE", columnList="parentURI, referencedByOtherMessage"), @Index(name="IDX_ME_INNERMOST_MESSAGE_URI_RECIPIENT_ATOM_URI", columnList="messageURI, recipientAtomURI, innermostMessageURI, correspondingRemoteMessageURI")}, uniqueConstraints={@UniqueConstraint(name="IDX_ME_UNIQUE_MESSAGE_URI", columnNames={"messageURI"}), @UniqueConstraint(name="IDX_ME_UNIQUE_CORREXPONDING_REMOTE_MESSAGE_URI", columnNames={"correspondingRemoteMessageURI"}), @UniqueConstraint(name="IDX_ME_UNIQUE_DATASETHOLDER_ID", columnNames={"datasetholder_id"})})
public class MessageEventPlaceholder
implements ParentAware<MessageContainer> {
    @Id
    @GeneratedValue
    @Column(name="id")
    @Convert(converter=URIConverter.class)
    private Long id;
    @Column(name="version", columnDefinition="integer DEFAULT 0", nullable=false)
    private int version = 0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="messagecontainer_id")
    private MessageContainer messageContainer;
    @Column(name="messageURI")
    @Convert(converter=URIConverter.class)
    private URI messageURI;
    @Column(name="parentURI")
    @Convert(converter=URIConverter.class)
    private URI parentURI;
    @Column(name="messageType")
    @Enumerated(value=EnumType.STRING)
    private WonMessageType messageType;
    @Column(name="senderURI")
    @Convert(converter=URIConverter.class)
    private URI senderURI;
    @Column(name="senderAtomURI")
    @Convert(converter=URIConverter.class)
    private URI senderAtomURI;
    @Column(name="senderNodeURI")
    @Convert(converter=URIConverter.class)
    private URI senderNodeURI;
    @Column(name="recipientURI")
    @Convert(converter=URIConverter.class)
    private URI recipientURI;
    @Column(name="recipientAtomURI")
    @Convert(converter=URIConverter.class)
    private URI recipientAtomURI;
    @Column(name="recipientNodeURI")
    @Convert(converter=URIConverter.class)
    private URI recipientNodeURI;
    @Column(name="creationDate")
    private Date creationDate;
    @Column(name="correspondingRemoteMessageURI")
    @Convert(converter=URIConverter.class)
    private URI correspondingRemoteMessageURI;
    @Column(name="responseMessageURI")
    @Convert(converter=URIConverter.class)
    private URI responseMessageURI;
    @Column(name="referencedByOtherMessage")
    private boolean referencedByOtherMessage;
    @Column(name="innermostMessageURI")
    @Convert(converter=URIConverter.class)
    private URI innermostMessageURI;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private DatasetHolder datasetHolder;

    public MessageEventPlaceholder() {
    }

    public MessageEventPlaceholder(URI parentURI, WonMessage wonMessage, MessageContainer messageContainer) {
        this.parentURI = parentURI;
        this.messageURI = wonMessage.getMessageURI();
        this.messageType = wonMessage.getMessageType();
        this.senderURI = wonMessage.getSenderURI();
        this.senderAtomURI = wonMessage.getSenderAtomURI();
        this.senderNodeURI = wonMessage.getSenderNodeURI();
        this.recipientURI = wonMessage.getRecipientURI();
        this.recipientAtomURI = wonMessage.getRecipientAtomURI();
        this.recipientNodeURI = wonMessage.getRecipientNodeURI();
        this.creationDate = new Date();
        this.correspondingRemoteMessageURI = wonMessage.getCorrespondingRemoteMessageURI();
        this.referencedByOtherMessage = false;
        this.innermostMessageURI = wonMessage.getInnermostMessageURI();
        this.messageContainer = messageContainer;
    }

    @PreUpdate
    @PrePersist
    public void incrementVersion() {
        ++this.version;
    }

    @Override
    public MessageContainer getParent() {
        return this.getMessageContainer();
    }

    public MessageContainer getMessageContainer() {
        return this.messageContainer;
    }

    public int getVersion() {
        return this.version;
    }

    @XmlTransient
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public URI getMessageURI() {
        return this.messageURI;
    }

    public void setMessageURI(URI messageURI) {
        this.messageURI = messageURI;
    }

    public URI getParentURI() {
        return this.parentURI;
    }

    public void setParentURI(URI parentURI) {
        this.parentURI = parentURI;
    }

    public WonMessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(WonMessageType messageType) {
        this.messageType = messageType;
    }

    public URI getSenderURI() {
        return this.senderURI;
    }

    public void setSenderURI(URI senderURI) {
        this.senderURI = senderURI;
    }

    public URI getSenderAtomURI() {
        return this.senderAtomURI;
    }

    public void setSenderAtomURI(URI senderAtomURI) {
        this.senderAtomURI = senderAtomURI;
    }

    public URI getSenderNodeURI() {
        return this.senderNodeURI;
    }

    public void setSenderNodeURI(URI senderNodeURI) {
        this.senderNodeURI = senderNodeURI;
    }

    public URI getRecipientURI() {
        return this.recipientURI;
    }

    public void setRecipientURI(URI recipientURI) {
        this.recipientURI = recipientURI;
    }

    public URI getRecipientAtomURI() {
        return this.recipientAtomURI;
    }

    public void setRecipientAtomURI(URI recipientAtomURI) {
        this.recipientAtomURI = recipientAtomURI;
    }

    public URI getRecipientNodeURI() {
        return this.recipientNodeURI;
    }

    public void setRecipientNodeURI(URI recipientNodeURI) {
        this.recipientNodeURI = recipientNodeURI;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public URI getCorrespondingRemoteMessageURI() {
        return this.correspondingRemoteMessageURI;
    }

    public void setCorrespondingRemoteMessageURI(URI correspondingRemoteMessageURI) {
        this.correspondingRemoteMessageURI = correspondingRemoteMessageURI;
    }

    public boolean isReferencedByOtherMessage() {
        return this.referencedByOtherMessage;
    }

    public void setReferencedByOtherMessage(boolean referencedByOtherMessage) {
        this.referencedByOtherMessage = referencedByOtherMessage;
    }

    public URI getResponseMessageURI() {
        return this.responseMessageURI;
    }

    public void setResponseMessageURI(URI responseMessageURI) {
        this.responseMessageURI = responseMessageURI;
    }

    public URI getInnermostMessageURI() {
        return this.innermostMessageURI;
    }

    public void setInnermostMessageURI(URI innermostMessageURI) {
        this.innermostMessageURI = innermostMessageURI;
    }

    public DatasetHolder getDatasetHolder() {
        return this.datasetHolder;
    }

    public void setDatasetHolder(DatasetHolder datasetHolder) {
        this.datasetHolder = datasetHolder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageEventPlaceholder)) {
            return false;
        }
        MessageEventPlaceholder that = (MessageEventPlaceholder)o;
        if (this.messageType != null ? !this.messageType.equals((Object)that.messageType) : that.messageType != null) {
            return false;
        }
        if (this.messageURI != null ? !this.messageURI.equals(that.messageURI) : that.messageURI != null) {
            return false;
        }
        if (this.recipientURI != null ? !this.recipientURI.equals(that.recipientURI) : that.recipientURI != null) {
            return false;
        }
        return !(this.senderURI != null ? !this.senderURI.equals(that.senderURI) : that.senderURI != null);
    }

    public int hashCode() {
        int result = this.messageURI != null ? this.messageURI.hashCode() : 0;
        result = 31 * result + (this.messageType != null ? this.messageType.hashCode() : 0);
        result = 31 * result + (this.senderURI != null ? this.senderURI.hashCode() : 0);
        result = 31 * result + (this.recipientURI != null ? this.recipientURI.hashCode() : 0);
        return result;
    }
}

