/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import won.protocol.model.MessageEventPlaceholder;
import won.protocol.model.URIConverter;
import won.protocol.model.parentaware.VersionedEntity;

@Entity
@Inheritance
@DiscriminatorColumn(name="parent_type")
@Table(name="message_container")
public abstract class MessageContainer
implements VersionedEntity {
    @Id
    @GeneratedValue
    @Column(name="id")
    protected Long id;
    @Column(name="parent_uri", nullable=false, unique=true, updatable=false)
    @Convert(converter=URIConverter.class)
    private URI parentUri;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="messageContainer")
    private Collection<MessageEventPlaceholder> events = new ArrayList<MessageEventPlaceholder>(1);
    @Column(name="version", columnDefinition="integer DEFAULT 0", nullable=false)
    private int version = 0;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_update", nullable=false, columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP")
    private Date lastUpdate = new Date();

    public MessageContainer() {
    }

    public MessageContainer(URI parentUri) {
        this.parentUri = parentUri;
    }

    @Override
    @PrePersist
    @PreUpdate
    public void incrementVersion() {
        ++this.version;
        this.lastUpdate = new Date();
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Collection<MessageEventPlaceholder> getEvents() {
        return this.events;
    }

    public void setEvents(Collection<MessageEventPlaceholder> events) {
        this.events = events;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public URI getParentUri() {
        return this.parentUri;
    }

    public void setParentUri(URI parentUri) {
        this.parentUri = parentUri;
    }
}

