/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import won.protocol.model.DatasetHolder;

public class DatasetHolderAggregator {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<InputStream> inputStreams = null;
    private Lang rdfLanguage = null;
    private static final Lang DEFAULT_RDF_LANGUAGE = Lang.NQUADS;
    private Dataset aggregatedDataset = null;

    public DatasetHolderAggregator() {
        this(null, null);
    }

    public DatasetHolderAggregator(List<InputStream> inputStreams, Lang rdfLanguage) {
        this.inputStreams = inputStreams == null ? new LinkedList() : inputStreams;
        this.rdfLanguage = rdfLanguage == null ? DEFAULT_RDF_LANGUAGE : rdfLanguage;
    }

    public DatasetHolderAggregator(Lang rdfLanguage) {
        this(null, rdfLanguage);
    }

    public DatasetHolderAggregator(List<InputStream> inputStreams) {
        this(inputStreams, null);
    }

    public void appendDataset(DatasetHolder datasetHolder) {
        if (this.aggregatedDataset != null) {
            throw new IllegalStateException("Cannot append a dataset after the aggregate() function was called");
        }
        this.inputStreams.add(new ByteArrayInputStream(datasetHolder.getDatasetBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset aggregate() {
        if (this.aggregatedDataset != null) {
            return this.aggregatedDataset;
        }
        DatasetHolderAggregator datasetHolderAggregator = this;
        synchronized (datasetHolderAggregator) {
            if (this.aggregatedDataset != null) {
                return this.aggregatedDataset;
            }
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            Dataset result = DatasetFactory.createGeneral();
            stopWatch.stop();
            logger.debug("init dataset: " + stopWatch.getLastTaskTimeMillis());
            stopWatch.start();
            this.aggregatedDataset = result;
            if (this.inputStreams == null || this.inputStreams.size() == 0) {
                return this.aggregatedDataset;
            }
            RDFDataMgr.read((Dataset)result, (InputStream)new SequenceInputStream(Collections.enumeration(Collections.unmodifiableCollection(this.inputStreams))), (Lang)this.rdfLanguage);
            stopWatch.stop();
            logger.debug("read dataset: " + stopWatch.getLastTaskTimeMillis());
            return this.aggregatedDataset;
        }
    }
}

