/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RiotException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.model.URIConverter;

@Entity
@Table(name="rdf_datasets")
public class DatasetHolder {
    private static final int DEFAULT_BYTE_ARRAY_SIZE = 500;
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Column(name="version", columnDefinition="integer DEFAULT 0", nullable=false)
    private int version = 0;
    @Transient
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Column(name="datasetURI", unique=true)
    @Convert(converter=URIConverter.class)
    private URI uri;
    @Lob
    @Column(name="dataset", nullable=false, length=10000000)
    private byte[] datasetBytes;
    @Transient
    private Dataset cachedDataset;

    DatasetHolder() {
    }

    public DatasetHolder(URI uri, Dataset dataset) {
        this.uri = uri;
        this.setDataset(dataset);
        this.cachedDataset = dataset;
    }

    @PreUpdate
    @PrePersist
    public void incrementVersion() {
        ++this.version;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getDatasetBytes() {
        return this.datasetBytes;
    }

    void setDatasetBytes(byte[] datasetBytes) {
        this.datasetBytes = datasetBytes;
        this.cachedDataset = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataset(Dataset dataset) {
        assert (this.uri != null) : "uri must not be null";
        assert (this.datasetBytes != null) : "model must not be null";
        ByteArrayOutputStream out = new ByteArrayOutputStream(500);
        DatasetHolder datasetHolder = this;
        synchronized (datasetHolder) {
            RDFDataMgr.write((OutputStream)out, (Dataset)dataset, (Lang)Lang.NQUADS);
            this.datasetBytes = out.toByteArray();
            this.cachedDataset = dataset;
            if (logger.isDebugEnabled()) {
                logger.debug("wrote dataset {} to byte array of length {}", (Object)this.uri, (Object)this.datasetBytes.length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset getDataset() {
        assert (this.uri != null) : "uri must not be null";
        assert (this.datasetBytes != null) : "model must not be null";
        if (this.cachedDataset != null) {
            return this.cachedDataset;
        }
        DatasetHolder datasetHolder = this;
        synchronized (datasetHolder) {
            if (this.cachedDataset != null) {
                return this.cachedDataset;
            }
            Dataset dataset = DatasetFactory.createGeneral();
            ByteArrayInputStream is = new ByteArrayInputStream(this.datasetBytes);
            try {
                try {
                    RDFDataMgr.read((Dataset)dataset, (InputStream)is, (String)this.uri.toString(), (Lang)Lang.NQUADS);
                }
                catch (RiotException ex) {
                    is = new ByteArrayInputStream(this.datasetBytes);
                    RDFDataMgr.read((Dataset)dataset, (InputStream)is, (Lang)Lang.TRIG);
                }
            }
            catch (Exception e) {
                logger.warn("could not read dataset {} from byte array. Byte array is null: {}, has length {}", new Object[]{this.uri, this.datasetBytes == null, this.datasetBytes == null ? -1 : this.datasetBytes.length});
                logger.warn("caught exception while reading dataset", (Throwable)e);
            }
            this.cachedDataset = dataset;
            return dataset;
        }
    }
}

