/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model;

public class DataWithEtag<T> {
    private T data;
    private String etag;
    private String oldEtag;
    private boolean notFound = false;
    private boolean isDeleted = false;

    public static DataWithEtag dataNotFound() {
        return new DataWithEtag<Object>(null, null, null, true, false);
    }

    public static DataWithEtag dataNotChanged(DataWithEtag data) {
        return new DataWithEtag<Object>(null, data.etag, data.oldEtag);
    }

    public static DataWithEtag dataNotChanged(String etag) {
        return new DataWithEtag<Object>(null, etag, etag);
    }

    public DataWithEtag(T data, String etag, String oldEtag, boolean notFound, boolean isDeleted) {
        this.data = data;
        this.etag = etag;
        this.oldEtag = oldEtag;
        this.notFound = notFound;
        this.isDeleted = isDeleted;
    }

    public DataWithEtag(T data, String etag, String oldEtag) {
        this(data, etag, oldEtag, false, false);
    }

    public DataWithEtag(T data, String etag, String oldEtag, boolean isDeleted) {
        this(data, etag, oldEtag, false, isDeleted);
    }

    public T getData() {
        return this.data;
    }

    public String getEtag() {
        return this.etag;
    }

    public boolean isChanged() {
        if (this.etag == null || this.oldEtag == null) {
            return true;
        }
        return !this.etag.equals(this.oldEtag);
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean isNotFound() {
        return this.notFound;
    }
}

