/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.model.ConnectionEventType;

public enum ConnectionState {
    SUGGESTED("Suggested"),
    REQUEST_SENT("RequestSent"),
    REQUEST_RECEIVED("RequestReceived"),
    CONNECTED("Connected"),
    CLOSED("Closed"),
    DELETED("Deleted");

    private static final Logger logger;
    private String name;

    private ConnectionState(String name) {
        this.name = name;
    }

    public static ConnectionState create(ConnectionEventType msg) {
        switch (msg) {
            case MATCHER_HINT: {
                return SUGGESTED;
            }
            case OWNER_OPEN: {
                return REQUEST_SENT;
            }
            case PARTNER_OPEN: {
                return REQUEST_RECEIVED;
            }
        }
        throw new IllegalArgumentException("Connection creation failed: Wrong ConnectionEventType");
    }

    public ConnectionState transit(ConnectionEventType msg) {
        switch (this) {
            case SUGGESTED: {
                switch (msg) {
                    case OWNER_OPEN: {
                        return REQUEST_SENT;
                    }
                    case PARTNER_OPEN: {
                        return REQUEST_RECEIVED;
                    }
                    case OWNER_CLOSE: {
                        return CLOSED;
                    }
                    case PARTNER_CLOSE: {
                        return CLOSED;
                    }
                }
                return this;
            }
            case REQUEST_SENT: {
                switch (msg) {
                    case PARTNER_OPEN: {
                        return CONNECTED;
                    }
                    case OWNER_CLOSE: {
                        return CLOSED;
                    }
                    case PARTNER_CLOSE: {
                        return CLOSED;
                    }
                }
                return this;
            }
            case REQUEST_RECEIVED: {
                switch (msg) {
                    case OWNER_OPEN: {
                        return CONNECTED;
                    }
                    case OWNER_CLOSE: {
                        return CLOSED;
                    }
                    case PARTNER_CLOSE: {
                        return CLOSED;
                    }
                }
                return this;
            }
            case CONNECTED: {
                switch (msg) {
                    case PARTNER_CLOSE: {
                        return CLOSED;
                    }
                    case OWNER_CLOSE: {
                        return CLOSED;
                    }
                }
                return this;
            }
            case CLOSED: {
                switch (msg) {
                    case OWNER_OPEN: {
                        return REQUEST_SENT;
                    }
                    case PARTNER_OPEN: {
                        return REQUEST_RECEIVED;
                    }
                }
                return this;
            }
        }
        return this;
    }

    public static boolean closeOnAtomDeactivate(ConnectionState state) {
        return state == CONNECTED || state == REQUEST_RECEIVED || state == REQUEST_SENT;
    }

    public URI getURI() {
        return URI.create("https://w3id.org/won/core#" + this.name);
    }

    public static ConnectionState parseString(String fragment) {
        for (ConnectionState state : ConnectionState.values()) {
            if (!state.name.equals(fragment)) continue;
            return state;
        }
        logger.warn("No enum could be matched for: {}", (Object)fragment);
        return null;
    }

    public static ConnectionState fromURI(URI uri) {
        for (ConnectionState state : ConnectionState.values()) {
            if (!state.getURI().equals(uri)) continue;
            return state;
        }
        return null;
    }

    static {
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }
}

