/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model;

import java.net.URI;
import won.protocol.model.ConnectionState;

public enum ConnectionEventType {
    OWNER_CLOSE("OwnerClose", ConnectionState.SUGGESTED, ConnectionState.REQUEST_SENT, ConnectionState.REQUEST_RECEIVED, ConnectionState.CONNECTED, ConnectionState.CLOSED),
    PARTNER_CLOSE("PartnerClose", ConnectionState.SUGGESTED, ConnectionState.REQUEST_SENT, ConnectionState.REQUEST_RECEIVED, ConnectionState.CONNECTED, ConnectionState.CLOSED),
    OWNER_OPEN("OwnerOpen", ConnectionState.SUGGESTED, ConnectionState.REQUEST_SENT, ConnectionState.REQUEST_RECEIVED, ConnectionState.CONNECTED, ConnectionState.CLOSED),
    PARTNER_OPEN("PartnerOpen", ConnectionState.SUGGESTED, ConnectionState.REQUEST_SENT, ConnectionState.REQUEST_RECEIVED, ConnectionState.CONNECTED, ConnectionState.CLOSED),
    OWNER_MESSAGE("OwnerMessage", ConnectionState.CONNECTED),
    PARTNER_MESSAGE("PartnerMessage", ConnectionState.CONNECTED),
    MATCHER_HINT("Hint", new ConnectionState[0]);

    private String name;
    private ConnectionState[] permittingStates;

    private ConnectionEventType(String name, ConnectionState ... permittingStates) {
        this.permittingStates = permittingStates;
        this.name = name;
    }

    public boolean isMessageAllowed(ConnectionState stateToCheck) {
        for (ConnectionState st : this.permittingStates) {
            if (!st.equals((Object)stateToCheck)) continue;
            return true;
        }
        return false;
    }

    public URI getURI() {
        return URI.create("https://w3id.org/won/core#" + this.name);
    }
}

