/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import won.protocol.model.Atom;
import won.protocol.model.parentaware.ParentAware;
import won.protocol.model.parentaware.VersionedEntity;

@Entity
@Table(name="connection_container")
public class ConnectionContainer
implements ParentAware<Atom>,
VersionedEntity {
    @Id
    @Column(name="id")
    protected Long id;
    @Column(name="version", columnDefinition="integer DEFAULT 0", nullable=false)
    private int version = 0;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_update", nullable=false, columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP")
    private Date lastUpdate = new Date();
    @OneToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="atom_id")
    @MapsId
    private Atom atom;

    @Override
    @PrePersist
    @PreUpdate
    public void incrementVersion() {
        ++this.version;
        this.lastUpdate = new Date();
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public Atom getAtom() {
        return this.atom;
    }

    @Override
    public Atom getParent() {
        return this.getAtom();
    }

    public void setAtom(Atom atom) {
        this.atom = atom;
    }

    public Long getId() {
        return this.id;
    }

    public ConnectionContainer(Atom atom) {
        this.atom = atom;
        if (atom != null) {
            atom.setConnectionContainer(this);
        }
    }

    public ConnectionContainer() {
    }
}

