/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model;

import java.net.URI;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import won.protocol.model.ConnectionContainer;
import won.protocol.model.ConnectionMessageContainer;
import won.protocol.model.ConnectionState;
import won.protocol.model.DatasetHolder;
import won.protocol.model.URIConverter;
import won.protocol.model.parentaware.ParentAware;
import won.protocol.model.parentaware.VersionedEntity;

@Entity
@Table(name="connection", indexes={@Index(name="IDX_CONNECTION_ATOMURI_TARGETATOMURI", columnList="atomURI, targetAtomURI")}, uniqueConstraints={@UniqueConstraint(name="IDX_CONNECTION_UNIQUE_MESSAGE_CONTAINER_ID", columnNames={"message_container_id"}), @UniqueConstraint(name="IDX_CONNECTION_UNIQUE_DATASETHOLDER_ID", columnNames={"datasetholder_id"}), @UniqueConstraint(name="IDX_UNIQUE_CONNECTION", columnNames={"atomURI", "targetAtomURI", "socketURI", "targetSocketURI"})})
public class Connection
implements ParentAware<ConnectionContainer>,
VersionedEntity {
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Column(name="version", columnDefinition="integer DEFAULT 0", nullable=false)
    private int version = 0;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_update", nullable=false, columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP")
    private Date lastUpdate = new Date();
    @Column(name="connectionURI", unique=true)
    @Convert(converter=URIConverter.class)
    private URI connectionURI;
    @Column(name="atomURI")
    @Convert(converter=URIConverter.class)
    private URI atomURI;
    @Column(name="typeURI")
    @Convert(converter=URIConverter.class)
    private URI typeURI;
    @Column(name="socketURI")
    @Convert(converter=URIConverter.class)
    private URI socketURI;
    @Column(name="targetSocketURI")
    @Convert(converter=URIConverter.class)
    private URI targetSocketURI;
    @Column(name="targetConnectionURI")
    @Convert(converter=URIConverter.class)
    private URI targetConnectionURI;
    @Column(name="targetAtomURI")
    @Convert(converter=URIConverter.class)
    private URI targetAtomURI;
    @Column(name="state")
    @Enumerated(value=EnumType.STRING)
    private ConnectionState state;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent_atom_id")
    private ConnectionContainer parent;
    @OneToOne(fetch=FetchType.LAZY)
    private DatasetHolder datasetHolder;
    @JoinColumn(name="message_container_id")
    @OneToOne(fetch=FetchType.LAZY, optional=false, cascade={CascadeType.ALL}, orphanRemoval=true)
    private ConnectionMessageContainer messageContainer = null;

    @Override
    public ConnectionContainer getParent() {
        return this.parent;
    }

    public ConnectionMessageContainer getMessageContainer() {
        return this.messageContainer;
    }

    public void setMessageContainer(ConnectionMessageContainer messageContainer) {
        this.messageContainer = messageContainer;
    }

    public void setParent(ConnectionContainer parent) {
        this.parent = parent;
    }

    @Override
    @PreUpdate
    @PrePersist
    public void incrementVersion() {
        ++this.version;
        this.lastUpdate = new Date();
    }

    public URI getTypeURI() {
        return this.typeURI;
    }

    public String toString() {
        return "Connection [id=" + this.id + ", connectionURI=" + this.connectionURI + ", atomURI=" + this.atomURI + ", typeURI=" + this.typeURI + ", socketURI=" + this.socketURI + ", targetSocketURI=" + this.targetSocketURI + ", targetConnectionURI=" + this.targetConnectionURI + ", targetAtomURI=" + this.targetAtomURI + ", state=" + (Object)((Object)this.state) + "]";
    }

    public void setTypeURI(URI typeURI) {
        this.typeURI = typeURI;
    }

    public URI getSocketURI() {
        return this.socketURI;
    }

    public void setSocketURI(URI socketURI) {
        this.socketURI = socketURI;
    }

    public URI getTargetSocketURI() {
        return this.targetSocketURI;
    }

    public void setTargetSocketURI(URI targetSocketURI) {
        this.targetSocketURI = targetSocketURI;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public URI getConnectionURI() {
        return this.connectionURI;
    }

    public void setConnectionURI(URI connectionURI) {
        this.connectionURI = connectionURI;
    }

    public URI getAtomURI() {
        return this.atomURI;
    }

    public void setAtomURI(URI atomURI) {
        this.atomURI = atomURI;
    }

    public URI getTargetConnectionURI() {
        return this.targetConnectionURI;
    }

    public void setTargetConnectionURI(URI targetConnectionURI) {
        this.targetConnectionURI = targetConnectionURI;
    }

    public URI getTargetAtomURI() {
        return this.targetAtomURI;
    }

    public void setTargetAtomURI(URI targetAtomURI) {
        this.targetAtomURI = targetAtomURI;
    }

    public ConnectionState getState() {
        return this.state;
    }

    public void setState(ConnectionState state) {
        this.state = state;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    protected void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public DatasetHolder getDatasetHolder() {
        return this.datasetHolder;
    }

    public void setDatasetHolder(DatasetHolder datasetHolder) {
        this.datasetHolder = datasetHolder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Connection)) {
            return false;
        }
        Connection that = (Connection)o;
        if (this.connectionURI != null ? !this.connectionURI.equals(that.connectionURI) : that.connectionURI != null) {
            return false;
        }
        if (this.atomURI != null ? !this.atomURI.equals(that.atomURI) : that.atomURI != null) {
            return false;
        }
        if (this.targetConnectionURI != null ? !this.targetConnectionURI.equals(that.targetConnectionURI) : that.targetConnectionURI != null) {
            return false;
        }
        if (this.targetAtomURI != null ? !this.targetAtomURI.equals(that.targetAtomURI) : that.targetAtomURI != null) {
            return false;
        }
        return this.state == that.state;
    }

    public int hashCode() {
        int result = this.connectionURI != null ? this.connectionURI.hashCode() : 0;
        result = 31 * result + (this.atomURI != null ? this.atomURI.hashCode() : 0);
        result = 31 * result + (this.targetConnectionURI != null ? this.targetConnectionURI.hashCode() : 0);
        result = 31 * result + (this.targetAtomURI != null ? this.targetAtomURI.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        return result;
    }
}

