/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AtomState {
    INACTIVE("Inactive"),
    ACTIVE("Active"),
    DELETED("Deleted");

    private static final Logger logger;
    private String name;

    private AtomState(String name) {
        this.name = name;
    }

    public URI getURI() {
        return URI.create("https://w3id.org/won/core#" + this.name);
    }

    public static AtomState parseString(String fragment) {
        for (AtomState state : AtomState.values()) {
            if (!state.name.equalsIgnoreCase(fragment)) continue;
            return state;
        }
        logger.warn("No enum could be matched for: {}", (Object)fragment);
        return null;
    }

    public static AtomState fromURI(URI uri) {
        for (AtomState state : AtomState.values()) {
            if (!state.getURI().equals(uri)) continue;
            return state;
        }
        return null;
    }

    static {
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }
}

