/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model;

import java.net.URI;
import java.util.Date;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.model.Atom;
import won.protocol.model.AtomState;
import won.protocol.util.DateTimeUtils;
import won.protocol.util.ModelMapper;
import won.protocol.vocabulary.WON;

public class AtomModelMapper
implements ModelMapper<Atom> {
    final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Model toModel(Atom atom) {
        Literal lastUpdate;
        Model model = ModelFactory.createDefaultModel();
        Resource atomResource = model.createResource(atom.getAtomURI().toString(), WON.Atom);
        Literal creationDate = DateTimeUtils.toLiteral(atom.getCreationDate(), model);
        if (creationDate != null) {
            model.add(model.createStatement(atomResource, DCTerms.created, (RDFNode)creationDate));
        }
        if ((lastUpdate = DateTimeUtils.toLiteral(atom.getLastUpdate(), model)) != null) {
            model.add(model.createStatement(atomResource, DCTerms.modified, (RDFNode)lastUpdate));
        }
        model.add(model.createStatement(atomResource, WON.atomState, (RDFNode)WON.toResource(atom.getState())));
        return model;
    }

    @Override
    public Atom fromModel(Model model) {
        Atom atom = new Atom();
        ResIterator atomIt = model.listSubjectsWithProperty(RDF.type, (RDFNode)WON.Atom);
        if (!atomIt.hasNext()) {
            throw new IllegalArgumentException("at least one RDF node must be of type won:Atom");
        }
        Resource atomRes = (Resource)atomIt.next();
        this.logger.debug("processing atom resource {}", (Object)atomRes.getURI());
        atom.setAtomURI(URI.create(atomRes.getURI()));
        Statement dateStat = atomRes.getProperty(DCTerms.created);
        if (dateStat != null && dateStat.getObject().isLiteral()) {
            atom.setCreationDate(DateTimeUtils.toDate(dateStat.getObject().asLiteral(), model));
            this.logger.debug("found atomCreationDate literal value '{}'", (Object)dateStat.getObject().asLiteral().getString());
        } else {
            this.logger.debug("no atomCreationDate property found for atom resource {}", (Object)atomRes.getURI());
        }
        Statement stateStat = atomRes.getProperty(WON.atomState);
        if (stateStat != null && stateStat.getObject().isResource()) {
            URI uri = URI.create(stateStat.getResource().getURI());
            atom.setState(AtomState.parseString(uri.getFragment()));
            this.logger.debug("found atomState literal value '{}'", (Object)stateStat.getObject().asResource().getURI());
        } else {
            this.logger.debug("no atomState property found for atom resource {}", (Object)atomRes.getURI());
        }
        atom.setWonNodeURI(URI.create(atomRes.getPropertyResourceValue(WON.wonNode).toString()));
        Date lastUpdate = DateTimeUtils.parse(atomRes.getProperty(DCTerms.modified).getString(), model);
        atom.setLastUpdate(lastUpdate);
        return atom;
    }
}

