/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.model;

import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import won.protocol.model.AtomMessageContainer;
import won.protocol.model.AtomState;
import won.protocol.model.ConnectionContainer;
import won.protocol.model.DatasetHolder;
import won.protocol.model.OwnerApplication;
import won.protocol.model.URIConverter;
import won.protocol.model.parentaware.VersionedEntity;

@Entity
@Table(name="atom", uniqueConstraints={@UniqueConstraint(name="IDX_ATOM_UNIQUE_MESSAGE_CONTAINER_ID", columnNames={"message_container_id"}), @UniqueConstraint(name="IDX_ATOM_UNIQUE_DATASETHOLDER_ID", columnNames={"datatsetholder_id"})})
public class Atom
implements VersionedEntity {
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Column(name="version", columnDefinition="integer DEFAULT 0", nullable=false)
    private int version = 0;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_update", nullable=false, columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP")
    private Date lastUpdate;
    @Column(name="atomURI", unique=true)
    @Convert(converter=URIConverter.class)
    protected URI atomURI;
    @Column(name="state")
    @Enumerated(value=EnumType.STRING)
    private AtomState state;
    @Column(name="ownerURI")
    @Convert(converter=URIConverter.class)
    private URI ownerURI;
    @Column(name="wonNodeURI")
    @Convert(converter=URIConverter.class)
    private URI wonNodeURI;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="creationDate", nullable=false)
    private Date creationDate;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private DatasetHolder datatsetHolder;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<DatasetHolder> attachmentDatasetHolders;
    @ManyToMany(targetEntity=OwnerApplication.class, fetch=FetchType.EAGER)
    @JoinTable(name="ATOM_OWNERAPP", joinColumns={@JoinColumn(name="atom_id")}, inverseJoinColumns={@JoinColumn(name="owner_application_id")}, uniqueConstraints={@UniqueConstraint(name="IDX_NO_UNIQUE_ATOM_ID_OWNER_APPLICATION_ID", columnNames={"atom_id", "owner_application_id"})}, indexes={@Index(name="IDX_NO_ATOM_ID", columnList="atom_id")})
    private List<OwnerApplication> authorizedApplications;
    @JoinColumn(name="message_container_id")
    @OneToOne(fetch=FetchType.LAZY, optional=false, cascade={CascadeType.ALL}, orphanRemoval=true)
    private AtomMessageContainer messageContainer;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="atom", cascade={CascadeType.ALL}, orphanRemoval=true)
    private ConnectionContainer connectionContainer;

    public AtomMessageContainer getMessageContainer() {
        return this.messageContainer;
    }

    @Override
    @PreUpdate
    public void incrementVersion() {
        ++this.version;
        if (this.state != AtomState.DELETED) {
            this.lastUpdate = new Date();
        }
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    protected void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    public void setMessageContainer(AtomMessageContainer messageContainer) {
        this.messageContainer = messageContainer;
    }

    public void setConnectionContainer(ConnectionContainer connectionContainer) {
        this.connectionContainer = connectionContainer;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public ConnectionContainer getConnectionContainer() {
        return this.connectionContainer;
    }

    @PrePersist
    protected void onCreate() {
        this.lastUpdate = this.creationDate = new Date();
        this.incrementVersion();
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        this.lastUpdate = creationDate;
    }

    @XmlTransient
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public URI getAtomURI() {
        return this.atomURI;
    }

    public void setAtomURI(URI URI2) {
        this.atomURI = URI2;
    }

    public AtomState getState() {
        return this.state;
    }

    public void setState(AtomState state) {
        this.state = state;
    }

    public URI getOwnerURI() {
        return this.ownerURI;
    }

    public void setOwnerURI(URI ownerURI) {
        this.ownerURI = ownerURI;
    }

    public DatasetHolder getDatatsetHolder() {
        return this.datatsetHolder;
    }

    public void setDatatsetHolder(DatasetHolder datatsetHolder) {
        this.datatsetHolder = datatsetHolder;
    }

    public List<DatasetHolder> getAttachmentDatasetHolders() {
        return this.attachmentDatasetHolders;
    }

    public void setAttachmentDatasetHolders(List<DatasetHolder> attachmentDatasetHolders) {
        this.attachmentDatasetHolders = attachmentDatasetHolders;
    }

    public String toString() {
        return "Atom{id=" + this.id + ", atomURI=" + this.atomURI + ", state=" + (Object)((Object)this.state) + ", ownerURI=" + this.ownerURI + ", creationDate=" + this.creationDate + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Atom)) {
            return false;
        }
        Atom atom = (Atom)o;
        if (this.atomURI != null ? !this.atomURI.equals(atom.atomURI) : atom.atomURI != null) {
            return false;
        }
        if (this.ownerURI != null ? !this.ownerURI.equals(atom.ownerURI) : atom.ownerURI != null) {
            return false;
        }
        if (this.creationDate != null ? !this.creationDate.equals(atom.creationDate) : atom.creationDate != null) {
            return false;
        }
        return this.state == atom.state;
    }

    public int hashCode() {
        int result = this.atomURI.hashCode();
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + this.ownerURI.hashCode();
        result = 31 * result + this.creationDate.hashCode();
        return result;
    }

    public void resetAllAtomData() {
        this.attachmentDatasetHolders = null;
        this.authorizedApplications = null;
        this.connectionContainer = null;
        this.creationDate = new Date(0L);
        this.lastUpdate = new Date(0L);
        this.ownerURI = null;
    }

    public List<OwnerApplication> getAuthorizedApplications() {
        return this.authorizedApplications;
    }

    public void setAuthorizedApplications(List<OwnerApplication> authorizedApplications) {
        this.authorizedApplications = authorizedApplications;
    }

    public URI getWonNodeURI() {
        return this.wonNodeURI;
    }

    public void setWonNodeURI(URI wonNodeURI) {
        this.wonNodeURI = wonNodeURI;
    }
}

