/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message.processor.impl;

import java.lang.invoke.MethodHandles;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.Lang;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.message.WonMessage;
import won.protocol.message.processor.WonMessageProcessor;
import won.protocol.message.processor.exception.WonMessageNotWellFormedException;
import won.protocol.message.processor.exception.WonMessageProcessingException;
import won.protocol.util.RdfUtils;
import won.protocol.validation.WonMessageValidator;

public class WellformednessCheckingWonMessageProcessor
implements WonMessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    WonMessageValidator validator = new WonMessageValidator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WonMessage process(WonMessage message) throws WonMessageProcessingException {
        Dataset dataset = message.getCompleteDataset();
        StringBuilder errorMessage = new StringBuilder("Message is not valid, failed at check ");
        boolean valid = false;
        try {
            dataset.getLock().enterCriticalSection(true);
            valid = this.validator.validate(dataset, errorMessage);
        }
        finally {
            dataset.getLock().leaveCriticalSection();
        }
        if (!valid) {
            logger.info(errorMessage.toString() + ". More info on loglevel 'debug'", (Object)message.getMessageURI());
            if (logger.isDebugEnabled()) {
                logger.debug("Offending message:\n" + RdfUtils.writeDatasetToString(dataset, Lang.TRIG));
            }
            throw new WonMessageNotWellFormedException(errorMessage.toString());
        }
        return message;
    }
}

