/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message.processor.impl;

import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageType;
import won.protocol.message.processor.WonMessageProcessor;
import won.protocol.message.processor.exception.UriAlreadyInUseException;
import won.protocol.message.processor.exception.UriNodePathException;
import won.protocol.service.WonNodeInfo;
import won.protocol.service.WonNodeInformationService;
import won.protocol.util.WonRdfUtils;

public class UriConsistencyCheckingWonMessageProcessor
implements WonMessageProcessor {
    @Autowired
    protected WonNodeInformationService wonNodeInformationService;

    @Override
    public WonMessage process(WonMessage message) throws UriAlreadyInUseException {
        URI senderNode = message.getSenderNodeURI();
        URI recipientNode = message.getRecipientNodeURI();
        WonNodeInfo senderNodeInfo = null;
        WonNodeInfo recipientNodeInfo = null;
        if (senderNode != null && !message.getMessageType().isHintMessage()) {
            senderNodeInfo = this.wonNodeInformationService.getWonNodeInformation(senderNode);
        }
        if (recipientNode != null) {
            recipientNodeInfo = this.wonNodeInformationService.getWonNodeInformation(recipientNode);
        }
        WonNodeInfo localNodeInfo = null;
        WonNodeInfo remoteNodeInfo = null;
        URI msgUri = message.getMessageURI();
        if (msgUri.getScheme().equals(senderNode.getScheme()) && msgUri.getAuthority().equals(senderNode.getAuthority())) {
            localNodeInfo = senderNodeInfo;
            remoteNodeInfo = recipientNodeInfo;
        } else if (msgUri.getScheme().equals(recipientNode.getScheme()) && msgUri.getAuthority().equals(recipientNode.getAuthority())) {
            localNodeInfo = recipientNodeInfo;
            remoteNodeInfo = senderNodeInfo;
        }
        URI localNode = URI.create(localNodeInfo.getWonNodeURI());
        this.checkHasNode(message, localNode);
        this.checkLocalEventURI(message, localNodeInfo);
        this.checkRemoteEventURI(message, remoteNodeInfo);
        this.checkCreateMsgAtomURI(message, localNodeInfo);
        this.checkSenders(senderNodeInfo, message);
        this.checkReceivers(recipientNodeInfo, message);
        this.checkDirection(message, localNode);
        return message;
    }

    private void checkHasNode(WonMessage message, URI localNode) {
        if (!localNode.equals(message.getSenderNodeURI()) && !localNode.equals(message.getRecipientNodeURI())) {
            throw new UriNodePathException("neither sender nor receiver is " + localNode);
        }
    }

    private void checkReceivers(WonNodeInfo recipientNodeInfo, WonMessage message) {
        this.checkNodeConformance(recipientNodeInfo, message.getRecipientAtomURI(), message.getRecipientURI(), null);
    }

    private void checkSenders(WonNodeInfo senderNodeInfo, WonMessage message) {
        this.checkNodeConformance(senderNodeInfo, message.getSenderAtomURI(), message.getSenderURI(), null);
    }

    private void checkDirection(WonMessage message, URI localNode) {
        WonMessageDirection direction = message.getEnvelopeType();
        URI recipientNode = message.getRecipientNodeURI();
        URI senderNode = message.getSenderNodeURI();
        switch (direction) {
            case FROM_EXTERNAL: {
                if (localNode.equals(recipientNode)) break;
                throw new UriNodePathException(recipientNode + " is expected to be " + localNode);
            }
            case FROM_OWNER: {
                if (localNode.equals(senderNode)) break;
                throw new UriNodePathException(senderNode + " is expected to be " + localNode);
            }
            case FROM_SYSTEM: {
                if (localNode.equals(senderNode)) break;
                throw new UriNodePathException(senderNode + " is expected to be " + localNode);
            }
        }
    }

    private void checkLocalEventURI(WonMessage message, WonNodeInfo localNodeInfo) {
        this.checkNodeConformance(localNodeInfo, null, null, message.getMessageURI());
    }

    private void checkRemoteEventURI(WonMessage message, WonNodeInfo remoteNodeInfo) {
        this.checkNodeConformance(remoteNodeInfo, null, null, message.getCorrespondingRemoteMessageURI());
    }

    private void checkCreateMsgAtomURI(WonMessage message, WonNodeInfo localNodeInfo) {
        if (message.getMessageType() == WonMessageType.CREATE_ATOM) {
            URI atomURI = WonRdfUtils.AtomUtils.getAtomURI(message.getCompleteDataset());
            this.checkNodeConformance(localNodeInfo, atomURI, null, null);
        }
    }

    private void checkNodeConformance(WonNodeInfo info, URI atomURI, URI connURI, URI eventURI) {
        if (info == null) {
            return;
        }
        if (atomURI == null && connURI == null && eventURI == null) {
            return;
        }
        String atomPrefix = info.getAtomURIPrefix();
        String connPrefix = info.getConnectionURIPrefix();
        String eventPrefix = info.getEventURIPrefix();
        if (atomURI != null) {
            this.checkPrefix(atomURI, atomPrefix);
        }
        if (connURI != null) {
            this.checkPrefix(connURI, connPrefix);
        }
        if (eventURI != null) {
            this.checkPrefix(eventURI, eventPrefix);
        }
    }

    private String getPrefix(URI atomURI) {
        return atomURI.toString().substring(0, atomURI.toString().lastIndexOf("/"));
    }

    private void checkPrefix(URI uri, String expectedPrefix) {
        String prefix = this.getPrefix(uri);
        if (!prefix.equals(expectedPrefix)) {
            throw new UriNodePathException("URI '" + uri + "' does not start with the expected prefix '" + expectedPrefix + "'");
        }
    }
}

