/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message.processor.camel;

import java.lang.invoke.MethodHandles;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.message.WonMessage;
import won.protocol.message.processor.WonMessageProcessor;

public class WonMessageProcessorCamelAdapter
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static String WON_MESSAGE_HEADER = "wonMessage";
    private WonMessageProcessor adaptee;

    protected WonMessageProcessorCamelAdapter(WonMessageProcessor adaptee) {
        this.adaptee = adaptee;
    }

    public void process(Exchange exchange) throws Exception {
        Object msg = exchange.getIn().getHeader(WON_MESSAGE_HEADER);
        if (msg == null) {
            throw new IllegalArgumentException("expected a WonMessage object in the '" + WON_MESSAGE_HEADER + " header but header was null");
        }
        if (!(msg instanceof WonMessage)) {
            throw new IllegalArgumentException("expected a WonMessage object in the '" + WON_MESSAGE_HEADER + " header but the object is of type " + msg.getClass());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("calling adaptee {} with message {} (type: {}, direction: {}, recipient: {})", new Object[]{this.adaptee, msg, ((WonMessage)msg).getMessageType(), ((WonMessage)msg).getEnvelopeType(), ((WonMessage)msg).getRecipientURI()});
        }
        WonMessage resultMsg = null;
        try {
            resultMsg = this.adaptee.process((WonMessage)msg);
            if (logger.isDebugEnabled()) {
                logger.debug("returning from adaptee {} with message {} (type: {}, direction: {}, recipient: {})", new Object[]{this.adaptee, msg, ((WonMessage)msg).getMessageType(), ((WonMessage)msg).getEnvelopeType(), ((WonMessage)msg).getRecipientURI()});
            }
        }
        catch (Exception e) {
            logger.info("re-throwing exception {} caught calling adaptee {} with message {} (type: {}, direction: {}, recipient:{})", new Object[]{e, this.adaptee, msg, ((WonMessage)msg).getMessageType(), ((WonMessage)msg).getEnvelopeType(), ((WonMessage)msg).getRecipientURI()});
            throw e;
        }
        exchange.getIn().setHeader(WON_MESSAGE_HEADER, (Object)resultMsg);
    }
}

