/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message.processor.camel;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.jena.riot.Lang;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDecoder;
import won.protocol.message.processor.exception.WonMessageProcessingException;

public class WonMessageIntoCamelProcessor
implements Processor {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public void process(Exchange exchange) throws Exception {
        this.logger.debug("processing won message");
        Map headers = exchange.getIn().getHeaders();
        WonMessage wonMessage = (WonMessage)headers.get("wonMessage");
        if (wonMessage == null) {
            try {
                wonMessage = WonMessageDecoder.decode(Lang.TRIG, exchange.getIn().getBody().toString());
            }
            catch (Exception e) {
                this.logger.info("could not decode message as TriG, ignoring it (the offending message is logged at loglevel 'DEBUG')", (Throwable)e);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("offending message: {}", (Object)exchange.getIn().getBody().toString());
                }
                exchange.setProperty("CamelRouteStop", (Object)Boolean.TRUE);
                throw new WonMessageProcessingException("Could not decode message", e);
            }
        }
        if (wonMessage == null) {
            throw new WonMessageProcessingException("No WonMessage found in header 'wonMessage' or in the body");
        }
        exchange.getIn().setHeader("wonMessageType", (Object)URI.create(wonMessage.getMessageType().getResource().getURI()));
        exchange.getIn().setHeader("wonMessage", (Object)wonMessage);
        exchange.getIn().setBody(null);
    }
}

