/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message.processor.camel;

import java.io.StringWriter;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.message.WonMessage;
import won.protocol.message.processor.exception.WonMessageProcessingException;

public class WonMessageFromHeaderToBodySerializingCamelProcessor
implements Processor {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public void process(Exchange exchange) throws Exception {
        this.logger.debug("processing won message");
        Map headers = exchange.getIn().getHeaders();
        WonMessage wonMessage = (WonMessage)headers.get("wonMessage");
        if (wonMessage == null) {
            throw new WonMessageProcessingException("No WonMessage found in header 'wonMessage'");
        }
        StringWriter writer = new StringWriter();
        RDFDataMgr.write((StringWriter)writer, (Dataset)wonMessage.getCompleteDataset(), (Lang)Lang.TRIG);
        exchange.getIn().setBody((Object)writer.toString());
        this.logger.debug("wrote serialized wonMessage to message body");
    }
}

