/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.message.processor.camel;

import java.net.URI;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.springframework.beans.factory.annotation.Autowired;
import won.protocol.message.WonMessage;
import won.protocol.message.processor.exception.MissingMessagePropertyException;
import won.protocol.message.processor.exception.WonMessageProcessingException;
import won.protocol.model.Connection;
import won.protocol.repository.ConnectionRepository;
import won.protocol.vocabulary.WONMSG;

public class SocketTypeExtractingCamelProcessor
implements Processor {
    @Autowired
    ConnectionRepository connectionRepository;

    public void process(Exchange exchange) throws Exception {
        URI socketType = null;
        WonMessage wonMessage = (WonMessage)exchange.getIn().getHeader("wonMessage");
        URI conUri = (URI)exchange.getIn().getHeader("wonConnectionURI");
        if (conUri == null) {
            throw new MissingMessagePropertyException(URI.create(WONMSG.recipient.getURI().toString()));
        }
        Connection con = this.connectionRepository.findOneByConnectionURI(conUri);
        socketType = con.getTypeURI();
        if (socketType == null) {
            throw new WonMessageProcessingException(String.format("Failed to determine connection socket for message %s", wonMessage.getMessageURI()));
        }
        exchange.getIn().setHeader("wonSocketType", (Object)socketType);
    }
}

